/*
 * Decompiled with CFR 0.152.
 */
import com.fazecast.jSerialComm.SerialPort;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.DateUtilities;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;

public class MountMonitor
implements ItemListener,
ActionListener {
    boolean m_TestModeSimulateMount = false;
    boolean m_TestModeSimulateSeismometer = false;
    boolean m_TestDataEqualsZero = false;
    boolean m_RequestAxialSpeed = false;
    boolean m_ShowAxialSpeed = false;
    boolean m_ShowAxialSpeedAsDisplacement = false;
    boolean m_HasSeismometer = true;
    boolean m_HadSeismometer = false;
    boolean m_ShowSeismometer = true;
    boolean m_FoundSeismometer = false;
    String m_VersionNo = "v.3.35";
    String m_VersionDate = "200720";
    String m_Version = "(" + this.m_VersionNo + " " + this.m_VersionDate + ")";
    String m_EMail = "";
    String m_NistTimeServer = "time.windows.com";
    boolean m_UseNistTimeServer = true;
    boolean m_NistTimeServerFailed = false;
    boolean m_LogUpdateNistTimeServerFailed = false;
    boolean m_LogUpdateNistTimeServerReconnected = false;
    int m_NistTimeServerPollingInterval = 10;
    ArrayList<int[]> m_CheckMountSettingsIndexesList = new ArrayList();
    Boolean m_CheckMountSettings = true;
    String[][] m_MountCommandSet = new String[][]{{"Get status", ":Gstat#", "Tracking~Slewing", "Status", "1", "0", "1", "ext", "2.8.8", "", "", ""}, {"Get local time", ":GL#", "UTCDate", "Time", "1", "0", "1", "std", "0.0.0", "", "", ""}, {"Get right ascension", ":GR#", "RightAscension", "Right ascension", "1", "1", "1", "std", "0.0.0", "", "", ""}, {"Get declination", ":GD#", "Declination", "Declination", "1", "1", "1", "std", "0.0.0", "", "", ""}, {"Get RA angular position", ":GaXa#", "", "RA Angular position", "1", "0", "1", "ext", "2.9.9", "", "", ""}, {"Get DEC angular position", ":GaXb#", "", "DEC Angular position", "1", "0", "1", "ext", "2.9.9", "", "", ""}, {"Get align info", ":getain#", "", "Align info", "1", "0", "0", "ext", "2.14.20", "", "", ""}, {"Get product name", ":GVP#", "Name", "Mount", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get firmware number.", ":GVN#", "DriverVersion", "Firmware", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get mount ID", ":GETID#", "Name", "Mount ID", "1", "0", "0", "ext", "2.9.11", "", "", ""}, {"Get azimuth", ":GZ#", "Azimuth", "Azimuth", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get altitude", ":GA#", "Altitude", "Altitude", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get side of the pier", ":pS#", "SideOfPier", "Pier side", "1", "0", "0", "ext", "0.0.0", "", "", ""}, {"Set high resolution", ":U2#", "", "Resolution", "0", "0", "0", "ext", "2.10.0", "", "", ""}, {"Get mount latitude", ":Gt#", "SiteLatitude", "Latitude", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get mount longitude", ":Gg#", "SiteLongitude", "Longitude", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get mount elevation", ":Gev#", "SiteElevation", "Elevation", "1", "0", "0", "ext", "2.9.9", "", "", ""}, {"Get UTC offset", ":GG#", "", "UTC Offset", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get target right ascension", ":Gr#", "TargetRightAscension", "Target Right ascension", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get target declination", ":Gd#", "TargetDeclination", "Target Declination", "1", "0", "0", "std", "0.0.0", "", "", ""}, {"Get Park status", "", "AtPark", "Parked", "1", "0", "0", "ext", "", "", "", ""}, {"Get seismic", "", "", "Seismic", "0", "1", "0", "ext", "", "", "", ""}, {"Get Delta Time", "", "", "not used!", "0", "0", "0", "ext", "", "", "", ""}, {"Check refraction setting", ":GREF#", "DoesRefraction", "Refraction Correction", "2", "0", "2", "ext", "2.10.0", "Disabled~Enabled", "0~1", "false~true"}, {"Check refraction", ":WSG#", "", "Refraction Status", "1", "0", "2", "ext", "2.10.0", "Not updating~Not updating while tracking~Continuously updating", "0~1~2", ""}, {"Check GPS clock synch", ":gtg#", "", "GPS clock synch status", "1", "0", "2", "ext", "0.0.0", "Not synchronising~Synchronising", "0~1", ""}, {"Check Dual Tracking status", ":Gdat#", "", "Dual Tracking status", "2", "0", "2", "ext", "2.13.9", "Disabled~Enabled", "0~1", ""}, {"Check Tracking Rate", ":GT#", "RightAscensionRate", "Tracking Rate", "1", "0", "2", "ext", "0.0.0", "Sidereal", ":PRlist#", "0.0"}, {"Check Tracking 10Micron Rate 1", ":PRclr#", "", "Tracking Rate (1)", "0", "0", "0", "ext", "0.0.0", "", "", ""}, {"Check Tracking 10Micron Rate 2", ":PRlist#", "", "Tracking Rate (2)", "1", "0", "0", "ext", "0.0.0", "", "", ""}};
    static final int STADATA = 0;
    static final int TIMDATA = 1;
    static final int RASDATA = 2;
    static final int DECDATA = 3;
    static final int GXADATA = 4;
    static final int GXBDATA = 5;
    static final int ALIDATA = 6;
    static final int PRODATA = 7;
    static final int FIRDATA = 8;
    static final int MIDDATA = 9;
    static final int AZIDATA = 10;
    static final int ALTDATA = 11;
    static final int SIDDATA = 12;
    static final int RESDATA = 13;
    static final int LATDATA = 14;
    static final int LONDATA = 15;
    static final int ELEDATA = 16;
    static final int UTCDATA = 17;
    static final int TRADATA = 18;
    static final int TDEDATA = 19;
    static final int PARDATA = 20;
    static final int SEIDATA = 21;
    static final int DTIDATA = 22;
    static final int REFDATA = 23;
    static final int RSTDATA = 24;
    static final int GPSDATA = 25;
    static final int DATDATA = 26;
    static final int TRRDATA = 27;
    static final int TR1DATA = 28;
    static final int TR2DATA = 29;
    static final int DESTCOL = 0;
    static final int LX20COL = 1;
    static final int ASCOCOL = 2;
    static final int DESLCOL = 3;
    static final int RETDCOL = 4;
    static final int STATCOL = 5;
    static final int SEQUCOL = 6;
    static final int TYPECOL = 7;
    static final int FIWACOL = 8;
    static final int RONACOL = 9;
    static final int LXROCOL = 10;
    static final int ASROCOL = 11;
    static final int CMDMODELX200 = 0;
    static final int CMDMODEASCOM = 1;
    int m_CommandMode = 1;
    Dispatch m_Dispatch;
    Dispatch m_TheScopeDispatch;
    String m_ASCOMScopeId = "";
    int m_CommandRotator = -1;
    int m_CommandRotatorFirstVal = 0;
    JFrame m_Frame;
    int m_FrameWidth = 1200;
    int m_FrameHeight = 690;
    int m_FrameX = 100;
    int m_FrameY = 100;
    Insets m_FrameInsets;
    int m_TextAreaHeight = 0;
    int m_FFTBoxWidth = 450;
    int m_FFTBoxHeight = 200;
    int m_FFTBoxX = (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(this.m_FFTBoxWidth / 2));
    int m_FFTBoxY = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)this.m_FFTBoxHeight);
    public Graphics2D m_RaGraphGraphics;
    public Graphics2D m_DecGraphGraphics;
    public Graphics2D m_TimeGraphGraphics;
    public Graphics2D m_SeisGraphGraphics;
    public Graphics2D FTGraphGraphics;
    public Image m_FTGraphImg = null;
    public Image m_RaGraphImg = null;
    public Image m_DecGraphImg = null;
    public Image m_TimeGraphImg = null;
    public Image m_SeisGraphImg = null;
    public GraphPanel m_RaGraphPanel;
    public GraphPanel m_DecGraphPanel;
    public GraphPanel m_TimeGraphPanel;
    public GraphPanel m_SeisGraphPanel;
    public JPanel resultGraphPanel;
    public FTPanel FFTGraphPanel;
    int m_GraphPanelSpacing = 3;
    int m_GraphPanelWidth;
    int m_GraphPanelHeight;
    boolean m_IsFirstFrame = true;
    int m_MountStatus = 0;
    int m_MountStatusOld = -999;
    public int NUMGRAPHS = 3;
    public double GRAPHRATIO = (double)this.NUMGRAPHS * 1.0;
    public double TEXTBOXRATIO = 1.0;
    public double TOTALRATIO = 1.0 * (double)this.NUMGRAPHS * this.GRAPHRATIO + this.TEXTBOXRATIO;
    JEditorPane m_TextInput;
    JEditorPane m_TextOutput;
    JEditorPane m_TextStatus;
    String[] m_TextBox = new String[]{"", "", ""};
    boolean[] m_SerialPortItem = new boolean[12];
    JCheckBoxMenuItem[] m_PollingModeMenuItem = new JCheckBoxMenuItem[6];
    JCheckBoxMenuItem[] m_HorZoomModeMenuItem = new JCheckBoxMenuItem[6];
    JCheckBoxMenuItem[] m_VerZoomModeMenuItem = new JCheckBoxMenuItem[4];
    JMenu m_Menu;
    JMenu m_PrefsMenu;
    JMenu m_HelpMenu;
    JMenu m_FTMenu;
    JMenuBar m_MenuBar;
    JMenuItem[] m_ResetMenuItem = new JMenuItem[4];
    JMenuItem m_HelpMenuItem;
    JMenuItem m_AboutMenuItem;
    JMenuItem m_PrefsMenuItem;
    JMenuItem m_FFTPeriodMenuItem;
    JMenuItem m_FFTFrequencyMenuItem;
    JCheckBoxMenuItem[] m_ToleranceRaDecModeMenuItem = new JCheckBoxMenuItem[12];
    JCheckBoxMenuItem[] m_LoggingModeMenuItem = new JCheckBoxMenuItem[2];
    boolean m_AllowUpdateWindowComponents = false;
    double m_ToleranceRaDec = 0.0;
    double m_ToleranceSeismometer = 0.0;
    boolean m_ToleranceSeismometerExceededY = false;
    int m_ToleranceSeismometerExceededYCounter = 0;
    boolean[] m_ToleranceRaDecExceededY;
    boolean[] m_ToleranceRaDecExceededSD;
    Socket m_Socket = null;
    OutputStream m_Output = null;
    PrintWriter m_Writer = null;
    InputStream m_Input = null;
    InputStreamReader m_Reader = null;
    String m_MountName = "10Micron";
    String m_Firmware = "0.00.00";
    String m_MountID = "00000000000000000000";
    String m_Sitename = "My Observatory";
    double m_Latitude = 0.0;
    double m_Longitude = 0.0;
    double m_Elevation = 0.0;
    double m_MountUTCOffset = 0.0;
    double m_TargetRA = 0.0;
    double m_TargetDEC = 0.0;
    Boolean m_InitASCOMTargetCoordinates = true;
    Boolean m_ASCOMForceChooser = false;
    String m_MountTCPIPAdress = "10.0.0.10";
    String m_PierSide = "";
    String m_Altitude = "";
    String m_Azimuth = "";
    int m_PrefsSerialPortIndex;
    int m_MountTCPIPPort = 3492;
    int m_Timeout = 1000;
    boolean m_ServerIsActive = false;
    int m_ToleranceRaDecModeIndex = 0;
    boolean m_UseAsHATolerance = false;
    boolean m_AdjustGraphsForRunningRangeLength = false;
    int m_ToleranceSeismometerModeIndex = 0;
    int m_WindowRatioModeIndex = 0;
    int m_ProtocolModeIndex = 0;
    int m_LogModeIndex = 0;
    int m_MeasureModeIndex = 1;
    int m_HistoryModeIndex = 3;
    int m_HorZoomIndex = 0;
    int m_NewHorZoomIndex = 0;
    int m_VerZoomIndex = 0;
    int m_PollingModeIndex = 4;
    int m_NistTimeServerPollingModeIndex = 3;
    int m_TimeGraphMaxZoomOffsetModeIndex = 0;
    int m_NewPollModeIndex = 4;
    int m_ReferenceModeIndex = 0;
    int m_TimeGraphMaxZoomOffset = 0;
    int m_SeismometerFrequency = 20;
    double m_ActualSeismometerFrequency = 20.0;
    int m_SeismometerOffset = 300;
    int m_SeismometerRange = 2000;
    int m_ResetBuffersAndMinMaxModeIndex = 0;
    int m_DumpGraphsModeIndex = 0;
    int m_CloseFilesModeIndex = 0;
    int m_RunningRangeModeIndex = 0;
    int m_DelayAfterSlewModeIndex = 0;
    int m_DelayAfterSlewing = 0;
    int m_AxisSpeedModeIndex;
    int m_AxisSpeedDataMinimumPreSet;
    int m_AxisSpeedDataMinimum = this.m_AxisSpeedDataMinimumPreSet = 60;
    int m_MaxYValueIndex = 2000;
    int m_HorizontalScale = 1;
    int m_MountDataRows = 0;
    int m_MountDataCols = this.m_MaxYValueIndex * this.m_HorizontalScale;
    double[][] m_MountValues = null;
    double[][] m_SeismometerValues = null;
    double[] m_SeismometerStDev = null;
    double[][] m_DeltaTimeValues = null;
    double m_MaxDTIDATAValue = 0.0;
    double m_MinDTIDATAValue = 0.0;
    double m_DTIDATAMedian = 0.0;
    double m_DeltaTimeSlope = 0.0;
    double m_PCTimeSlope = 0.0;
    double m_PcTime = 0.0;
    double m_PcUTCOffset = 0.0;
    double m_PcOldTime = 0.0;
    long m_LastNISTServerPollTime = 0L;
    long m_lastPC_NISTServerDifference = 0L;
    String[] m_RawMountData;
    double[][] m_MaxMountValues;
    double[][] m_MinMountValues;
    double[][] m_MountStdev = null;
    double[][] m_MountAxisSpeed = null;
    double[] m_MaxStDev;
    double[] m_Median;
    double[] m_TargetCoordinates;
    int m_RunningRangeLength = 60;
    static final boolean m_OutputTimeFormat = true;
    static final int m_TimeFormatFilename = 1;
    static final int m_TimeFormatLogs = 2;
    static final int m_TimeFormatSimulation = 3;
    static final String m_PrefsFileName = new String("MountMonitor.pref");
    int m_LastSelectedPrefsTab = 0;
    String m_LogsFileName = "";
    String m_MountDataFileName = "";
    String m_SeismometerDataFileName = "";
    String m_DeltaTimeDataFileName = "";
    boolean m_FilesAreOpen = false;
    DataOutputStream m_Logs = null;
    DataOutputStream m_MountData = null;
    DataOutputStream m_SeismometerData = null;
    DataOutputStream m_DeltaTimeData = null;
    int[] m_MountValueIndex;
    int m_DeltaTimeValueIndex = -1;
    int m_SeismometerValueIndex = -1;
    boolean m_DumpGraphs = false;
    boolean m_SavePrefs = true;
    boolean m_ResetBuffersAndMinMaxWhenSlewing = false;
    boolean m_DumpGraphsWhenSlewing = false;
    boolean m_DumpGraphsWhenParked = false;
    boolean m_CloseFilesWhenSlewing = false;
    boolean m_CloseFilesWhenParked = false;
    boolean m_WaitedLongEnoughAfterSlew = false;
    boolean m_StartOfSlewWaitingMessageSent = false;
    boolean m_EndOfSlewWaitingMessageSent = false;
    boolean m_KeepOnGoing = true;
    boolean m_WaitForPrefsAccept = false;
    boolean m_WaitForMainSequence = false;
    boolean m_ResetConnection = false;
    boolean m_DropLastData = false;
    boolean m_ShiftSeismicData = false;
    boolean m_ShiftDeltaTimeData = false;
    boolean m_NewSequenceStarted = false;
    boolean m_PollingModeMenuChanged = false;
    boolean m_ShowMenuChanged = false;
    boolean m_LoggingModeMenuChanged = false;
    boolean m_ToleranceRaDecModeMenuChanged = false;
    boolean m_ToleranceSeismometerModeMenuChanged = false;
    boolean m_HorZoomModeMenuChanged = false;
    boolean m_VerZoomModeMenuChanged = false;
    boolean m_ResetMenuBufferChanged = false;
    boolean m_ResetMenuMinMaxChanged = false;
    boolean m_ResetBufferAndMinMaxWhenSlewing = false;
    boolean m_ResetMenuNewFileChanged = false;
    boolean m_SerialPortHasChanged = false;
    boolean m_Terminateprocessing = false;
    boolean m_MountIsParked = false;
    boolean m_CheckIfMountIsParked = false;
    boolean m_MountDataWasWritten = false;
    boolean m_GraphsWereMade = false;
    boolean m_OverLoad = false;
    int m_OverLoadCounter = 0;
    boolean m_SerialPortReturnedData = false;
    boolean m_SerialPortOpened = false;
    boolean m_MountDataIsValid = true;
    boolean[] m_PortMenuIndex = new boolean[25];
    boolean m_InitPortVerbose = false;
    boolean m_VerboseErrors = false;
    boolean m_FFTModeIsFrequency = true;
    boolean m_FFTGraphHasBeenMade = false;
    String[] m_ProtocolModeMenu = new String[]{"LX200 (Native 10Micron & Meade)", "ASCOM"};
    String[] m_LoggingModeMenu = new String[]{"All", "Only when tracking"};
    String[] m_ReferenceModeMenu = new String[]{"Median of data", "Mount target coordinates"};
    String[] m_ResetBuffersAndMinMaxModeMenu = new String[]{"Manually (Reset menu)", "When slewing"};
    String[] m_DumpGraphsModeMenu = new String[]{"Manually (automatic on exit)", "When slewing", "When parking"};
    String[] m_CloseFilesModeMenu = new String[]{"Manually (automatic on exit)", "When slewing (opens new files)", "When parking"};
    String[] m_WindowRatioModeMenu = new String[]{"1:1", "2:1", "3:1", "4:1", "5:1"};
    String[] m_ResetMenu = new String[]{"Buffers", "Min/max", "Buffers and Min/max", "New files"};
    String[] m_ToleranceRaDecModeMenu = new String[]{"none", "0.25''", "0.50''", "0.75''", "1.0''", "1.5''", "2''", "3''", "5''", "10''", "20''", "30''", "45''", "60''"};
    String[] m_ToleranceSeismometerModeMenu = new String[]{"none", "10%", "25%", "50%", "75%", "100%"};
    String[] m_AxisSpeedModeMenu = new String[]{"Do not record", "Do not show", "Show axial velocity [''/s]", "Show integrated displacement ['']"};
    int[] m_NistTimeServerPollingIntervalModeMenu = new int[]{0, 10, 30, 60, 120, 300, 600, 1200, 1800};
    int[] m_TimeGraphMaxZoomOffsetModeMenu = new int[]{0, 100, 500, 1000, 2000, 5000, 10000};
    int[] m_HorZoomModeMenu = new int[]{1, 2, 3, 4, 5, 20};
    String[] m_VerZoomModeMenu = new String[]{"Data (median centred)", "Tolerance", "Maximum (Data,Tolerance)", "Min/Max value lines"};
    int[] m_PollingModeMenu = new int[]{1, 2, 3, 4, 5, 10};
    double m_ActualMountFrequency = 1.0 / (double)this.m_PollingModeMenu[this.m_PollingModeIndex];
    int[] m_DelayAfterSlewModeMenu = new int[]{0, 5, 10, 20, 30, 60};
    int[] m_HistoryModeMenu = new int[]{5, 10, 20, 50, 100, 500};
    int[] m_RunningRangeModeMenu = new int[]{60, 120, 300, 900, 1200};
    int m_LoopWaitTime = 1000 / this.m_PollingModeMenu[this.m_PollingModeIndex] / 4;
    long m_LoopStartTime = 0L;
    long m_ZuluTime = 0L;
    long m_PollingStartTime = 0L;
    long m_LoopEndTime = 0L;
    long m_LoopDeltaTime = 0L;
    long m_LoopAvgDeltaTime = 0L;
    long m_LoopCorrectionTime = 1L;
    long m_SequenceStartTime = 0L;
    long m_SequenceEndTime = 0L;
    long m_SequenceDeltaTime = 0L;
    long m_EndOfSlewTime = this.getPcTime();
    int m_SaveGraphCounter = 0;
    SerialPort m_SerialPort = null;
    int m_SerialPortIndex = -1;
    SerialPort[] m_AvailableSerialPorts = SerialPort.getCommPorts();

    public static void main(String[] stringArray) throws Exception {
        new MountMonitor(stringArray);
    }

    public MountMonitor(String[] stringArray) {
        int n;
        if (stringArray.length > 0) {
            this.m_TestModeSimulateMount = stringArray[0].toLowerCase().equals("simmount") || stringArray[0].toLowerCase().equals("simall");
            boolean bl = this.m_TestModeSimulateSeismometer = stringArray[0].toLowerCase().equals("simseismometer") || stringArray[0].toLowerCase().equals("simall");
            if (stringArray.length > 1) {
                this.m_TestDataEqualsZero = stringArray[1].toLowerCase().equals("zero");
            }
        }
        this.initVars();
        this.m_PcUTCOffset = this.getUTCOffset(OffsetDateTime.now().getOffset().toString());
        this.m_Frame = new JFrame("MountMonitor");
        this.readPrefs();
        this.m_HasSeismometer = this.checkLicence(false);
        if (this.m_HasSeismometer) {
            this.m_HadSeismometer = true;
        }
        if (this.m_HasSeismometer && this.m_ShowSeismometer) {
            this.NUMGRAPHS = 4;
        }
        this.m_Frame.setLayout(new BorderLayout());
        this.m_Frame.setSize(this.m_FrameWidth, this.m_FrameHeight);
        this.m_Frame.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_FrameHeight));
        this.m_Frame.setLocation(this.m_FrameX, this.m_FrameY);
        this.m_Frame.setVisible(true);
        this.m_MenuBar = new JMenuBar();
        this.m_Menu = new JMenu("Horizontal zoom");
        for (n = 0; n < this.m_HorZoomModeMenuItem.length; ++n) {
            this.m_HorZoomModeMenuItem[n] = new JCheckBoxMenuItem("" + this.m_HorZoomModeMenu[n] + "x", false);
            this.m_Menu.add(this.m_HorZoomModeMenuItem[n]);
            this.m_HorZoomModeMenuItem[n].addItemListener(this);
        }
        this.m_HorZoomModeMenuItem[this.m_HorZoomIndex].setState(true);
        this.m_MenuBar.add(this.m_Menu);
        this.m_Menu = new JMenu("Vertical zoom");
        for (n = 0; n < this.m_VerZoomModeMenuItem.length; ++n) {
            this.m_VerZoomModeMenuItem[n] = new JCheckBoxMenuItem("" + this.m_VerZoomModeMenu[n], false);
            this.m_Menu.add(this.m_VerZoomModeMenuItem[n]);
            this.m_VerZoomModeMenuItem[n].addItemListener(this);
        }
        this.m_VerZoomModeMenuItem[this.m_VerZoomIndex].setState(true);
        this.m_MenuBar.add(this.m_Menu);
        this.m_Menu = new JMenu("Reset");
        for (n = 0; n < this.m_ResetMenu.length; ++n) {
            if (n > 2) {
                this.m_Menu.addSeparator();
            }
            this.m_ResetMenuItem[n] = new JMenuItem(this.m_ResetMenu[n]);
            this.m_Menu.add(this.m_ResetMenuItem[n]);
            this.m_ResetMenuItem[n].addActionListener(this);
        }
        this.m_MenuBar.add(this.m_Menu);
        this.m_PrefsMenu = new JMenu("Preferences");
        this.m_PrefsMenuItem = new JMenuItem("Edit");
        this.m_PrefsMenuItem.addActionListener(this);
        this.m_PrefsMenu.add(this.m_PrefsMenuItem);
        this.m_MenuBar.add(this.m_PrefsMenu);
        this.m_FTMenu = new JMenu("Fourier");
        this.m_FFTPeriodMenuItem = new JMenuItem("FFT Period [s]");
        this.m_FFTPeriodMenuItem.addActionListener(this);
        this.m_FTMenu.add(this.m_FFTPeriodMenuItem);
        this.m_MenuBar.add(this.m_FTMenu);
        this.m_FFTFrequencyMenuItem = new JMenuItem("FFT Frequency [Hz]");
        this.m_FFTFrequencyMenuItem.addActionListener(this);
        this.m_FTMenu.add(this.m_FFTFrequencyMenuItem);
        this.m_MenuBar.add(this.m_FTMenu);
        this.m_HelpMenu = new JMenu("Help");
        this.m_HelpMenuItem = new JMenuItem("Help");
        this.m_HelpMenuItem.addActionListener(this);
        this.m_HelpMenu.add(this.m_HelpMenuItem);
        this.m_HelpMenu.addSeparator();
        this.m_AboutMenuItem = new JMenuItem("About...");
        this.m_AboutMenuItem.addActionListener(this);
        this.m_HelpMenu.add(this.m_AboutMenuItem);
        this.m_MenuBar.add(this.m_HelpMenu);
        this.m_Frame.setJMenuBar(this.m_MenuBar);
        this.calculatePanelSizes();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.resultGraphPanel = new JPanel(new GridLayout(0, 1, 0, this.m_GraphPanelSpacing));
        this.initResultGraphPanel();
        jPanel.add("North", this.resultGraphPanel);
        this.m_Frame.add("North", jPanel);
        this.m_Frame.setVisible(true);
        this.m_Frame.toFront();
        this.m_ToleranceRaDec = this.getToleranceRaDec();
        this.FFTGraphPanel = new FTPanel(300, 150, Color.yellow);
        this.FFTGraphPanel.setDimension(new Dimension(300, 150));
        this.FFTGraphPanel.setSize(300, 100);
        this.FFTGraphPanel.setPreferredSize(new Dimension(300, 150));
        this.FFTGraphPanel.setModeText("Seismometer");
        this.m_FTGraphImg = this.FFTGraphPanel.getImage();
        this.FFTGraphPanel.setImage((BufferedImage)this.m_FTGraphImg);
        this.FTGraphGraphics = (Graphics2D)this.FFTGraphPanel.getGraphics();
        GridLayout gridLayout = new GridLayout(1, 0);
        gridLayout.setVgap(1);
        gridLayout.setHgap(1);
        JPanel jPanel2 = new JPanel(gridLayout);
        jPanel2.setBorder(new EmptyBorder(3, 10, 3, 10));
        EtchedBorder etchedBorder = new EtchedBorder(0);
        EtchedBorder etchedBorder2 = new EtchedBorder(1);
        jPanel2.setBorder(etchedBorder2);
        this.m_TextStatus = new JEditorPane("text/html", "");
        this.m_TextStatus.setBorder(etchedBorder2);
        this.m_TextStatus.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_TextStatus.setFont(this.m_Frame.getFont());
        this.m_TextStatus.setEditable(false);
        this.m_TextStatus.setPreferredSize(new Dimension((int)((double)this.m_FrameWidth / 3.0), (int)((double)this.m_FrameHeight * (this.TEXTBOXRATIO / this.TOTALRATIO) - (double)this.m_GraphPanelSpacing)));
        jPanel2.add(this.m_TextStatus);
        this.m_TextOutput = new JEditorPane("text/html", "");
        this.m_TextOutput.setBorder(etchedBorder2);
        this.m_TextOutput.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_TextOutput.setFont(this.m_Frame.getFont());
        this.m_TextOutput.setEditable(false);
        this.m_TextOutput.setPreferredSize(new Dimension((int)((double)this.m_FrameWidth / 3.0), (int)((double)this.m_FrameHeight * (this.TEXTBOXRATIO / this.TOTALRATIO) - (double)this.m_GraphPanelSpacing)));
        jPanel2.add(this.m_TextOutput);
        this.m_TextInput = new JEditorPane("text/html", "");
        this.m_TextInput.setBorder(etchedBorder2);
        this.m_TextInput.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_TextInput.setFont(this.m_Frame.getFont());
        this.m_TextInput.setEditable(false);
        this.m_TextInput.setPreferredSize(new Dimension((int)((double)this.m_FrameWidth / 3.0), (int)((double)this.m_FrameHeight * (this.TEXTBOXRATIO / this.TOTALRATIO) - (double)this.m_GraphPanelSpacing)));
        jPanel2.add(this.m_TextInput);
        this.m_Frame.add("Center", jPanel2);
        this.setTheTitle();
        this.m_TextInput.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MountMonitor.this.m_TextOutput.requestFocus();
            }
        });
        this.m_Frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MountMonitor.this.m_Terminateprocessing = true;
                MountMonitor.this.savePrefs();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        this.m_Frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MountMonitor.this.m_AllowUpdateWindowComponents = true;
            }
        });
        this.updateWindowComponents();
        this.startMonitoring();
    }

    public void startMonitoring() {
        String string = "";
        double d = 0.0;
        double d2 = 0.0;
        this.setTheTitle();
        for (double[] dArray : this.m_MaxMountValues) {
            Arrays.fill(dArray, -360.0);
        }
        for (double[] dArray : this.m_MinMountValues) {
            Arrays.fill(dArray, 360.0);
        }
        if (!this.m_TestModeSimulateSeismometer) {
            this.initSeismometerPort();
        }
        if (!this.m_TestModeSimulateMount) {
            while (!this.m_ServerIsActive) {
                if (this.m_CommandMode == 0) {
                    this.initTCPIPPort();
                    continue;
                }
                if (this.m_CommandMode == 1) {
                    this.initASCOMConnection();
                    continue;
                }
                System.exit(0);
            }
        }
        this.m_PollingStartTime = this.getPcTime();
        this.m_ZuluTime = this.getPcTime();
        this.getMountInfo();
        this.getMountPosition();
        this.getTargetCoordinates();
        this.getInitialMountAttitude();
        this.checkLicence(true);
        this.openFiles();
        if (this.m_TestModeSimulateMount) {
            this.addToLogFile("Entering test mode, no mount connected.");
        }
        this.addToLogFile("Tolerance:\t" + this.m_ToleranceRaDecModeMenu[this.m_ToleranceRaDecModeIndex]);
        this.addToLogFile("Starting NIST Time Server thread.");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Thread sleep error " + interruptedException);
                    }
                    if (MountMonitor.this.getPcTime() - MountMonitor.this.m_LastNISTServerPollTime < (long)(MountMonitor.this.m_NistTimeServerPollingInterval * 1000) - MountMonitor.this.m_LoopAvgDeltaTime || !MountMonitor.this.m_UseNistTimeServer) continue;
                    MountMonitor.this.checkTime();
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        while (this.m_KeepOnGoing) {
            this.m_PollingStartTime = this.getPcTime();
            boolean bl = this.m_WaitedLongEnoughAfterSlew = (double)(this.m_LoopStartTime - this.m_EndOfSlewTime) > (double)this.m_DelayAfterSlewModeMenu[this.m_DelayAfterSlewModeIndex] * 1000.0;
            if (this.m_WaitedLongEnoughAfterSlew) {
                if (!this.m_EndOfSlewWaitingMessageSent) {
                    this.checkMountSettings();
                    this.getTargetCoordinates();
                    this.getInitialMountAttitude();
                    this.addMountAttitudeToFile(this.m_Logs);
                    this.showText(this.m_TextStatus, "Logging started.");
                    this.addToLogFile("Logging started.");
                    this.m_EndOfSlewWaitingMessageSent = true;
                }
            } else if (!this.m_StartOfSlewWaitingMessageSent) {
                this.showText(this.m_TextStatus, "Waiting for " + this.m_DelayAfterSlewModeMenu[this.m_DelayAfterSlewModeIndex] + " seconds to start logging.");
                this.addToLogFile("Waiting for " + this.m_DelayAfterSlewModeMenu[this.m_DelayAfterSlewModeIndex] + " seconds to start logging.");
                this.m_StartOfSlewWaitingMessageSent = true;
                this.m_ResetMenuMinMaxChanged = true;
            }
            if (!this.m_ResetConnection) {
                this.setLX200Rotator();
            }
            if (this.m_MountIsParked && this.m_FilesAreOpen) {
                if (this.m_GraphsWereMade) {
                    this.saveGraphs(true);
                }
                if (this.m_MountDataWasWritten) {
                    this.closeFiles();
                }
                this.savePrefs();
                this.m_NewSequenceStarted = false;
            }
            if (this.m_NewSequenceStarted) {
                if (this.m_WaitForPrefsAccept) {
                    this.m_WaitForMainSequence = false;
                    this.showText(this.m_TextStatus, "Waiting for new settings to be stored.");
                }
                while (this.m_WaitForPrefsAccept) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                boolean bl2 = this.m_WaitForMainSequence = this.m_MountStatus == 0;
                if (this.m_AllowUpdateWindowComponents) {
                    this.updateWindowComponents();
                }
                if (this.m_LoopStartTime == 0L) {
                    this.m_LoopStartTime = this.getPcTime();
                    this.m_LoopAvgDeltaTime = 1000 / this.m_PollingModeMenu[this.m_PollingModeIndex];
                }
                this.m_LoopEndTime = this.getPcTime();
                this.m_LoopDeltaTime = this.m_LoopEndTime - this.m_LoopStartTime;
                this.m_LoopStartTime = this.m_LoopEndTime;
                this.m_LoopAvgDeltaTime = (this.m_LoopAvgDeltaTime * 9L + this.m_LoopDeltaTime) / 10L;
                this.m_ActualMountFrequency = (this.m_ActualMountFrequency * 9.0 + 1.0 / ((double)this.m_LoopAvgDeltaTime / 1000.0)) / 10.0;
                this.m_LoopCorrectionTime = ((long)(1000 / this.m_PollingModeMenu[this.m_PollingModeIndex]) - this.m_LoopAvgDeltaTime) / 20L;
                this.m_LoopWaitTime = (int)((long)this.m_LoopWaitTime + this.m_LoopCorrectionTime);
                this.m_LoopWaitTime = Math.max(1, this.m_LoopWaitTime);
                if (this.m_UseNistTimeServer) {
                    if (this.m_LogUpdateNistTimeServerFailed && this.m_NistTimeServerFailed) {
                        this.addToLogFile("FAILED to contact " + this.m_NistTimeServer);
                        this.m_LogUpdateNistTimeServerFailed = false;
                    }
                    if (this.m_LogUpdateNistTimeServerReconnected && !this.m_NistTimeServerFailed) {
                        String string2 = "slow";
                        if (this.m_lastPC_NISTServerDifference < 0L) {
                            string2 = "fast";
                        }
                        this.addToLogFile("Time from " + this.m_NistTimeServer + ", PC is " + string2 + " by " + Math.abs(this.m_lastPC_NISTServerDifference) + "msec");
                        this.m_LogUpdateNistTimeServerReconnected = false;
                    }
                }
                if (this.m_HasSeismometer) {
                    if (this.m_SerialPortHasChanged) {
                        try {
                            this.m_SerialPort.closePort();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        this.m_SerialPortOpened = this.initSerialPort(this.m_SerialPortIndex);
                        this.m_SerialPortHasChanged = false;
                    }
                    String string3 = "" + this.requestSeismometerData();
                    if (this.m_SequenceStartTime == 0L) {
                        this.m_SequenceStartTime = this.getPcTime();
                    }
                    this.m_SequenceEndTime = this.getPcTime();
                    this.m_SequenceDeltaTime = this.m_SequenceEndTime - this.m_SequenceStartTime;
                    this.addToSeismicArray(string3, this.m_SequenceDeltaTime);
                    if (this.m_ShiftSeismicData) {
                        this.shiftSeismicData();
                    }
                    this.m_SequenceStartTime = this.m_SequenceEndTime;
                }
                this.m_NewSequenceStarted = false;
                this.m_RaGraphPanel.setYData(this.m_MountValues);
                this.m_RaGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
                this.m_RaGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
                this.m_RaGraphPanel.setMountStatData(this.m_MountStdev);
                this.m_RaGraphPanel.setDeclination(this.m_Median[3]);
                this.m_RaGraphPanel.setMountAxisSpeedDataStartIdx(this.m_AxisSpeedDataMinimum);
                this.m_RaGraphPanel.setMountAxisSpeedData(this.m_MountAxisSpeed);
                this.m_RaGraphPanel.showMountAxisSpeedData(this.m_ShowAxialSpeed, 4, this.m_ShowAxialSpeedAsDisplacement);
                if (this.m_ReferenceModeIndex == 0) {
                    this.m_RaGraphPanel.setReference(this.m_Median, this.m_ReferenceModeIndex);
                } else {
                    this.m_RaGraphPanel.setReference(this.m_TargetCoordinates, this.m_ReferenceModeIndex);
                }
                this.m_RaGraphPanel.setMaxStatData(this.m_MaxStDev);
                this.m_RaGraphPanel.setMaxYData(this.m_MaxMountValues[0]);
                this.m_RaGraphPanel.setMinYData(this.m_MinMountValues[0]);
                this.m_RaGraphPanel.setYVIndex(Math.max(this.m_MountValueIndex[2], 0));
                this.m_RaGraphPanel.setSVIndex(Math.max(this.m_SeismometerValueIndex, 0));
                this.m_RaGraphGraphics = (Graphics2D)this.m_RaGraphPanel.getGraphics();
                this.m_RaGraphPanel.paint(this.m_RaGraphGraphics);
                if (this.FFTGraphPanel.isActive().booleanValue()) {
                    this.FFTGraphPanel.setSData(this.m_SeismometerValues);
                    this.FFTGraphPanel.setMData(this.m_MountValues);
                    this.FFTGraphPanel.setSVIndex(Math.max(this.m_SeismometerValueIndex, 0));
                    this.FFTGraphPanel.setMVIndex(Math.max(this.m_MountValueIndex[2], 0));
                    this.FFTGraphPanel.setRAIndex(2);
                    this.FFTGraphPanel.setDECIndex(3);
                    this.FFTGraphPanel.setSeismometerFrequency(this.m_ActualSeismometerFrequency);
                    this.FFTGraphPanel.setMountFrequency(this.m_ActualMountFrequency);
                    this.FTGraphGraphics = (Graphics2D)this.FFTGraphPanel.getGraphics();
                    this.FFTGraphPanel.paint(this.FTGraphGraphics);
                }
                this.m_DecGraphPanel.setYData(this.m_MountValues);
                this.m_DecGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
                this.m_DecGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
                this.m_DecGraphPanel.setMountStatData(this.m_MountStdev);
                this.m_DecGraphPanel.setMountAxisSpeedDataStartIdx(this.m_AxisSpeedDataMinimum);
                this.m_DecGraphPanel.setMountAxisSpeedData(this.m_MountAxisSpeed);
                this.m_DecGraphPanel.showMountAxisSpeedData(this.m_ShowAxialSpeed, 5, this.m_ShowAxialSpeedAsDisplacement);
                if (this.m_ReferenceModeIndex == 0) {
                    this.m_DecGraphPanel.setReference(this.m_Median, this.m_ReferenceModeIndex);
                } else {
                    this.m_DecGraphPanel.setReference(this.m_TargetCoordinates, this.m_ReferenceModeIndex);
                }
                this.m_DecGraphPanel.setMaxStatData(this.m_MaxStDev);
                this.m_DecGraphPanel.setMaxYData(this.m_MaxMountValues[0]);
                this.m_DecGraphPanel.setMinYData(this.m_MinMountValues[0]);
                this.m_DecGraphPanel.setYVIndex(Math.max(this.m_MountValueIndex[3], 0));
                this.m_DecGraphGraphics = (Graphics2D)this.m_DecGraphPanel.getGraphics();
                this.m_DecGraphPanel.paint(this.m_DecGraphGraphics);
                if (this.m_HasSeismometer && this.m_ShowSeismometer) {
                    this.m_SeisGraphPanel.setYData(this.m_MountValues);
                    this.m_SeisGraphPanel.setSData(this.m_SeismometerValues);
                    this.m_SeisGraphPanel.setSeismometerStatData(this.m_SeismometerStDev);
                    this.m_SeisGraphPanel.setYVIndex(Math.max(this.m_MountValueIndex[2], 0));
                    this.m_SeisGraphPanel.setSVIndex(Math.max(this.m_SeismometerValueIndex, 0));
                    this.m_SeisGraphPanel.setSeismometerOffset(this.m_SeismometerOffset);
                    this.m_SeisGraphPanel.setSeismometerRange(this.m_SeismometerRange);
                    this.m_SeisGraphGraphics = (Graphics2D)this.m_SeisGraphPanel.getGraphics();
                    this.m_SeisGraphPanel.paint(this.m_SeisGraphGraphics);
                }
                this.m_TimeGraphPanel.setYData(this.m_MountValues);
                this.m_TimeGraphPanel.setSData(this.m_DeltaTimeValues);
                this.m_TimeGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
                this.m_TimeGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
                this.m_TimeGraphPanel.setMountStatData(this.m_MountStdev);
                this.m_TimeGraphPanel.setMaxStatData(this.m_MaxStDev);
                this.m_TimeGraphPanel.setMaxYData(this.m_MaxMountValues[0]);
                this.m_TimeGraphPanel.setMinYData(this.m_MinMountValues[0]);
                this.m_TimeGraphPanel.setYVIndex(Math.max(this.m_DeltaTimeValueIndex, 0));
                this.m_TimeGraphPanel.setSVIndex(Math.max(this.m_DeltaTimeValueIndex, 0));
                this.m_TimeGraphPanel.setDeltaTimeSlope(this.m_DeltaTimeSlope);
                this.m_TimeGraphPanel.showNistTimeServer(this.m_UseNistTimeServer & !this.m_NistTimeServerFailed);
                this.m_TimeGraphPanel.setPCTimeSlope(this.m_PCTimeSlope);
                this.m_TimeGraphPanel.setTimeScaleLimit(this.m_TimeGraphMaxZoomOffset);
                this.m_TimeGraphPanel.setSeismometerOffset((int)this.getRMean(this.m_DeltaTimeValues, 0, 3, this.m_DeltaTimeValueIndex - 1));
                this.m_TimeGraphPanel.setSeismometerRange((int)Math.max(1.0, Math.max(this.getRMean(this.m_DeltaTimeValues, 0, 1, this.m_DeltaTimeValueIndex - 1) * 1.1, this.m_MaxDTIDATAValue - this.m_MinDTIDATAValue)));
                this.m_TimeGraphGraphics = (Graphics2D)this.m_TimeGraphPanel.getGraphics();
                this.m_TimeGraphPanel.paint(this.m_TimeGraphGraphics);
                this.m_GraphsWereMade = true;
                if (this.m_WaitedLongEnoughAfterSlew) {
                    for (int i = 0; i < this.m_MaxMountValues[0].length; ++i) {
                        for (int j = 2; j >= 0; --j) {
                            this.m_MaxMountValues[j + 1][i] = this.m_MaxMountValues[j][i] + 0.0;
                            this.m_MinMountValues[j + 1][i] = this.m_MinMountValues[j][i] + 0.0;
                        }
                    }
                }
                if (this.m_WaitedLongEnoughAfterSlew && this.indexesAreValid()) {
                    this.writeMountData();
                    this.writeDeltaTimeData();
                }
                if (this.m_PollingModeMenuChanged) {
                    this.m_PollingModeIndex = this.m_NewPollModeIndex;
                    this.m_LoopWaitTime = 1000 / this.m_PollingModeMenu[this.m_PollingModeIndex] / 4;
                    this.m_LoopStartTime = 0L;
                    this.m_RaGraphPanel.setPollFrequency(this.m_PollingModeMenu[this.m_PollingModeIndex]);
                    this.m_DecGraphPanel.setPollFrequency(this.m_PollingModeMenu[this.m_PollingModeIndex]);
                    this.setTheTitle();
                    this.addToLogFile("Changed polling interval to:\t" + this.m_PollingModeMenu[this.m_PollingModeIndex] + "Hz.");
                    this.m_PollingModeMenuChanged = false;
                }
                if (this.m_HorZoomModeMenuChanged) {
                    if (this.m_NewHorZoomIndex > this.m_HorZoomIndex) {
                        int n = this.m_HorZoomModeMenu[this.m_NewHorZoomIndex];
                        int n2 = this.m_GraphPanelWidth / n;
                        int n3 = 0;
                        for (int i = 0; i < this.m_MaxStDev.length; ++i) {
                            if (this.m_MountValueIndex[i] <= n2) continue;
                            n3 = this.m_MountValueIndex[i] - n2;
                            for (int j = 0; j < this.m_MaxYValueIndex - n3; ++j) {
                                this.m_MountValues[i][j] = this.m_MountValues[i][j + n3];
                                this.m_MountStdev[i][j] = this.m_MountStdev[i][j + n3];
                                if (i < 5) {
                                    this.m_DeltaTimeValues[i][j] = this.m_DeltaTimeValues[i][j + n3];
                                }
                                if (i != 4 && i != 5) continue;
                                this.m_MountAxisSpeed[i][j] = this.m_MountAxisSpeed[i][j + n3];
                                this.m_MountAxisSpeed[i - 2][j] = this.m_MountAxisSpeed[i - 2][j + n3];
                                this.m_MountAxisSpeed[i + 2][j] = this.m_MountAxisSpeed[i + 2][j + n3];
                            }
                            this.m_MountValueIndex[i] = n2;
                        }
                        this.m_DeltaTimeValueIndex = n2;
                    }
                    this.m_HorZoomIndex = this.m_NewHorZoomIndex;
                    this.m_HorizontalScale = this.m_HorZoomModeMenu[this.m_HorZoomIndex];
                    this.m_RaGraphPanel.setHScale(this.m_HorizontalScale);
                    if (this.m_HasSeismometer) {
                        this.m_SeisGraphPanel.setHScale(this.m_HorizontalScale);
                    }
                    this.m_DecGraphPanel.setHScale(this.m_HorizontalScale);
                    this.m_TimeGraphPanel.setHScale(this.m_HorizontalScale);
                    this.m_MaxYValueIndex = this.m_GraphPanelWidth / this.m_HorizontalScale;
                    this.addToLogFile("Changed horizontal zoom level to:\t" + this.m_HorizontalScale + "x.");
                    this.m_HorZoomModeMenuChanged = false;
                }
                if (this.m_VerZoomModeMenuChanged) {
                    this.m_RaGraphPanel.setVScale(this.m_VerZoomIndex);
                    this.m_DecGraphPanel.setVScale(this.m_VerZoomIndex);
                    this.addToLogFile("Changed vertical zoom level to:\t" + this.m_HorizontalScale + "x.");
                    this.m_VerZoomModeMenuChanged = false;
                }
                if (this.m_LoggingModeMenuChanged) {
                    this.addToLogFile("Logging set to:\t" + this.m_LoggingModeMenu[this.m_LogModeIndex]);
                    this.m_LoggingModeMenuChanged = false;
                }
                if (this.m_ToleranceRaDecModeMenuChanged) {
                    this.m_ToleranceRaDec = this.getToleranceRaDec();
                    this.m_RaGraphPanel.setToleranceRaDec(this.m_ToleranceRaDec);
                    this.m_RaGraphPanel.setUseAsHATolerance(this.m_UseAsHATolerance);
                    this.m_DecGraphPanel.setToleranceRaDec(this.m_ToleranceRaDec);
                    this.addToLogFile("New RA/DEC tolerance level:\t" + this.m_ToleranceRaDecModeMenu[this.m_ToleranceRaDecModeIndex]);
                    this.m_ToleranceRaDecModeMenuChanged = false;
                }
                if (this.m_ToleranceSeismometerModeMenuChanged) {
                    this.m_ToleranceSeismometer = this.getToleranceSeismometer();
                    this.m_SeisGraphPanel.setToleranceSeismometer(this.m_ToleranceSeismometer);
                    this.addToLogFile("New Seismometer tolerance level:\t" + this.m_ToleranceSeismometerModeMenu[this.m_ToleranceSeismometerModeIndex]);
                    this.m_ToleranceSeismometerModeMenuChanged = false;
                }
                if (this.m_ResetMenuBufferChanged || this.m_ResetMenuMinMaxChanged) {
                    this.getTargetCoordinates();
                }
                if (this.m_ResetMenuBufferChanged) {
                    this.saveGraphs(true);
                    this.m_TextInput.setText("");
                    this.m_TextOutput.setText("");
                    this.m_MountValues = this.newDoubleArray(this.m_MountDataRows, this.m_MountDataCols);
                    this.m_SeismometerValues = this.newDoubleArray(2, this.m_MountDataCols * this.m_SeismometerFrequency);
                    this.m_MountStdev = this.newDoubleArray(this.m_MountDataRows, this.m_MountDataCols);
                    this.m_MountAxisSpeed = this.newDoubleArray(10, this.m_MountDataCols);
                    for (int i = 0; i < this.m_MountValueIndex.length; ++i) {
                        this.m_MountValueIndex[i] = -1;
                    }
                    this.m_SeismometerValueIndex = -1;
                    this.m_DeltaTimeValueIndex = -1;
                    this.addToLogFile("Buffers flushed.");
                    this.showText(this.m_TextStatus, "Buffers flushed.");
                    this.m_IsFirstFrame = true;
                    this.m_SaveGraphCounter = 0;
                    this.m_AxisSpeedDataMinimum = this.m_AxisSpeedDataMinimumPreSet;
                    this.m_ResetMenuBufferChanged = false;
                }
                if (this.m_ResetMenuMinMaxChanged) {
                    int n;
                    this.addToLogFile("About to reset Min/max lines, current values are:");
                    this.addMinMaxToLog();
                    for (n = 0; n < this.m_MaxStDev.length; ++n) {
                        this.m_MaxStDev[n] = 0.0;
                    }
                    for (n = 0; n < this.m_MinMountValues[0].length; ++n) {
                        this.m_MinMountValues[0][n] = 360.0;
                    }
                    for (n = 0; n < this.m_MaxMountValues[0].length; ++n) {
                        this.m_MaxMountValues[0][n] = -360.0;
                    }
                    this.addToLogFile("Min/max lines reset.");
                    this.showText(this.m_TextStatus, "Min/max lines reset.");
                    this.m_ResetMenuMinMaxChanged = false;
                }
                if (this.m_ResetMenuNewFileChanged) {
                    this.addToLogFile("Opening new files (closing the current ones).");
                    this.showText(this.m_TextStatus, "Opening new files (closing this one).");
                    this.closeFiles();
                    this.openFiles();
                    this.m_ResetMenuNewFileChanged = false;
                }
                ++this.m_SaveGraphCounter;
                if (this.m_DumpGraphs || this.m_SaveGraphCounter >= this.m_MaxYValueIndex) {
                    if (this.m_SaveGraphCounter != 0) {
                        this.saveGraphs(true);
                    } else {
                        this.saveGraphs(false);
                    }
                    this.m_SaveGraphCounter = 0;
                    this.m_DumpGraphs = false;
                }
                if (this.m_Terminateprocessing) {
                    if (this.m_SaveGraphCounter != 0) {
                        this.saveGraphs(true);
                    }
                    this.showText(this.m_TextStatus, "Goodbye!.");
                    this.m_KeepOnGoing = false;
                }
            }
            String string4 = "";
            if (!this.m_KeepOnGoing) continue;
            if (this.m_ResetConnection) {
                this.resetConnection();
                string4 = "-1";
            } else if (this.m_CheckMountSettings.booleanValue()) {
                this.checkMountSettings();
            } else {
                this.m_RawMountData[this.m_CommandRotator] = string4 = "" + this.requestMountData(this.m_Writer, this.m_Reader, this.m_CommandRotator);
                if (!this.m_DropLastData) {
                    try {
                        if (this.m_CommandRotator == 0) {
                            this.m_MountStatus = Integer.parseInt(string4);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Something went terribly wrong (will have to reset):" + string4 + " " + this.m_CommandRotator + "==" + 0);
                        this.m_MountStatus = -3;
                        this.m_CommandRotator = 0;
                        this.m_NewSequenceStarted = true;
                        string4 = this.m_MountValueIndex[this.m_CommandRotator] > 0 ? this.m_RaGraphPanel.formatHMS(this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator] - 1]) : "-1";
                    }
                    if (this.m_MountStatus != this.m_MountStatusOld) {
                        String string5 = this.mountStatus(this.m_MountStatus);
                        this.addToLogFile("Mount status update: " + string5);
                        this.showText(this.m_TextStatus, string5);
                        this.m_MountStatusOld = this.m_MountStatus;
                    }
                    if ((this.m_MountStatus == 0 || this.m_LogModeIndex == 0) && this.m_WaitedLongEnoughAfterSlew) {
                        if (this.m_InitASCOMTargetCoordinates.booleanValue() && this.m_CommandMode == 1) {
                            this.InitASCOMTargetCoordinates();
                        }
                        int n = this.m_CommandRotator;
                        this.m_MountValueIndex[n] = this.m_MountValueIndex[n] + 1;
                        if (this.m_MountValueIndex[this.m_CommandRotator] > this.m_MaxYValueIndex) {
                            int n4;
                            this.m_IsFirstFrame = false;
                            this.m_ShiftSeismicData = true;
                            this.m_ShiftDeltaTimeData = true;
                            if (this.m_AxisSpeedDataMinimum > 0) {
                                --this.m_AxisSpeedDataMinimum;
                            }
                            for (n4 = 0; n4 < this.m_MaxYValueIndex; ++n4) {
                                this.m_MountValues[this.m_CommandRotator][n4] = this.m_MountValues[this.m_CommandRotator][n4 + 1];
                                this.m_MountStdev[this.m_CommandRotator][n4] = this.m_MountStdev[this.m_CommandRotator][n4 + 1];
                            }
                            if (this.m_CommandRotator == 4 || this.m_CommandRotator == 5) {
                                for (n4 = 0; n4 < this.m_MaxYValueIndex; ++n4) {
                                    this.m_MountAxisSpeed[this.m_CommandRotator - 4][n4] = this.m_MountAxisSpeed[this.m_CommandRotator - 4][n4 + 1];
                                    this.m_MountAxisSpeed[this.m_CommandRotator - 2][n4] = this.m_MountAxisSpeed[this.m_CommandRotator - 2][n4 + 1];
                                    this.m_MountAxisSpeed[this.m_CommandRotator][n4] = this.m_MountAxisSpeed[this.m_CommandRotator][n4 + 1];
                                    this.m_MountAxisSpeed[this.m_CommandRotator + 2][n4] = this.m_MountAxisSpeed[this.m_CommandRotator + 2][n4 + 1];
                                }
                            }
                            if (this.m_CommandRotator == 1) {
                                for (n4 = 0; n4 < this.m_MaxYValueIndex; ++n4) {
                                    for (int i = 0; i < 5; ++i) {
                                        this.m_DeltaTimeValues[i][n4] = this.m_DeltaTimeValues[i][n4 + 1];
                                    }
                                }
                                this.m_DeltaTimeValueIndex = this.m_MaxYValueIndex;
                            }
                            this.m_MountValueIndex[this.m_CommandRotator] = this.m_MaxYValueIndex;
                        }
                        this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] = this.makeDecimal(string4);
                        if (this.m_MountCommandSet[this.m_CommandRotator][4] == "1") {
                            this.m_MountStdev[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] = this.getStDev(this.m_MountValues, 1, this.m_CommandRotator, this.m_MountValueIndex[this.m_CommandRotator] - 1);
                        } else {
                            this.m_MountStdev[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] = 0.0;
                            this.m_MountAxisSpeed[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] = 0.0;
                        }
                        if (this.m_MountStdev[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] > this.m_MaxStDev[this.m_CommandRotator]) {
                            this.m_MaxStDev[this.m_CommandRotator] = this.m_MountStdev[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]];
                        }
                        if (this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] > this.m_MaxMountValues[0][this.m_CommandRotator]) {
                            this.m_MaxMountValues[0][this.m_CommandRotator] = this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]];
                        }
                        if (this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] < this.m_MinMountValues[0][this.m_CommandRotator]) {
                            this.m_MinMountValues[0][this.m_CommandRotator] = this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]];
                        }
                        if ((this.m_CommandRotator == 4 || this.m_CommandRotator == 5) && this.m_MountValueIndex[this.m_CommandRotator] > 0) {
                            double d3;
                            this.m_MountAxisSpeed[this.m_CommandRotator - 4][this.m_MountValueIndex[this.m_CommandRotator]] = (double)this.getPcTime() / 1000.0 / 3600.0;
                            if (this.m_MountValueIndex[this.m_CommandRotator] == 1) {
                                this.m_MountAxisSpeed[this.m_CommandRotator - 4][0] = this.m_MountAxisSpeed[this.m_CommandRotator - 4][this.m_MountValueIndex[this.m_CommandRotator]];
                            }
                            this.m_MountAxisSpeed[this.m_CommandRotator - 2][this.m_MountValueIndex[this.m_CommandRotator]] = this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]];
                            if (this.m_MountValueIndex[this.m_CommandRotator] == 1) {
                                this.m_MountAxisSpeed[this.m_CommandRotator - 2][0] = this.m_MountAxisSpeed[this.m_CommandRotator - 2][this.m_MountValueIndex[this.m_CommandRotator]];
                            }
                            if (this.m_MountValueIndex[this.m_CommandRotator] > this.m_AxisSpeedDataMinimum) {
                                this.m_MountAxisSpeed[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] = this.getAxisSpeed(this.m_MountAxisSpeed, 0, this.m_CommandRotator - 2, this.m_MountValueIndex[this.m_CommandRotator] - 1);
                                if (this.m_MountValueIndex[this.m_CommandRotator] == this.m_AxisSpeedDataMinimum + 1) {
                                    for (int i = 0; i <= this.m_AxisSpeedDataMinimum + 1; ++i) {
                                        this.m_MountAxisSpeed[this.m_CommandRotator][i] = this.m_MountAxisSpeed[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]];
                                    }
                                }
                            }
                            this.m_MountAxisSpeed[this.m_CommandRotator + 2][this.m_MountValueIndex[this.m_CommandRotator]] = (d3 = this.m_MountAxisSpeed[this.m_CommandRotator - 4][this.m_MountValueIndex[this.m_CommandRotator]] - this.m_MountAxisSpeed[this.m_CommandRotator - 4][this.m_MountValueIndex[this.m_CommandRotator] - 1]) > 0.0 ? (this.m_MountAxisSpeed[this.m_CommandRotator - 2][this.m_MountValueIndex[this.m_CommandRotator]] - this.m_MountAxisSpeed[this.m_CommandRotator - 2][this.m_MountValueIndex[this.m_CommandRotator] - 1]) / d3 : (this.m_MountValueIndex[this.m_CommandRotator] > 1 ? this.m_MountAxisSpeed[this.m_CommandRotator + 2][this.m_MountValueIndex[this.m_CommandRotator] - 1] : (this.m_CommandRotator == 4 ? 15.02 : 0.0));
                            if (this.m_MountValueIndex[this.m_CommandRotator] == 1) {
                                this.m_MountAxisSpeed[this.m_CommandRotator + 2][0] = this.m_MountAxisSpeed[this.m_CommandRotator + 2][1];
                            }
                            this.m_Median[this.m_CommandRotator] = this.getMedian(this.m_MountAxisSpeed, this.m_CommandRotator, Math.max(this.m_MountValueIndex[this.m_CommandRotator] - 1, 0));
                            this.m_TargetCoordinates[this.m_CommandRotator] = this.m_Median[this.m_CommandRotator] * 1.0;
                        }
                        if (this.m_CommandRotator == 1) {
                            this.m_DeltaTimeValueIndex = this.m_MountValueIndex[this.m_CommandRotator];
                            this.m_PcTime = this.makeDecimal(this.defaultTimestamp(3));
                            if (this.m_DeltaTimeValueIndex > 0) {
                                if (this.m_MountValues[this.m_CommandRotator][this.m_DeltaTimeValueIndex] - this.m_MountValues[this.m_CommandRotator][this.m_DeltaTimeValueIndex - 1] < 0.0) {
                                    this.m_CommandRotator = 0;
                                    this.m_NewSequenceStarted = true;
                                    this.m_ResetMenuBufferChanged = true;
                                    this.m_ResetMenuMinMaxChanged = true;
                                }
                                this.m_DeltaTimeValues[0][this.m_DeltaTimeValueIndex] = this.m_MountValues[this.m_CommandRotator][this.m_DeltaTimeValueIndex];
                                this.m_DeltaTimeValues[1][this.m_DeltaTimeValueIndex] = (this.m_PcTime - (this.m_PcUTCOffset + this.m_MountValues[this.m_CommandRotator][this.m_DeltaTimeValueIndex] + this.m_MountUTCOffset)) * 3600.0 * 1000.0;
                                this.m_DeltaTimeValues[2][this.m_DeltaTimeValueIndex] = (this.m_PcTime - this.m_PcOldTime) * 3600.0 * 1000.0;
                                this.m_DeltaTimeValues[3][this.m_DeltaTimeValueIndex] = (this.m_MountValues[this.m_CommandRotator][this.m_DeltaTimeValueIndex] - this.m_MountValues[this.m_CommandRotator][this.m_DeltaTimeValueIndex - 1]) * 3600.0 * 1000.0;
                                this.m_DeltaTimeValues[4][this.m_DeltaTimeValueIndex] = this.m_lastPC_NISTServerDifference;
                                this.getDeltaTimeMinMax();
                                if (this.m_DeltaTimeValueIndex == 1) {
                                    this.m_DeltaTimeValues[0][0] = this.m_DeltaTimeValues[0][1] * 1.0;
                                    this.m_DeltaTimeValues[1][0] = this.m_DeltaTimeValues[1][1] * 1.0;
                                    this.m_DeltaTimeValues[2][0] = this.m_DeltaTimeValues[2][1] * 1.0;
                                    this.m_DeltaTimeValues[3][0] = this.m_DeltaTimeValues[3][1] * 1.0;
                                    this.m_DeltaTimeValues[4][0] = this.m_DeltaTimeValues[4][1] * 1.0;
                                }
                                if (this.m_DeltaTimeValueIndex > 10) {
                                    LinearRegression linearRegression = new LinearRegression(this.m_DeltaTimeValues, 0, this.m_DeltaTimeValueIndex, 1);
                                    this.m_DeltaTimeSlope = linearRegression.slope();
                                    linearRegression = new LinearRegression(this.m_DeltaTimeValues, 0, this.m_DeltaTimeValueIndex, 4);
                                    this.m_PCTimeSlope = linearRegression.slope();
                                }
                            } else {
                                this.m_DeltaTimeValues[0][0] = this.m_MountValues[this.m_CommandRotator][0];
                            }
                            this.m_DTIDATAMedian = this.m_DeltaTimeValues[2][0];
                            this.m_PcOldTime = this.m_PcTime;
                        }
                        if (this.m_CommandRotator == 2 || this.m_CommandRotator == 3) {
                            double d4 = 0.0;
                            if (this.m_CommandRotator == 2 && !this.m_UseAsHATolerance) {
                                if (this.m_Median[3] != 90.0) {
                                    d4 = this.m_ToleranceRaDec / 15.0 / Math.cos(Math.toRadians(this.m_Median[3]));
                                }
                            } else {
                                d4 = this.m_ToleranceRaDec;
                            }
                            this.m_Median[this.m_CommandRotator] = this.getMedian(this.m_MountValues, this.m_CommandRotator, Math.max(this.m_MountValueIndex[this.m_CommandRotator] - 1, 0));
                            if (d4 > 0.0) {
                                if (this.m_ReferenceModeIndex == 0) {
                                    d2 = this.m_Median[this.m_CommandRotator] + d4 / 3600.0;
                                    d = this.m_Median[this.m_CommandRotator] - d4 / 3600.0;
                                } else {
                                    d2 = this.m_TargetCoordinates[this.m_CommandRotator] + d4 / 3600.0;
                                    d = this.m_TargetCoordinates[this.m_CommandRotator] - d4 / 3600.0;
                                }
                                if (this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] > d2 || this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] < d) {
                                    if (!this.m_ToleranceRaDecExceededY[this.m_CommandRotator]) {
                                        if (this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] > this.m_Median[this.m_CommandRotator] + d4 / 3600.0) {
                                            this.addToLogFile("VALUE EXCEEDED upper tolerance level: " + this.m_MountCommandSet[this.m_CommandRotator][3]);
                                            this.showText(this.m_TextStatus, "VALUE EXCEEDED upper tolerance level: " + this.m_MountCommandSet[this.m_CommandRotator][3]);
                                        } else {
                                            this.addToLogFile("VALUE EXCEEDED lower tolerance level: " + this.m_MountCommandSet[this.m_CommandRotator][3]);
                                            this.showText(this.m_TextStatus, "VALUE EXCEEDED lower tolerance level: " + this.m_MountCommandSet[this.m_CommandRotator][3]);
                                        }
                                    }
                                    this.m_ToleranceRaDecExceededY[this.m_CommandRotator] = true;
                                } else {
                                    if (this.m_ToleranceRaDecExceededY[this.m_CommandRotator]) {
                                        this.addToLogFile(this.m_MountCommandSet[this.m_CommandRotator][3] + " VALUE back within tolerance level.");
                                        this.showText(this.m_TextStatus, this.m_MountCommandSet[this.m_CommandRotator][3] + " VALUE back within tolerance level.");
                                    }
                                    this.m_ToleranceRaDecExceededY[this.m_CommandRotator] = false;
                                }
                                if (this.m_MountStdev[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator]] > d4 / 3600.0) {
                                    if (!this.m_ToleranceRaDecExceededSD[this.m_CommandRotator]) {
                                        this.addToLogFile("STDEV EXCEEDED tolerance level: " + this.m_MountCommandSet[this.m_CommandRotator][3]);
                                        this.showText(this.m_TextStatus, "STDEV EXCEEDED tolerance level: " + this.m_MountCommandSet[this.m_CommandRotator][3]);
                                    }
                                    this.m_ToleranceRaDecExceededSD[this.m_CommandRotator] = true;
                                } else {
                                    if (this.m_ToleranceRaDecExceededSD[this.m_CommandRotator]) {
                                        this.addToLogFile(this.m_MountCommandSet[this.m_CommandRotator][3] + " STDEV back within tolerance level.");
                                        this.showText(this.m_TextStatus, this.m_MountCommandSet[this.m_CommandRotator][3] + " STDEV back within tolerance level.");
                                    }
                                    this.m_ToleranceRaDecExceededSD[this.m_CommandRotator] = false;
                                }
                            }
                        }
                    }
                } else {
                    this.dropData("End loop");
                }
            }
            try {
                Thread.sleep(this.m_LoopWaitTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.closeFiles();
    }

    private void initVars() {
        int n;
        for (n = 0; n < this.m_MountCommandSet.length; ++n) {
            if (this.m_MountCommandSet[n][6] != "1") continue;
            if (this.m_MountDataRows == 0) {
                this.m_CommandRotatorFirstVal = n;
            }
            ++this.m_MountDataRows;
        }
        this.m_ToleranceRaDecExceededY = new boolean[this.m_MountDataRows];
        this.m_ToleranceRaDecExceededSD = new boolean[this.m_MountDataRows];
        this.m_MaxMountValues = new double[4][this.m_MountDataRows];
        this.m_MinMountValues = new double[4][this.m_MountDataRows];
        this.m_MaxStDev = new double[this.m_MountDataRows];
        this.m_Median = new double[this.m_MountDataRows];
        this.m_TargetCoordinates = new double[this.m_MountDataRows];
        this.m_MountValueIndex = new int[this.m_MountDataRows];
        this.m_RawMountData = new String[this.m_MountDataRows];
        this.m_MountValues = this.newDoubleArray(this.m_MountDataRows, this.m_MountDataCols);
        this.m_DeltaTimeValues = this.newDoubleArray(5, this.m_MountDataCols);
        this.m_SeismometerValues = this.newDoubleArray(2, this.m_MountDataCols * this.m_SeismometerFrequency);
        this.m_MountStdev = this.newDoubleArray(this.m_MountDataRows, this.m_MountDataCols);
        this.m_MountAxisSpeed = this.newDoubleArray(10, this.m_MountDataCols);
        this.m_SeismometerStDev = new double[this.m_MountDataCols * this.m_SeismometerFrequency];
        for (n = 0; n < this.m_MountDataRows; ++n) {
            this.m_ToleranceRaDecExceededY[n] = false;
            this.m_ToleranceRaDecExceededSD[n] = false;
            this.m_MaxStDev[n] = 0.0;
            this.m_Median[n] = 0.0;
            this.m_MountValueIndex[n] = -1;
        }
    }

    private boolean initSerialPort(int n) {
        boolean bl = false;
        try {
            if (this.m_SerialPort != null && this.m_SerialPortIndex != -1) {
                this.m_SerialPort.closePort();
                this.m_SerialPort = null;
            }
            this.m_SerialPort = this.m_AvailableSerialPorts[this.m_SerialPortIndex];
            if (!this.m_SerialPort.openPort()) {
                this.addToLogFile("FAILED to open Serial port");
                this.showText(this.m_TextStatus, "Serial port not opened");
                throw new IOException("Serial port not opened");
            }
            if (this.m_InitPortVerbose) {
                System.out.println("Opened Serial port " + n);
            }
            bl = true;
        }
        catch (IOException iOException) {
            if (this.m_InitPortVerbose) {
                System.out.println("Failure Opening Serial port " + n);
            }
            this.addToLogFile("FAILURE Opening Serial port " + n);
            this.showText(this.m_TextStatus, "Failure Opening Serial port " + n);
            bl = false;
        }
        return bl;
    }

    private void initTCPIPPort() {
        try {
            this.m_Socket = new Socket();
            this.m_Socket.connect(new InetSocketAddress(this.m_MountTCPIPAdress, this.m_MountTCPIPPort), 1000);
            this.m_Output = this.m_Socket.getOutputStream();
            this.m_Writer = new PrintWriter(this.m_Output, true);
            this.m_Input = this.m_Socket.getInputStream();
            this.m_Reader = new InputStreamReader(this.m_Input);
            this.m_ServerIsActive = true;
            if (this.m_InitPortVerbose) {
                System.out.println("Writers and Socket opened @ " + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
            }
            this.addToLogFile("Writers and Socket opened @ " + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
            this.showText(this.m_TextStatus, "Writers and Socket opened @ " + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
        }
        catch (IOException iOException) {
            this.showText(this.m_TextStatus, "Problem connecting (" + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort + "). Waiting ...");
            this.addToLogFile("PROBLEM CONNECTING (" + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort + "). Waiting ...");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.m_ServerIsActive = false;
            this.m_ResetConnection = true;
        }
        if (this.m_ResetConnection && this.m_ServerIsActive) {
            this.showText(this.m_TextStatus, "Connection restored.");
            this.addToLogFile("Connection restored.");
            this.m_ResetConnection = false;
            this.m_CommandMode = 0;
            this.m_PollingStartTime = this.getPcTime();
            this.getMountInfo();
        }
    }

    private void initSeismometerPort() {
        if (this.m_HasSeismometer) {
            for (int i = 0; i < this.m_AvailableSerialPorts.length; ++i) {
                if (this.m_InitPortVerbose) {
                    System.out.println("   [" + i + "] " + this.m_AvailableSerialPorts[i].getSystemPortName() + ": " + this.m_AvailableSerialPorts[i].getDescriptivePortName() + " - " + this.m_AvailableSerialPorts[i].getPortDescription());
                }
                if (this.m_AvailableSerialPorts[i].getPortDescription().indexOf("Seismometer") == -1 || this.m_SerialPortIndex != -1) continue;
                this.m_SerialPortIndex = i;
                this.m_FoundSeismometer = true;
            }
            if (this.m_SerialPortIndex != -1 && this.m_SerialPortIndex < this.m_AvailableSerialPorts.length) {
                this.m_SerialPortOpened = this.initSerialPort(this.m_SerialPortIndex);
                if (this.m_InitPortVerbose) {
                    System.out.println("Seismometer found at port " + this.m_AvailableSerialPorts[this.m_SerialPortIndex].getSystemPortName());
                }
                this.showText(this.m_TextStatus, "Seismometer found at port " + this.m_AvailableSerialPorts[this.m_SerialPortIndex].getSystemPortName());
                this.addToLogFile("Seismometer found at port " + this.m_AvailableSerialPorts[this.m_SerialPortIndex].getSystemPortName());
            }
        }
    }

    private void initASCOMConnection() {
        String string;
        Object object;
        Boolean bl = false;
        try {
            object = new ActiveXComponent("ASCOM.Utilities.Util");
            string = this.requestASCOMData((Dispatch)object, "PlatformVersion");
            this.showText(this.m_TextStatus, "The ASCOM Platform Version is " + string);
            bl = true;
        }
        catch (ComFailException comFailException) {
            this.alertBox("Interface set-up", "No ASCOM platform found!\nSwitching to LX200...");
            this.showText(this.m_TextStatus, "No ASCOM platform found! Switching to LX200...");
            this.addToLogFile("No ASCOM platform found! Switching to LX200...");
            this.m_CommandMode = 0;
            this.initTCPIPPort();
        }
        if (bl.booleanValue()) {
            object = false;
            string = "" + this.m_ASCOMScopeId;
            while (!this.m_ServerIsActive || this.m_ASCOMForceChooser.booleanValue()) {
                if (this.m_ASCOMScopeId.equals("") || this.m_ASCOMForceChooser.booleanValue()) {
                    this.showText(this.m_TextStatus, "Opening ASCOM Chooser (may be in background)...");
                    this.alertBox("Opening ASCOM Chooser", "The ASCOM Chooser opens after clicking OK,<BR>it may be in background though!<BR><BR>(Click OK and search for it by [ALT]-[TAB])");
                    ActiveXComponent activeXComponent = new ActiveXComponent("ASCOM.Utilities.Chooser");
                    activeXComponent.setProperty("DeviceType", "Telescope");
                    this.m_ASCOMScopeId = Dispatch.call((Dispatch)activeXComponent, (String)"Choose", (Object[])new Object[]{string}).toString();
                    this.showText(this.m_TextStatus, "You selected this driver - " + this.m_ASCOMScopeId + ".");
                    this.addToLogFile("You selected this driver - " + this.m_ASCOMScopeId + ".");
                    if (this.m_ASCOMScopeId == "") continue;
                    this.m_ServerIsActive = this.m_ASCOMForceChooser == false;
                    this.m_ASCOMForceChooser = false;
                    continue;
                }
                try {
                    this.showText(this.m_TextStatus, "Attempt comms with: " + this.m_ASCOMScopeId);
                    this.addToLogFile("Attempt comms with: " + this.m_ASCOMScopeId);
                    this.m_TheScopeDispatch = new ActiveXComponent(this.m_ASCOMScopeId);
                    Dispatch.put((Dispatch)this.m_TheScopeDispatch, (String)"Connected", (Object)true);
                    if (!this.requestASCOMData(this.m_TheScopeDispatch, "Connected").equals("true")) continue;
                    this.m_CommandMode = 1;
                    this.getMountInfo();
                    this.m_InitASCOMTargetCoordinates = true;
                    this.m_ServerIsActive = true;
                    this.showText(this.m_TextStatus, "Connected to ASCOM: " + this.m_ASCOMScopeId);
                    this.addToLogFile("Connected to ASCOM: " + this.m_ASCOMScopeId);
                }
                catch (ComFailException comFailException) {
                    this.showText(this.m_TextStatus, "No response from: " + this.m_ASCOMScopeId);
                    this.addToLogFile("NO RESPONSE from: " + this.m_ASCOMScopeId);
                }
            }
            if (this.m_ResetConnection && this.m_ServerIsActive) {
                this.showText(this.m_TextStatus, "Connection restored.");
                this.addToLogFile("Connection restored.");
                this.m_ResetConnection = false;
                this.m_InitASCOMTargetCoordinates = true;
            }
        }
    }

    private void resetConnection() {
        this.showText(this.m_TextStatus, "Resetting connection: " + this.m_ProtocolModeMenu[this.m_CommandMode]);
        this.addToLogFile("Resetting connection: " + this.m_ProtocolModeMenu[this.m_CommandMode]);
        if (this.m_CommandMode == 0) {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            try {
                                this.m_Writer.close();
                            }
                            catch (NullPointerException nullPointerException) {
                                if (!this.m_VerboseErrors) break block13;
                                System.out.println("Writer not open yet");
                            }
                        }
                        try {
                            this.m_Reader.close();
                        }
                        catch (IOException | NullPointerException exception) {
                            if (!this.m_VerboseErrors) break block14;
                            System.out.println("Closing reader failed");
                        }
                    }
                    try {
                        this.m_Socket.close();
                    }
                    catch (IOException | NullPointerException exception) {
                        if (!this.m_VerboseErrors) break block15;
                        System.out.println("Closing socket failed");
                    }
                }
                this.m_MountStatus = -2;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.m_VerboseErrors) break block16;
                    interruptedException.printStackTrace();
                }
            }
            this.initTCPIPPort();
            this.m_CommandRotator = 0;
            if (this.m_ServerIsActive) {
                this.requestMountData(this.m_Writer, this.m_Reader, 13);
                this.m_DropLastData = true;
            }
            this.m_MountStatus = 0;
        } else if (this.m_CommandMode == 1) {
            this.initASCOMConnection();
            this.m_CommandRotator = 0;
            if (this.m_ServerIsActive) {
                this.m_DropLastData = true;
            }
            this.m_MountStatus = 0;
        }
    }

    public void InitASCOMTargetCoordinates() {
        Boolean bl = false;
        Double d = this.makeDecimal(this.requestMountData(this.m_Writer, this.m_Reader, 2));
        Double d2 = this.makeDecimal(this.requestMountData(this.m_Writer, this.m_Reader, 3));
        if (!this.m_TestModeSimulateMount) {
            try {
                Dispatch.put((Dispatch)this.m_TheScopeDispatch, (String)this.m_MountCommandSet[18][2], (Object)d);
                Dispatch.put((Dispatch)this.m_TheScopeDispatch, (String)this.m_MountCommandSet[19][2], (Object)d2);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            bl = true;
        }
        if (bl.booleanValue()) {
            this.m_InitASCOMTargetCoordinates = false;
            this.showText(this.m_TextStatus, "TargetCoordinates initiated");
            this.addToLogFile("TargetCoordinates initiated");
        } else {
            this.m_InitASCOMTargetCoordinates = true;
            this.showText(this.m_TextStatus, "Failed to initialise TargetCoordinates");
            this.addToLogFile("FAILED to initialise TargetCoordinates");
        }
    }

    public void EnableAxialSpeed() {
        if (!this.m_RequestAxialSpeed) {
            this.m_MountCommandSet[4][6] = "0";
            this.m_MountCommandSet[5][6] = "0";
        } else {
            this.m_MountCommandSet[4][6] = "1";
            this.m_MountCommandSet[5][6] = "1";
        }
    }

    public double[][] newDoubleArray(int n, int n2) {
        return new double[n][n2];
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        int n2 = this.m_MeasureModeIndex;
        for (n = 0; n < this.m_PollingModeMenuItem.length; ++n) {
            if (itemEvent.getSource() != this.m_PollingModeMenuItem[n]) continue;
            this.m_NewPollModeIndex = n;
            this.m_PollingModeMenuChanged = true;
            break;
        }
        for (n = 0; n < this.m_LoggingModeMenuItem.length; ++n) {
            if (itemEvent.getSource() != this.m_LoggingModeMenuItem[n]) continue;
            this.m_LogModeIndex = n;
            this.m_LoggingModeMenuChanged = true;
            break;
        }
        for (n = 0; n < this.m_ToleranceRaDecModeMenuItem.length; ++n) {
            if (itemEvent.getSource() != this.m_ToleranceRaDecModeMenuItem[n]) continue;
            this.m_ToleranceRaDecModeIndex = n;
            this.m_ToleranceRaDecModeMenuChanged = true;
            break;
        }
        for (n = 0; n < this.m_HorZoomModeMenuItem.length; ++n) {
            if (itemEvent.getSource() != this.m_HorZoomModeMenuItem[n]) continue;
            this.m_NewHorZoomIndex = n;
            this.m_HorZoomModeMenuChanged = true;
            break;
        }
        for (n = 0; n < this.m_VerZoomModeMenuItem.length; ++n) {
            if (itemEvent.getSource() != this.m_VerZoomModeMenuItem[n]) continue;
            this.m_VerZoomIndex = n;
            this.m_VerZoomModeMenuChanged = true;
            break;
        }
        if (this.m_HorZoomModeMenuChanged) {
            for (n = 0; n < this.m_HorZoomModeMenuItem.length; ++n) {
                this.m_HorZoomModeMenuItem[n].removeItemListener(this);
                this.m_HorZoomModeMenuItem[n].setState(this.m_NewHorZoomIndex == n);
                this.m_HorZoomModeMenuItem[n].addItemListener(this);
            }
        }
        if (this.m_VerZoomModeMenuChanged) {
            for (n = 0; n < this.m_VerZoomModeMenuItem.length; ++n) {
                this.m_VerZoomModeMenuItem[n].removeItemListener(this);
                this.m_VerZoomModeMenuItem[n].setState(this.m_VerZoomIndex == n);
                this.m_VerZoomModeMenuItem[n].addItemListener(this);
            }
        }
        this.savePrefs();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_AboutMenuItem) {
            this.aboutBox();
        }
        if (actionEvent.getSource() == this.m_FFTPeriodMenuItem) {
            this.m_FFTModeIsFrequency = false;
            this.fftBox();
        }
        if (actionEvent.getSource() == this.m_FFTFrequencyMenuItem) {
            this.m_FFTModeIsFrequency = true;
            this.fftBox();
        }
        if (actionEvent.getSource() == this.m_PrefsMenuItem) {
            this.setPrefs();
        }
        if (actionEvent.getSource() == this.m_HelpMenuItem) {
            this.openHelp();
        }
        if (actionEvent.getSource() == this.m_ResetMenuItem[0]) {
            this.m_ResetMenuBufferChanged = true;
        }
        if (actionEvent.getSource() == this.m_ResetMenuItem[1]) {
            this.m_ResetMenuMinMaxChanged = true;
        }
        if (actionEvent.getSource() == this.m_ResetMenuItem[2]) {
            this.m_ResetMenuBufferChanged = true;
            this.m_ResetMenuMinMaxChanged = true;
        }
        if (actionEvent.getSource() == this.m_ResetMenuItem[3]) {
            this.m_ResetMenuNewFileChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePrefs() {
        try {
            File file = new File(m_PrefsFileName);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));){
                bufferedWriter.write("[MountMonitor Version]\r\n");
                bufferedWriter.write(this.m_Version + "\r\n");
                bufferedWriter.write("[E-Mail]\r\n");
                bufferedWriter.write(this.m_EMail + "\r\n");
                bufferedWriter.write("[Mount name]\r\n");
                bufferedWriter.write(this.m_MountName + "\r\n");
                bufferedWriter.write("[Site name]\r\n");
                bufferedWriter.write(this.m_Sitename + "\r\n");
                bufferedWriter.write("[ASCOM driver]\r\n");
                bufferedWriter.write(this.m_ASCOMScopeId + "\r\n");
                bufferedWriter.write("[IP address]\r\n");
                bufferedWriter.write(this.m_MountTCPIPAdress + "\r\n");
                bufferedWriter.write("[Port]\r\n");
                bufferedWriter.write(this.m_MountTCPIPPort + "\r\n");
                bufferedWriter.write("[Command mode]\r\n");
                bufferedWriter.write(this.m_CommandMode + "\r\n");
                bufferedWriter.write("[Delay after slewing mode]\r\n");
                bufferedWriter.write(this.m_DelayAfterSlewModeIndex + "\r\n");
                bufferedWriter.write("[Polling mode]\r\n");
                bufferedWriter.write(this.m_PollingModeIndex + "\r\n");
                bufferedWriter.write("[Logging mode]\r\n");
                bufferedWriter.write(this.m_LogModeIndex + "\r\n");
                bufferedWriter.write("[Tolerance RA/DEC mode]\r\n");
                bufferedWriter.write(this.m_ToleranceRaDecModeIndex + "\r\n");
                bufferedWriter.write("[Use as HA tolerance]\r\n");
                bufferedWriter.write(this.m_UseAsHATolerance + "\r\n");
                bufferedWriter.write("[Axis speed mode index]\r\n");
                bufferedWriter.write(this.m_AxisSpeedModeIndex + "\r\n");
                if (this.m_HadSeismometer) {
                    bufferedWriter.write("[Show Seismometer Data]\r\n");
                    bufferedWriter.write(this.m_ShowSeismometer + "\r\n");
                    bufferedWriter.write("[Seismometer Serial Port]\r\n");
                    bufferedWriter.write(this.m_SerialPortIndex + "\r\n");
                    bufferedWriter.write("[Tolerance Seismometer Mode]\r\n");
                    bufferedWriter.write(this.m_ToleranceSeismometerModeIndex + "\r\n");
                    bufferedWriter.write("[Seismometer Offset]\r\n");
                    bufferedWriter.write(this.m_SeismometerOffset + "\r\n");
                    bufferedWriter.write("[Seismometer Range]\r\n");
                    bufferedWriter.write(this.m_SeismometerRange + "\r\n");
                }
                bufferedWriter.write("[NIST Time Server]\r\n");
                bufferedWriter.write(this.m_NistTimeServer + "\r\n");
                bufferedWriter.write("[Use NIST Time Server]\r\n");
                bufferedWriter.write(this.m_UseNistTimeServer + "\r\n");
                bufferedWriter.write("[NIST Time Polling Interval]\r\n");
                bufferedWriter.write(this.m_NistTimeServerPollingModeIndex + "\r\n");
                bufferedWriter.write("[Time Graph Max Zoom-out Value]\r\n");
                bufferedWriter.write(this.m_TimeGraphMaxZoomOffsetModeIndex + "\r\n");
                bufferedWriter.write("[Running range mode]\r\n");
                bufferedWriter.write(this.m_RunningRangeModeIndex + "\r\n");
                bufferedWriter.write("[Adjust Graphs For Running Range Length]\r\n");
                bufferedWriter.write(this.m_AdjustGraphsForRunningRangeLength + "\r\n");
                bufferedWriter.write("[Reference mode]\r\n");
                bufferedWriter.write(this.m_ReferenceModeIndex + "\r\n");
                bufferedWriter.write("[Horizontal Zoom mode]\r\n");
                bufferedWriter.write(this.m_HorZoomIndex + "\r\n");
                bufferedWriter.write("[Vertical Zoom mode]\r\n");
                bufferedWriter.write(this.m_VerZoomIndex + "\r\n");
                bufferedWriter.write("[Reset buffers and min/max mode]\r\n");
                bufferedWriter.write(this.m_ResetBuffersAndMinMaxModeIndex + "\r\n");
                bufferedWriter.write("[Dump graphs mode]\r\n");
                bufferedWriter.write(this.m_DumpGraphsModeIndex + "\r\n");
                bufferedWriter.write("[Close files mode]\r\n");
                bufferedWriter.write(this.m_CloseFilesModeIndex + "\r\n");
                bufferedWriter.write("[Frame Width (px)]\r\n");
                this.m_FrameWidth = this.m_Frame.getWidth() == 0 ? 1200 : this.m_Frame.getWidth();
                bufferedWriter.write(this.m_FrameWidth + "\r\n");
                bufferedWriter.write("[Frame Height (px)]\r\n");
                this.m_FrameHeight = this.m_Frame.getHeight() == 0 ? 690 : this.m_Frame.getHeight();
                bufferedWriter.write(this.m_FrameHeight + "\r\n");
                bufferedWriter.write("[Frame X (px)]\r\n");
                this.m_FrameX = this.m_Frame.getX() == 0 ? 50 : this.m_Frame.getX();
                bufferedWriter.write(this.m_FrameX + "\r\n");
                bufferedWriter.write("[Frame Y (px)]\r\n");
                this.m_FrameY = this.m_Frame.getY() == 0 ? 50 : this.m_Frame.getY();
                bufferedWriter.write(this.m_FrameY + "\r\n");
                bufferedWriter.write("[Graph to Textbox Ratio (textbox = 1)]\r\n");
                if (this.GRAPHRATIO == 0.0) {
                    this.GRAPHRATIO = 4.0;
                }
                bufferedWriter.write(this.m_WindowRatioModeIndex + 1 + "\r\n");
                bufferedWriter.write("[FFT Box Width (px)]\r\n");
                bufferedWriter.write(this.m_FFTBoxWidth + "\r\n");
                bufferedWriter.write("[FFT Box Height (px)]\r\n");
                bufferedWriter.write(this.m_FFTBoxHeight + "\r\n");
                bufferedWriter.write("[FFT Box X (px)]\r\n");
                bufferedWriter.write(this.m_FFTBoxX + "\r\n");
                bufferedWriter.write("[FFT Box Y (px)]\r\n");
                bufferedWriter.write(this.m_FFTBoxY + "\r\n");
                bufferedWriter.write("[Checks to be performed]\r\n");
                if (this.m_CheckMountSettingsIndexesList.size() > 0) {
                    // empty if block
                }
                for (int i = 0; i < this.m_CheckMountSettingsIndexesList.size(); ++i) {
                    int[] nArray = this.m_CheckMountSettingsIndexesList.get(i);
                    bufferedWriter.write(nArray[0] + "~" + nArray[1] + "~" + nArray[2] + "\r\n");
                }
                bufferedWriter.write("[/Checks to be performed]\r\n");
            }
        }
        catch (IOException iOException) {
            System.out.println("Error writing prefs file");
        }
    }

    private void readPrefs() {
        Boolean bl = false;
        String string = "The MountMonitor.prefs file is not compatible with the current MountMonitor version, the following issues were detected:\n<BR>\n<BR>";
        Boolean bl2 = false;
        String string2 = "";
        File file = new File(m_PrefsFileName);
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf("[") == -1) continue;
                    switch (string2.toLowerCase()) {
                        case "[mountmonitor version]": {
                            bl2 = true;
                            break;
                        }
                        case "[e-mail]": {
                            this.m_EMail = bufferedReader.readLine();
                            break;
                        }
                        case "[mount name]": {
                            this.m_MountName = bufferedReader.readLine();
                            break;
                        }
                        case "[site name]": {
                            this.m_Sitename = bufferedReader.readLine();
                            break;
                        }
                        case "[ascom driver]": {
                            this.m_ASCOMScopeId = bufferedReader.readLine();
                            break;
                        }
                        case "[ip address]": {
                            this.m_MountTCPIPAdress = bufferedReader.readLine();
                            break;
                        }
                        case "[port]": {
                            this.m_MountTCPIPPort = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[command mode]": {
                            this.m_CommandMode = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_CommandMode == 0 || this.m_CommandMode == 1) break;
                            bl = true;
                            string = string + string2 + " Index (should be " + 0 + " or " + 1 + ".\n<BR>";
                            this.m_CommandMode = 0;
                            break;
                        }
                        case "[logging mode]": {
                            this.m_LogModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_LogModeIndex >= 0 && this.m_LogModeIndex < this.m_LoggingModeMenu.length) break;
                            bl = true;
                            string = string + string2 + " Index (should be between 0 and " + this.m_LoggingModeMenu.length + ".\n<BR>";
                            this.m_LogModeIndex = 0;
                            break;
                        }
                        case "[polling mode]": {
                            this.m_PollingModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_PollingModeIndex >= 0 && this.m_PollingModeIndex < this.m_PollingModeMenu.length) break;
                            bl = true;
                            string = string + string2 + " Index (should be between 0 and " + this.m_PollingModeMenu.length + ".\n<BR>";
                            this.m_PollingModeIndex = 0;
                            break;
                        }
                        case "[delay after slewing mode]": {
                            this.m_DelayAfterSlewModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_DelayAfterSlewModeIndex < 0 || this.m_DelayAfterSlewModeIndex >= this.m_DelayAfterSlewModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_DelayAfterSlewModeMenu.length + ".\n<BR>";
                                this.m_DelayAfterSlewModeIndex = 0;
                            }
                            this.m_DelayAfterSlewing = this.m_DelayAfterSlewModeMenu[this.m_DelayAfterSlewModeIndex];
                            break;
                        }
                        case "[tolerance ra/dec mode]": {
                            this.m_ToleranceRaDecModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_ToleranceRaDecModeIndex < 0 || this.m_ToleranceRaDecModeIndex >= this.m_ToleranceRaDecModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_ToleranceRaDecModeMenu.length + ".\n<BR>";
                                this.m_ToleranceRaDecModeIndex = 0;
                            }
                            this.m_ToleranceRaDec = this.getToleranceRaDec();
                            break;
                        }
                        case "[use as ha tolerance]": {
                            this.m_UseAsHATolerance = bufferedReader.readLine().trim().indexOf("true") != -1;
                            break;
                        }
                        case "[axis speed mode index]": {
                            this.m_AxisSpeedModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_AxisSpeedModeIndex < 0 || this.m_AxisSpeedModeIndex >= this.m_AxisSpeedModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_AxisSpeedModeMenu.length + ".\n<BR>";
                                this.m_AxisSpeedModeIndex = 0;
                            }
                            this.m_RequestAxialSpeed = this.m_AxisSpeedModeIndex > 0;
                            this.m_ShowAxialSpeed = this.m_AxisSpeedModeIndex > 1;
                            this.m_ShowAxialSpeedAsDisplacement = this.m_AxisSpeedModeIndex == 3;
                            this.EnableAxialSpeed();
                            break;
                        }
                        case "[show seismometer data]": {
                            this.m_ShowSeismometer = bufferedReader.readLine().trim().indexOf("true") != -1;
                            this.m_HadSeismometer = true;
                            break;
                        }
                        case "[tolerance seismometer mode]": {
                            this.m_ToleranceSeismometerModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_ToleranceSeismometerModeIndex < 0 || this.m_ToleranceSeismometerModeIndex >= this.m_ToleranceSeismometerModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_ToleranceSeismometerModeMenu.length + ".\n<BR>";
                                this.m_ToleranceSeismometerModeIndex = 0;
                            }
                            this.m_HadSeismometer = true;
                            break;
                        }
                        case "[seismometer serial port]": {
                            this.m_SerialPortIndex = Integer.parseInt(bufferedReader.readLine());
                            if (bl2.booleanValue() && this.m_ShowSeismometer && (this.m_SerialPortIndex < 0 || this.m_SerialPortIndex >= this.m_AvailableSerialPorts.length)) {
                                bl = true;
                                string = this.m_AvailableSerialPorts.length == 0 ? string + string2 + " Index (No serial port detected).\n<BR>" : string + string2 + " Index (should be between 0 and " + this.m_AvailableSerialPorts.length + ").\n<BR>";
                                this.m_SerialPortIndex = 0;
                                this.m_ShowSeismometer = false;
                            }
                            this.m_HadSeismometer = true;
                            break;
                        }
                        case "[seismometer offset]": {
                            this.m_SeismometerOffset = Integer.parseInt(bufferedReader.readLine());
                            this.m_HadSeismometer = true;
                            break;
                        }
                        case "[seismometer range]": {
                            this.m_SeismometerRange = Integer.parseInt(bufferedReader.readLine());
                            this.m_HadSeismometer = true;
                            break;
                        }
                        case "[nist time server]": {
                            this.m_NistTimeServer = bufferedReader.readLine();
                            break;
                        }
                        case "[use nist time server]": {
                            this.m_UseNistTimeServer = bufferedReader.readLine().trim().indexOf("true") != -1;
                            break;
                        }
                        case "[nist time polling interval]": {
                            this.m_NistTimeServerPollingModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_NistTimeServerPollingModeIndex < 0 || this.m_NistTimeServerPollingModeIndex >= this.m_NistTimeServerPollingIntervalModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_NistTimeServerPollingIntervalModeMenu.length + ".\n<BR>";
                                this.m_NistTimeServerPollingModeIndex = 0;
                            }
                            this.m_NistTimeServerPollingInterval = this.m_NistTimeServerPollingIntervalModeMenu[this.m_NistTimeServerPollingModeIndex];
                            break;
                        }
                        case "[time graph max zoom-out value]": {
                            this.m_TimeGraphMaxZoomOffsetModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_TimeGraphMaxZoomOffsetModeIndex < 0 || this.m_TimeGraphMaxZoomOffsetModeIndex >= this.m_TimeGraphMaxZoomOffsetModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_TimeGraphMaxZoomOffsetModeMenu.length + ".\n<BR>";
                                this.m_TimeGraphMaxZoomOffsetModeIndex = 0;
                            }
                            this.m_TimeGraphMaxZoomOffset = this.m_TimeGraphMaxZoomOffsetModeMenu[this.m_TimeGraphMaxZoomOffsetModeIndex];
                            break;
                        }
                        case "[running range mode]": {
                            this.m_RunningRangeModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_RunningRangeModeIndex < 0 || this.m_RunningRangeModeIndex >= this.m_RunningRangeModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_RunningRangeModeMenu.length + ".\n<BR>";
                                this.m_RunningRangeModeIndex = 0;
                            }
                            this.m_RunningRangeLength = this.m_RunningRangeModeMenu[this.m_RunningRangeModeIndex];
                            break;
                        }
                        case "[adjust graphs for running range length]": {
                            this.m_AdjustGraphsForRunningRangeLength = bufferedReader.readLine().trim().indexOf("true") != -1;
                            break;
                        }
                        case "[reference mode]": {
                            this.m_ReferenceModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_ReferenceModeIndex >= 0 && this.m_ReferenceModeIndex < this.m_ReferenceModeMenu.length) break;
                            bl = true;
                            string = string + string2 + " Index (should be between 0 and " + this.m_ReferenceModeMenu.length + ".\n<BR>";
                            this.m_ReferenceModeIndex = 0;
                            break;
                        }
                        case "[horizontal zoom mode]": {
                            this.m_HorZoomIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_HorZoomIndex < 0 || this.m_HorZoomIndex >= this.m_HorZoomModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_HorZoomModeMenu.length + ".\n<BR>";
                                this.m_HorZoomIndex = 0;
                            }
                            this.m_HorizontalScale = this.m_HorZoomModeMenu[this.m_HorZoomIndex];
                            break;
                        }
                        case "[vertical zoom mode]": {
                            this.m_VerZoomIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_VerZoomIndex >= 0 && this.m_VerZoomIndex < this.m_VerZoomModeMenu.length) break;
                            bl = true;
                            string = string + string2 + " Index (should be between 0 and " + this.m_VerZoomModeMenu.length + ".\n<BR>";
                            this.m_VerZoomIndex = 0;
                            break;
                        }
                        case "[reset buffers and min/max mode]": {
                            this.m_ResetBuffersAndMinMaxModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_ResetBuffersAndMinMaxModeIndex < 0 || this.m_ResetBuffersAndMinMaxModeIndex >= this.m_ResetBuffersAndMinMaxModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_ResetBuffersAndMinMaxModeMenu.length + ".\n<BR>";
                                this.m_ResetBuffersAndMinMaxModeIndex = 0;
                            }
                            this.m_ResetBuffersAndMinMaxWhenSlewing = this.m_ResetBuffersAndMinMaxModeIndex == 1;
                            break;
                        }
                        case "[dump graphs mode]": {
                            this.m_DumpGraphsModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_DumpGraphsModeIndex < 0 || this.m_DumpGraphsModeIndex >= this.m_DumpGraphsModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_ResetBuffersAndMinMaxModeMenu.length + ".\n<BR>";
                                this.m_DumpGraphsModeIndex = 0;
                            }
                            this.m_DumpGraphsWhenSlewing = this.m_DumpGraphsModeIndex == 1;
                            this.m_DumpGraphsWhenParked = this.m_DumpGraphsModeIndex == 2;
                            break;
                        }
                        case "[close files mode]": {
                            this.m_CloseFilesModeIndex = Integer.parseInt(bufferedReader.readLine());
                            if (this.m_CloseFilesModeIndex < 0 || this.m_CloseFilesModeIndex >= this.m_CloseFilesModeMenu.length) {
                                bl = true;
                                string = string + string2 + " Index (should be between 0 and " + this.m_CloseFilesModeMenu.length + ".\n<BR>";
                                this.m_CloseFilesModeIndex = 0;
                            }
                            this.m_CloseFilesWhenSlewing = this.m_CloseFilesModeIndex == 1;
                            this.m_CloseFilesWhenParked = this.m_CloseFilesModeIndex == 2;
                            break;
                        }
                        case "[frame width (px)]": {
                            this.m_FrameWidth = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[frame height (px)]": {
                            this.m_FrameHeight = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[frame x (px)]": {
                            this.m_FrameX = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[frame y (px)]": {
                            this.m_FrameY = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[graph to textbox ratio (textbox = 1)]": {
                            this.GRAPHRATIO = Double.parseDouble(bufferedReader.readLine());
                            this.m_WindowRatioModeIndex = (int)(this.GRAPHRATIO - 1.0);
                            break;
                        }
                        case "[fft box width (px)]": {
                            this.m_FFTBoxWidth = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[fft box height (px)]": {
                            this.m_FFTBoxHeight = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[fft box x (px)]": {
                            this.m_FFTBoxX = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[fft box y (px)]": {
                            this.m_FFTBoxY = Integer.parseInt(bufferedReader.readLine());
                            break;
                        }
                        case "[checks to be performed]": {
                            this.m_CheckMountSettingsIndexesList.clear();
                            String string3 = "";
                            Boolean bl3 = true;
                            int n = 0;
                            int n2 = 0;
                            while (!(string3 = bufferedReader.readLine()).equals("[/Checks to be performed]")) {
                                int[] nArray = new int[]{0, 0, 0};
                                String[] stringArray = string3.split("~");
                                for (int i = 0; i < stringArray.length; ++i) {
                                    if (MountMonitor.isNumeric(stringArray[i])) {
                                        if (i == 0) {
                                            if (n == 0) {
                                                n2 = 23 - Integer.parseInt(stringArray[i]);
                                            }
                                            nArray[i] = Integer.parseInt(stringArray[i]) + n2;
                                            if (nArray[i] < 23 || nArray[i] >= this.m_MountCommandSet.length) {
                                                bl3 = false;
                                            }
                                            ++n;
                                            continue;
                                        }
                                        if (i == 1) {
                                            nArray[i] = Integer.parseInt(stringArray[i]);
                                            if (nArray[i] <= this.getCharCount(this.m_MountCommandSet[nArray[0]][i + 9 - 1], "~") + 1) continue;
                                            bl3 = false;
                                            continue;
                                        }
                                        nArray[i] = Integer.parseInt(stringArray[i]);
                                        if (nArray[i] == 0 || nArray[i] == 1) continue;
                                        bl3 = false;
                                        continue;
                                    }
                                    nArray[i] = 0;
                                }
                                this.m_CheckMountSettingsIndexesList.add(nArray);
                            }
                            if (bl3.booleanValue()) break;
                            bl = true;
                            string = string + string2 + " Indexes not compatible with this version.\n<BR>";
                            this.m_CheckMountSettingsIndexesList.clear();
                        }
                    }
                }
                if (this.GRAPHRATIO != 0.0 && this.TEXTBOXRATIO != 0.0) {
                    this.TOTALRATIO = 2.0 * this.GRAPHRATIO + this.TEXTBOXRATIO;
                }
                bufferedReader.close();
                if (bl.booleanValue()) {
                    string = string + "\n<BR>\nPlease check the set-up in the Preferences menu and correct where applicable.\n<BR>The settings have been reset to their default values!";
                    this.alertBox("Preference problem", string);
                }
            }
            catch (IOException iOException) {
                System.out.println("Error reading prefs file");
            }
        } else {
            System.out.println("File not found, created a new one, please edit IP address and port!");
            this.savePrefs();
            System.exit(0);
        }
    }

    private Boolean checkIfItIsMe() {
        boolean bl = true;
        String string = "";
        File file = new File("C:" + File.separator + "mountmonitor.licence");
        if (!file.exists()) {
            bl = false;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (string.compareTo("ditweetalleenik") != 0) {
            bl = false;
        }
        return bl;
    }

    private void calculatePanelSizes() {
        this.m_FrameInsets = this.m_Frame.getInsets();
        Dimension dimension = this.m_Frame.getSize();
        this.m_FrameWidth = dimension.width;
        this.m_FrameHeight = dimension.height;
        int n = this.m_FrameHeight - this.m_FrameInsets.top - this.m_FrameInsets.bottom;
        this.m_GraphPanelWidth = this.m_FrameWidth - this.m_FrameInsets.left - this.m_FrameInsets.right;
        this.m_GraphPanelHeight = (int)((double)n * (this.GRAPHRATIO * 2.0 / (double)this.NUMGRAPHS / this.TOTALRATIO));
        dimension.height -= this.m_FrameInsets.bottom + this.m_FrameInsets.top;
        dimension.width -= this.m_FrameInsets.right + this.m_FrameInsets.left;
        this.m_TextAreaHeight = (int)((double)dimension.height * (this.TEXTBOXRATIO / this.TOTALRATIO) - (double)(this.m_GraphPanelSpacing * this.NUMGRAPHS));
    }

    private void initResultGraphPanel() {
        this.resultGraphPanel.removeAll();
        this.resultGraphPanel.revalidate();
        this.resultGraphPanel.repaint();
        if (this.m_HasSeismometer && this.m_ShowSeismometer) {
            this.resultGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight * 3);
            this.resultGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight * 3));
        } else {
            this.resultGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight * 2);
            this.resultGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight * 2));
        }
        this.m_RaGraphPanel = new GraphPanel(this.m_FrameWidth, this.m_GraphPanelHeight, Color.yellow);
        this.m_RaGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight);
        this.m_RaGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight));
        this.m_RaGraphPanel.setMinimumSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight));
        this.m_RaGraphPanel.setLocation(0, 0);
        this.m_DecGraphPanel = new GraphPanel(this.m_FrameWidth, this.m_GraphPanelHeight, Color.yellow);
        this.m_DecGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight);
        this.m_DecGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight));
        this.m_DecGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 1);
        this.m_SeisGraphPanel = new GraphPanel(this.m_FrameWidth, this.m_GraphPanelHeight, Color.yellow);
        if (this.m_HasSeismometer && this.m_ShowSeismometer) {
            this.m_SeisGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight);
            this.m_SeisGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight));
            this.m_SeisGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 2);
            this.m_TimeGraphPanel = new GraphPanel(this.m_FrameWidth, this.m_GraphPanelHeight, Color.yellow);
            this.m_TimeGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight);
            this.m_TimeGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight));
            this.m_TimeGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 3);
        } else {
            this.m_TimeGraphPanel = new GraphPanel(this.m_FrameWidth, this.m_GraphPanelHeight, Color.yellow);
            this.m_TimeGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight);
            this.m_TimeGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight));
            this.m_TimeGraphPanel.setLocation(0, (this.m_GraphPanelHeight + 1 + this.m_GraphPanelSpacing) * 2);
        }
        this.resultGraphPanel.add(this.m_RaGraphPanel);
        this.resultGraphPanel.add(this.m_DecGraphPanel);
        if (this.m_HasSeismometer && this.m_ShowSeismometer) {
            this.resultGraphPanel.add(this.m_SeisGraphPanel);
        }
        this.resultGraphPanel.add(this.m_TimeGraphPanel);
        this.m_DecGraphPanel.setPollFrequency(this.m_PollingModeMenu[this.m_PollingModeIndex]);
        this.m_DecGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
        this.m_DecGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
        this.m_DecGraphPanel.setPort(this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
        this.m_DecGraphPanel.setTimeData(1);
        this.m_DecGraphPanel.setYDataSetShown(3);
        this.m_DecGraphPanel.setModeText(this.m_MountCommandSet[3][3]);
        this.m_DecGraphPanel.setToleranceRaDec(this.m_ToleranceRaDec);
        this.m_DecGraphPanel.setHScale(this.m_HorizontalScale);
        this.m_DecGraphPanel.setVScale(this.m_VerZoomIndex);
        this.m_DecGraphImg = this.m_DecGraphPanel.getImage();
        this.m_DecGraphPanel.setImage((BufferedImage)this.m_DecGraphImg);
        this.m_DecGraphGraphics = (Graphics2D)this.m_DecGraphPanel.getGraphics();
        this.m_DecGraphPanel.setActive();
        this.m_SeisGraphPanel.setPollFrequency(this.m_PollingModeMenu[this.m_PollingModeIndex]);
        this.m_SeisGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
        this.m_SeisGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
        this.m_SeisGraphPanel.setPort(this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
        this.m_SeisGraphPanel.setTimeData(1);
        this.m_SeisGraphPanel.setYDataSetShown(3);
        this.m_SeisGraphPanel.setModeText("Seismic");
        this.m_SeisGraphPanel.setToleranceRaDec(this.m_ToleranceRaDec);
        this.m_ToleranceSeismometer = this.getToleranceSeismometer();
        this.m_SeisGraphPanel.setToleranceSeismometer(this.m_ToleranceSeismometer);
        this.m_SeisGraphPanel.setHScale(this.m_HorizontalScale);
        this.m_SeisGraphPanel.setVScale(this.m_VerZoomIndex);
        this.m_SeisGraphImg = this.m_SeisGraphPanel.getImage();
        this.m_SeisGraphPanel.setImage((BufferedImage)this.m_SeisGraphImg);
        this.m_SeisGraphGraphics = (Graphics2D)this.m_SeisGraphPanel.getGraphics();
        this.m_SeisGraphPanel.setActive();
        this.m_SeisGraphPanel.setSeismic();
        this.m_SeisGraphPanel.setSeismometerOffset(this.m_SeismometerOffset);
        this.m_SeisGraphPanel.setSeismometerRange(this.m_SeismometerRange);
        this.m_RaGraphPanel.setPollFrequency(this.m_PollingModeMenu[this.m_PollingModeIndex]);
        this.m_RaGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
        this.m_RaGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
        this.m_RaGraphPanel.setPort(this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
        this.m_RaGraphPanel.setTimeData(1);
        this.m_RaGraphPanel.setYDataSetShown(2);
        this.m_RaGraphPanel.setModeText(this.m_MountCommandSet[2][3]);
        this.m_RaGraphPanel.setToleranceRaDec(this.m_ToleranceRaDec);
        this.m_RaGraphPanel.setUseAsHATolerance(this.m_UseAsHATolerance);
        this.m_RaGraphPanel.setHScale(this.m_HorizontalScale);
        this.m_RaGraphPanel.setVScale(this.m_VerZoomIndex);
        this.m_RaGraphImg = this.m_RaGraphPanel.getImage();
        this.m_RaGraphPanel.setImage((BufferedImage)this.m_RaGraphImg);
        this.m_RaGraphGraphics = (Graphics2D)this.m_RaGraphPanel.getGraphics();
        this.m_RaGraphPanel.setActive();
        this.m_TimeGraphPanel.setPollFrequency(this.m_PollingModeMenu[this.m_PollingModeIndex]);
        this.m_TimeGraphPanel.setRunningRangeLength(this.m_RunningRangeLength);
        this.m_TimeGraphPanel.setAdjustGraphsForRunningRangeLength(this.m_AdjustGraphsForRunningRangeLength);
        this.m_TimeGraphPanel.setPort(this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort);
        this.m_TimeGraphPanel.setTimeData(1);
        this.m_TimeGraphPanel.setYDataSetShown(3);
        this.m_TimeGraphPanel.setModeText(this.m_MountCommandSet[1 - this.m_CommandRotatorFirstVal][3]);
        this.m_ToleranceSeismometer = this.getToleranceSeismometer();
        this.m_TimeGraphPanel.setHScale(this.m_HorizontalScale);
        this.m_TimeGraphPanel.setVScale(this.m_VerZoomIndex);
        this.m_TimeGraphImg = this.m_TimeGraphPanel.getImage();
        this.m_TimeGraphPanel.setImage((BufferedImage)this.m_TimeGraphImg);
        this.m_TimeGraphGraphics = (Graphics2D)this.m_TimeGraphPanel.getGraphics();
        this.m_TimeGraphPanel.setActive();
        this.m_TimeGraphPanel.setDeltaTime();
        this.m_TimeGraphPanel.showNistTimeServer(this.m_UseNistTimeServer & !this.m_NistTimeServerFailed);
    }

    private void updateWindowComponents() {
        this.m_AllowUpdateWindowComponents = false;
        this.calculatePanelSizes();
        if (this.m_HasSeismometer && this.m_ShowSeismometer) {
            this.resultGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight * 4);
            this.resultGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight * 4));
        } else {
            this.resultGraphPanel.setSize(this.m_FrameWidth, this.m_GraphPanelHeight * 3);
            this.resultGraphPanel.setPreferredSize(new Dimension(this.m_FrameWidth, this.m_GraphPanelHeight * 3));
        }
        this.m_MaxYValueIndex = this.m_GraphPanelWidth / this.m_HorizontalScale;
        this.resultGraphPanel.setSize(this.m_GraphPanelWidth, this.m_GraphPanelHeight * 3);
        this.m_RaGraphPanel.setDimension(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
        this.m_RaGraphPanel.setSize(this.m_GraphPanelWidth, this.m_GraphPanelHeight);
        this.m_RaGraphPanel.setPreferredSize(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
        this.m_RaGraphPanel.setLocation(0, 0);
        this.m_RaGraphImg = this.m_RaGraphPanel.getImage();
        this.m_RaGraphPanel.setImage((BufferedImage)this.m_RaGraphImg);
        this.m_DecGraphPanel.setDimension(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
        this.m_DecGraphPanel.setSize(this.m_GraphPanelWidth, this.m_GraphPanelHeight);
        this.m_DecGraphPanel.setPreferredSize(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
        this.m_DecGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 1);
        this.m_DecGraphImg = this.m_DecGraphPanel.getImage();
        this.m_DecGraphPanel.setImage((BufferedImage)this.m_DecGraphImg);
        if (this.m_HasSeismometer && this.m_ShowSeismometer) {
            this.m_SeisGraphPanel.setDimension(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
            this.m_SeisGraphPanel.setSize(this.m_GraphPanelWidth, this.m_GraphPanelHeight);
            this.m_SeisGraphPanel.setPreferredSize(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
            this.m_SeisGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 2);
            this.m_SeisGraphImg = this.m_SeisGraphPanel.getImage();
            this.m_SeisGraphPanel.setImage((BufferedImage)this.m_SeisGraphImg);
            this.m_SeisGraphPanel.setVisible(true);
            this.m_TimeGraphPanel.setDimension(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
            this.m_TimeGraphPanel.setSize(this.m_GraphPanelWidth, this.m_GraphPanelHeight);
            this.m_TimeGraphPanel.setPreferredSize(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
            this.m_TimeGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 3);
            this.m_TimeGraphImg = this.m_TimeGraphPanel.getImage();
            this.m_TimeGraphPanel.setImage((BufferedImage)this.m_TimeGraphImg);
        } else {
            if (this.m_HasSeismometer) {
                this.m_SeisGraphPanel.setVisible(false);
            }
            this.m_TimeGraphPanel.setDimension(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
            this.m_TimeGraphPanel.setSize(this.m_GraphPanelWidth, this.m_GraphPanelHeight);
            this.m_TimeGraphPanel.setPreferredSize(new Dimension(this.m_GraphPanelWidth, this.m_GraphPanelHeight));
            this.m_TimeGraphPanel.setLocation(0, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * 2);
            this.m_TimeGraphImg = this.m_TimeGraphPanel.getImage();
            this.m_TimeGraphPanel.setImage((BufferedImage)this.m_TimeGraphImg);
        }
        this.m_TextOutput.setSize((int)((double)this.m_GraphPanelWidth / 3.0), this.m_TextAreaHeight);
        this.m_TextOutput.setPreferredSize(new Dimension((int)((double)this.m_GraphPanelWidth / 3.0), this.m_TextAreaHeight));
        this.m_TextOutput.setLocation(this.m_FrameInsets.left, (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * this.NUMGRAPHS);
        this.m_TextInput.setSize((int)((double)this.m_GraphPanelWidth / 3.0), this.m_TextAreaHeight);
        this.m_TextInput.setPreferredSize(new Dimension((int)((double)this.m_GraphPanelWidth / 3.0), this.m_TextAreaHeight));
        this.m_TextInput.setLocation((int)((double)this.m_FrameInsets.left + (double)this.m_GraphPanelWidth / 3.0 * 2.0), (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * this.NUMGRAPHS);
        this.m_TextStatus.setSize((int)((double)this.m_GraphPanelWidth / 3.0), this.m_TextAreaHeight);
        this.m_TextStatus.setPreferredSize(new Dimension((int)((double)this.m_GraphPanelWidth / 3.0), this.m_TextAreaHeight));
        this.m_TextStatus.setLocation((int)((double)this.m_FrameInsets.left + (double)this.m_GraphPanelWidth / 3.0), (this.m_GraphPanelHeight + this.m_GraphPanelSpacing) * this.NUMGRAPHS);
        this.m_TextOutput.requestFocus();
    }

    private String defaultTimestamp(int n) {
        String string = "";
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        int n2 = calendar.get(5);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(1);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = calendar.get(14);
        String string2 = "" + n2;
        String string3 = "" + n3;
        String string4 = "" + n4;
        String string5 = "" + n5;
        String string6 = "" + n6;
        String string7 = "" + n7;
        String string8 = "" + n8;
        if (n4 < 10) {
            string4 = "0" + n4;
        }
        if (n3 < 10) {
            string3 = "0" + n3;
        }
        if (n2 < 10) {
            string2 = "0" + n2;
        }
        if (n5 < 10) {
            string5 = "0" + n5;
        }
        if (n6 < 10) {
            string6 = "0" + n6;
        }
        if (n7 < 10) {
            string7 = "0" + n7;
        }
        if (n8 < 100) {
            string8 = "0" + n8;
        }
        if (n8 < 10) {
            string8 = "00" + n8;
        }
        switch (n) {
            case 1: {
                string = string4 + string3 + string2 + "-" + string5 + string6 + string7;
                break;
            }
            case 2: {
                string = string2 + "/" + string3 + "/" + string4 + " " + string5 + ":" + string6 + ":" + string7 + "." + string8;
                break;
            }
            case 3: {
                string = string5 + ":" + string6 + ":" + string7 + "." + string8;
            }
        }
        return string;
    }

    private void setLX200Rotator() {
        if (this.m_CommandRotator < 0) {
            this.m_CommandRotator = 0;
        } else {
            ++this.m_CommandRotator;
            if (this.m_MountStatus != 0 && this.m_LogModeIndex == 1) {
                this.m_CommandRotator = 0;
            }
            if (this.m_CommandRotator >= this.m_MountDataRows) {
                this.m_CommandRotator = 0;
                this.m_NewSequenceStarted = true;
            }
        }
    }

    private void addToLogFile(String string) {
        try {
            if (this.m_FilesAreOpen) {
                this.m_Logs.writeBytes(this.defaultTimestamp(2) + "\t" + string + "\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void showText(JEditorPane jEditorPane, String string) {
        int n;
        String string2 = "";
        String string3 = "";
        if (jEditorPane == this.m_TextOutput) {
            n = 1;
            string3 = "<B>QUERY</B><BR>\r\n";
        } else if (jEditorPane == this.m_TextInput) {
            n = 2;
            string3 = "<B>RESPONSE</B><BR>\r\n";
        } else {
            n = 0;
            string3 = "<B>MESSAGES</B><BR>\r\n";
        }
        this.m_TextBox[n] = this.defaultTimestamp(2) + ": " + string + "<BR>\r\n" + this.m_TextBox[n];
        String[] stringArray = this.m_TextBox[n].split("\r\n");
        for (int i = 0; i < Math.min(stringArray.length, this.m_HistoryModeMenu[this.m_HistoryModeIndex]); ++i) {
            string2 = string2 + stringArray[i] + "\r\n";
        }
        this.m_TextBox[n] = string2;
        jEditorPane.setText(string3 + this.m_TextBox[n]);
    }

    public boolean mountCanHandleCommand(int n) {
        boolean bl = true;
        if (this.m_MountCommandSet[n][8] != "" && this.m_CommandMode == 0) {
            String[] stringArray = this.m_Firmware.split("\\.");
            String[] stringArray2 = this.m_MountCommandSet[n][8].split("\\.");
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i >= stringArray.length) continue;
                int n2 = MountMonitor.isNumeric(stringArray[i]) ? Integer.parseInt(stringArray[i]) : -1;
                int n3 = MountMonitor.isNumeric(stringArray2[i]) ? Integer.parseInt(stringArray2[i]) : -1;
                if (n2 == -1 || n3 == -1) break;
                if (n2 < n3) {
                    bl = false;
                }
                if (n2 > n3) break;
            }
        }
        if (this.m_MountCommandSet[n][1 + this.m_CommandMode] == "") {
            bl = false;
        }
        return bl;
    }

    public String requestMountData(PrintWriter printWriter, InputStreamReader inputStreamReader, int n) {
        int n2 = 0;
        int n3 = 0;
        String string = "";
        Boolean bl = false;
        this.showText(this.m_TextOutput, this.m_MountCommandSet[n][0]);
        if (!this.m_TestModeSimulateMount) {
            if (!this.m_ResetConnection) {
                if (this.m_CommandMode == 0) {
                    try {
                        while (!bl.booleanValue() && n3 < 10) {
                            int n4;
                            StringBuilder stringBuilder = new StringBuilder();
                            n2 = 0;
                            long l = this.getPcTime();
                            printWriter.println("#" + this.m_MountCommandSet[n][1]);
                            switch (this.m_MountCommandSet[n][4]) {
                                case "0": {
                                    break;
                                }
                                case "1": {
                                    while ((n4 = inputStreamReader.read()) != 35 && this.getPcTime() - l < 1000L) {
                                        stringBuilder.append((char)n4);
                                    }
                                    string = stringBuilder.toString();
                                    break;
                                }
                                case "2": {
                                    n4 = inputStreamReader.read();
                                    stringBuilder.append((char)n4);
                                    string = stringBuilder.toString();
                                }
                            }
                            stringBuilder = new StringBuilder();
                            while (inputStreamReader.ready()) {
                                ++n2;
                                n4 = inputStreamReader.read();
                                stringBuilder.append((char)n4);
                            }
                            if (n2 > 0) {
                                n2 = 0;
                                if (++n3 != 10) continue;
                                System.out.println("Communication error: Tried 10 times, still receiving more data than expected!");
                                continue;
                            }
                            bl = true;
                        }
                    }
                    catch (IOException iOException) {
                        string = "";
                    }
                } else if (this.m_CommandMode == 1) {
                    string = "";
                    String string2 = "";
                    if (this.m_MountCommandSet[n][2] != "") {
                        if (this.m_MountCommandSet[n][2].indexOf("~") != -1) {
                            string = "98";
                            String[] stringArray = this.m_MountCommandSet[n][2].split("~");
                            String[] stringArray2 = new String[stringArray.length];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray2[i] = this.requestASCOMData(this.m_TheScopeDispatch, stringArray[i]);
                            }
                            if (stringArray[0].equals("Tracking") && stringArray2[0].equals("true")) {
                                string = "0";
                            }
                            if (stringArray[1].equals("Slewing") && stringArray2[1].equals("true")) {
                                string = "6";
                            }
                            if (string.equals("6")) {
                                this.m_MountIsParked = false;
                            }
                            if (this.m_CheckIfMountIsParked && !this.m_MountIsParked) {
                                string2 = this.requestASCOMData(this.m_TheScopeDispatch, this.m_MountCommandSet[20][2]);
                                this.m_MountIsParked = string2.equals("true");
                                if (this.m_MountIsParked) {
                                    this.m_CheckIfMountIsParked = false;
                                }
                            }
                            if (this.m_MountIsParked) {
                                string = "1";
                            }
                            if (string.equals("0")) {
                                this.m_CheckIfMountIsParked = false;
                            }
                        } else {
                            string = this.requestASCOMData(this.m_TheScopeDispatch, this.m_MountCommandSet[n][2]);
                        }
                    }
                } else {
                    System.out.println("Illegal Command Mode: repair pref file, set Command mode to 0 to 1!");
                    System.exit(0);
                }
            }
        } else {
            DecimalFormat decimalFormat = new DecimalFormat(".00");
            switch (this.m_MountCommandSet[n][1]) {
                case ":GVP#": {
                    string = this.m_MountName;
                    break;
                }
                case ":GVN#": {
                    string = "0.00.00";
                    break;
                }
                case ":GETID#": {
                    string = "00000000000000000000";
                    break;
                }
                case ":GZ#": {
                    string = "135:00:00.00";
                    break;
                }
                case ":GA#": {
                    string = "30:00:00.00";
                    break;
                }
                case ":pS#": {
                    string = "East";
                    break;
                }
                case ":U2#": {
                    string = "";
                    break;
                }
                case ":Gstat#": {
                    string = "0";
                    break;
                }
                case ":GL#": {
                    string = this.defaultTimestamp(3);
                    break;
                }
                case ":GR#": {
                    string = this.m_TestDataEqualsZero ? "00:00:00" : "23:31:" + decimalFormat.format(Math.sin(Math.toRadians(20.0 * (double)this.m_PollingStartTime / 1000.0)) * 0.5 + Math.sin(Math.toRadians(30.0 * (double)this.m_PollingStartTime / 1000.0)) * 0.75 + 20.0).replace(",", ".");
                    string = string.substring(0, string.indexOf(".") + 3);
                    break;
                }
                case ":GD#": {
                    string = this.m_TestDataEqualsZero ? "00:00:00" : "-12:55:" + decimalFormat.format(Math.sin(Math.toRadians(25.0 * (double)this.m_PollingStartTime / 1000.0)) * 0.4 + Math.sin(Math.toRadians(45.0 * (double)this.m_PollingStartTime / 1000.0)) * 1.0 + 40.0).replace(",", ".");
                    string = string.substring(0, string.indexOf(".") + 3);
                    break;
                }
                case ":Gr#": {
                    if (this.m_TestDataEqualsZero) {
                        string = "00:00:00";
                        break;
                    }
                    string = "23:31:21.00";
                    break;
                }
                case ":Gd#": {
                    string = this.m_TestDataEqualsZero ? "00:00:00" : "-12:55:42.00";
                }
            }
        }
        this.showText(this.m_TextInput, string);
        return string;
    }

    public String requestASCOMData(Dispatch dispatch, String string) {
        String string2;
        try {
            Variant variant = Dispatch.call((Dispatch)dispatch, (String)string);
            switch (variant.getvt()) {
                case 7: {
                    variant.changeType((short)5);
                    Double d = variant.getDouble();
                    Date date = DateUtilities.convertWindowsTimeToDate((double)d);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                    string2 = simpleDateFormat.format(date);
                    break;
                }
                default: {
                    string2 = variant.toString();
                    break;
                }
            }
        }
        catch (Exception exception) {
            string2 = "not set";
        }
        return string2;
    }

    public double makeDecimal(String string) {
        Double d = 360.0;
        if (string.indexOf(":") != -1) {
            boolean bl = false;
            try {
                if (string == "" || string == null) {
                    bl = true;
                } else if (string.indexOf(":") != -1) {
                    String[] stringArray = string.split(":");
                    if (stringArray[0].indexOf("-") != -1) {
                        d = Double.parseDouble(stringArray[0]) - Double.parseDouble(stringArray[1]) / 60.0;
                        if (stringArray.length > 2) {
                            d = d - Double.parseDouble(stringArray[2]) / 3600.0;
                        }
                    } else {
                        d = Double.parseDouble(stringArray[0]) + Double.parseDouble(stringArray[1]) / 60.0;
                        if (stringArray.length > 2) {
                            d = d + Double.parseDouble(stringArray[2]) / 3600.0;
                        }
                    }
                } else {
                    d = Double.parseDouble(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                this.m_MountStatus = -4;
                d = this.m_MountValueIndex[this.m_CommandRotator] > 0 ? Double.valueOf(this.m_MountValues[this.m_CommandRotator][this.m_MountValueIndex[this.m_CommandRotator] - 1]) : Double.valueOf(180.0);
            }
        } else if (MountMonitor.isNumeric(string)) {
            d = Double.parseDouble(string);
        }
        return d;
    }

    public String convertToLX200Time(String string) {
        String[] stringArray;
        String string2 = "00:00:00";
        if (string.trim() != "" && (stringArray = string.split(" ")).length >= 3) {
            string2 = stringArray[3];
        }
        if (string2.indexOf(".") == -1) {
            string2 = string2 + ".000";
        }
        return string2;
    }

    public int getCharCount(String string, String string2) {
        int n = string.length() - string.replace(string2, "").length();
        return n;
    }

    public double getStDev(double[][] dArray, int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = 0;
        if (n3 > 2) {
            int n5;
            d5 = dArray[n][n3];
            d6 = 0.0;
            for (n5 = n3; n5 > 0; --n5) {
                d6 = dArray[n][n5];
                if (!(d5 - d6 >= 2.777777777777778E-4 * (double)this.m_RunningRangeLength) || n4 != 0) continue;
                n4 = n5;
            }
            d4 = n3 - n4;
            for (n5 = n3; n5 > n4; --n5) {
                d += dArray[n2][n5];
            }
            double d7 = d / d4;
            for (int i = n3; i > n4; --i) {
                d2 += Math.pow(dArray[n2][i] - d7, 2.0);
            }
            d3 = Math.sqrt(d2 / d4);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public double getRMean(double[][] dArray, int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = -1;
        int n5 = 0;
        if (n3 > 2) {
            int n6;
            d3 = dArray[n][n3];
            d4 = 0.0;
            for (n6 = 0; n6 < n3; ++n6) {
                if (dArray[n2][n6] == 0.0 || n4 != -1) continue;
                n4 = n6;
                break;
            }
            if (n3 > n4 && n4 != -1) {
                for (n6 = n3; n6 > n4; --n6) {
                    d4 = dArray[n][n6];
                    if (!(d3 - d4 >= 2.777777777777778E-4 * (double)this.m_RunningRangeLength) || n5 != 0) continue;
                    n5 = n6;
                    break;
                }
                n5 = Math.max(n5, n4);
                d2 = n3 - n5;
                for (n6 = n3; n6 > n5; --n6) {
                    d += dArray[n2][n6];
                }
                d5 = d2 != 0.0 ? d / d2 : dArray[n2][Math.max(n3, 0)];
            }
        } else {
            d5 = dArray[n2][Math.max(n3, 0)];
        }
        return d5;
    }

    public double getAxisSpeed(double[][] dArray, int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = 0;
        if (n3 > 2) {
            d4 = dArray[n][n3];
            d5 = 0.0;
            for (int i = n3; i > 0; --i) {
                d5 = dArray[n][i];
                if (!((d4 - d5) * 3600.0 >= (double)this.m_RunningRangeLength) || n4 != 0) continue;
                n4 = i;
                d6 = d4 - d5;
            }
            LinearRegression linearRegression = new LinearRegression(dArray, n4, n3, n2);
            d3 = linearRegression.slope();
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public void getDeltaTimeMinMax() {
        this.m_MaxDTIDATAValue = -99999.0;
        this.m_MinDTIDATAValue = 99999.0;
        for (int i = 0; i < this.m_DeltaTimeValueIndex; ++i) {
            for (int j = 2; j < 4; ++j) {
                if (this.m_DeltaTimeValues[j][i] > this.m_MaxDTIDATAValue) {
                    this.m_MaxDTIDATAValue = this.m_DeltaTimeValues[j][i];
                }
                if (!(this.m_DeltaTimeValues[j][i] < this.m_MinDTIDATAValue)) continue;
                this.m_MinDTIDATAValue = this.m_DeltaTimeValues[j][i];
            }
        }
    }

    public long getPcTime() {
        return System.currentTimeMillis() - (long)this.m_PcUTCOffset * 3600L * 1000L;
    }

    public double getUTCOffset(String string) {
        double d = 0.0;
        d = string.indexOf(":") != -1 ? Double.parseDouble(string.substring(0, string.indexOf(":"))) : (string.indexOf(".") != -1 ? Double.parseDouble(string.substring(0, string.indexOf("."))) : 0.0);
        return d;
    }

    public double getStDevOld(double[][] dArray, int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 60 * this.m_PollingModeMenu[this.m_PollingModeIndex];
        for (int i = this.m_MountValueIndex[n] - 1; i > Math.max(0, this.m_MountValueIndex[n] - n2); --i) {
            d += dArray[n][i];
        }
        double d3 = d / (double)(this.m_MountValueIndex[n] - 1 - Math.max(0, this.m_MountValueIndex[n] - n2));
        for (int i = this.m_MountValueIndex[n] - 1; i > Math.max(0, this.m_MountValueIndex[n] - n2); --i) {
            d2 += Math.pow(dArray[n][i] - d3, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)n2);
        return d2;
    }

    public double getMedian(double[][] dArray, int n, int n2) {
        if (n2 > 0) {
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = dArray[n][i];
            }
            Arrays.sort(dArray2);
            return dArray2[n2 / 2];
        }
        return dArray[n][0];
    }

    public double getToleranceRaDec() {
        double d = this.m_ToleranceRaDecModeMenu[this.m_ToleranceRaDecModeIndex].indexOf("'") != -1 ? Double.parseDouble(this.m_ToleranceRaDecModeMenu[this.m_ToleranceRaDecModeIndex].substring(0, this.m_ToleranceRaDecModeMenu[this.m_ToleranceRaDecModeIndex].indexOf("'"))) : 0.0;
        return d;
    }

    public double getToleranceSeismometer() {
        double d = this.m_ToleranceSeismometerModeMenu[this.m_ToleranceSeismometerModeIndex].indexOf("%") != -1 ? Double.parseDouble(this.m_ToleranceSeismometerModeMenu[this.m_ToleranceSeismometerModeIndex].substring(0, this.m_ToleranceSeismometerModeMenu[this.m_ToleranceSeismometerModeIndex].indexOf("%"))) : 0.0;
        return d;
    }

    public void openFiles() {
        File file = new File("." + File.separator + "Logs");
        String string = new String("." + File.separator + "Logs" + File.separator + "MountMonitor_" + this.defaultTimestamp(1));
        if (!file.exists()) {
            if (file.mkdir()) {
                System.out.println("Directory " + file + " is created!");
            } else {
                System.out.println("Failed to create directory " + file + "!");
            }
        }
        this.m_LogsFileName = string + ".log";
        this.m_MountDataFileName = string + ".dat";
        this.m_SeismometerDataFileName = string + ".sei";
        this.m_DeltaTimeDataFileName = string + ".dti";
        try {
            this.m_Logs = new DataOutputStream(new FileOutputStream(this.m_LogsFileName));
            this.m_Logs.writeBytes("MountMonitor logfile " + this.m_Version + "\r\n");
            this.m_Logs.writeBytes("Location:\t" + this.m_Sitename + "\r\n");
            this.m_Logs.writeBytes("Position:\tLatitude = " + this.m_RaGraphPanel.formatHMS(this.m_Latitude) + "\tLongitude = " + this.m_RaGraphPanel.formatHMS(this.m_Longitude) + "\tElevation = " + this.m_Elevation + "m\r\n");
            this.addMountChecksToFile(this.m_Logs);
            this.m_Logs.writeBytes("Mount:\t" + this.m_MountName + "\r\n");
            this.m_Logs.writeBytes("Mount ID:\t" + this.m_MountID + "\r\n");
            if (this.m_CommandMode == 0) {
                this.m_Logs.writeBytes("Mount address:port\t" + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort + "\r\n");
            } else {
                this.m_Logs.writeBytes("Mount ASCOM driver:\t" + this.m_ASCOMScopeId + "\r\n");
            }
            this.m_Logs.writeBytes("Firmware:\t" + this.m_Firmware + "\r\n");
            this.addMountAttitudeToFile(this.m_Logs);
            this.m_MountData = new DataOutputStream(new FileOutputStream(this.m_MountDataFileName));
            this.m_MountData.writeBytes("MountMonitor mount data file " + this.m_Version + "\r\n");
            this.m_MountData.writeBytes("Location:\t" + this.m_Sitename + "\r\n");
            this.addMountChecksToFile(this.m_MountData);
            this.m_MountData.writeBytes("Mount:\t" + this.m_MountName + "\r\n");
            this.m_MountData.writeBytes("Mount ID:\t" + this.m_MountID + "\r\n");
            if (this.m_CommandMode == 0) {
                this.m_MountData.writeBytes("Mount address:port\t" + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort + "\r\n");
            } else {
                this.m_MountData.writeBytes("Mount ASCOM driver:\t" + this.m_ASCOMScopeId + "\r\n");
            }
            this.m_MountData.writeBytes("Firmware:\t" + this.m_Firmware + "\r\n");
            this.addMountAttitudeToFile(this.m_MountData);
            this.m_MountData.writeBytes("RAW Mount time [HH:MM:SS.dd]\tMount time [HH:MM:SS.dd]\tRAW RA [hh:mm:ss.dd]\tRA [hh:mm:ss.dd]\tRA StDev [s.ddd]\tRAW DEC [dd:mm:ss.dd]\tDEC [dd:mm:ss.dd]\tDEC StDev [s.ddd]\tRAW DEC AXIS [dd.dddd]\tDEC AXIS [dd.dddd]\tDEC AXIS StDev [s.ddd]\tRAW RA AXIS [dd.dddd]\tRA AXIS [dd.dddd]\tRA AXIS StDev [s.ddd]\tMin RA Value [hh:mm:ss.dd]\tMax RA Value [hh:mm:ss.dd]\tMax RA StDev [s.ddd]\tMin DEC value [dd:mm:ss.dd]\tMax DEC value [dd:mm:ss.dd]\tMax DEC StDev [s.ddd]\tMin RA AXIS Value [hh:mm:ss.dd]\tMax RA AXIS Value [hh:mm:ss.dd]\tMax RA AXIS StDev [s.ddd]\tMin DEC AXIS Value [hh:mm:ss.dd]\tMax DEC AXIS Value [hh:mm:ss.dd]\tMax DEC AXIS StDev [s.ddd]\tStatus\r\n");
            this.m_SeismometerData = new DataOutputStream(new FileOutputStream(this.m_SeismometerDataFileName));
            this.m_SeismometerData.writeBytes("MountMonitor seismometer data file " + this.m_Version + "\r\n");
            this.m_SeismometerData.writeBytes("Location:\t" + this.m_Sitename + "\r\n");
            if (this.m_SerialPortOpened) {
                this.m_SeismometerData.writeBytes("Seismometer:\t" + this.m_SerialPort.getPortDescription() + "\r\n");
            }
            if (this.m_SerialPortOpened) {
                this.m_SeismometerData.writeBytes("Seismometer port\t" + this.m_SerialPort.getSystemPortName() + "\r\n");
            }
            this.m_SeismometerData.writeBytes("Seismometer offset\t" + this.m_SeismometerOffset + "\r\n");
            this.m_SeismometerData.writeBytes("Mount time [HH:MM:SS.dd]\tRaw data\tOffset data\tStDev\r\n");
            this.m_DeltaTimeData = new DataOutputStream(new FileOutputStream(this.m_DeltaTimeDataFileName));
            this.m_DeltaTimeData.writeBytes("MountMonitor Delta Time data file " + this.m_Version + "\r\n");
            this.m_DeltaTimeData.writeBytes("Location:\t" + this.m_Sitename + "\r\n");
            this.m_DeltaTimeData.writeBytes("Mount time [HH:MM:SS.dd]\tPC - Mount difference [msec]\tPC loop time [msec]\tMount loop time [msec]\tPC - NIST diference [msec]\r\n");
        }
        catch (IOException iOException) {
            System.out.println("Error creating files");
        }
        this.m_FilesAreOpen = true;
    }

    public void closeFiles() {
        this.addToLogFile("Stopped logging.");
        this.addMinMaxToLog();
        try {
            this.m_MountData.writeBytes("Stopped logging\r\n");
            this.m_SeismometerData.writeBytes("Stopped logging\r\n");
            this.m_DeltaTimeData.writeBytes("Stopped logging\r\n");
            this.m_Logs.close();
            this.m_MountData.close();
            this.m_SeismometerData.close();
            this.m_DeltaTimeData.close();
            this.m_FilesAreOpen = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeMountData() {
        if (!this.m_FilesAreOpen) {
            this.openFiles();
        }
        try {
            int n;
            for (n = 1; n < this.m_MountDataRows; ++n) {
                if (n > 2) {
                    this.m_MountData.writeBytes("\t");
                }
                this.m_MountData.writeBytes(this.m_RawMountData[n] + "\t");
                if (n < 4) {
                    this.m_MountData.writeBytes(this.m_RaGraphPanel.formatHMS(this.m_MountValues[n][this.m_MountValueIndex[n]]));
                } else {
                    this.m_MountData.writeBytes(String.format("%.4f", this.m_MountValues[n][this.m_MountValueIndex[n]]).replace(',', '.'));
                }
                if (n > 1) {
                    this.m_MountData.writeBytes("\t" + String.format("%.3f", this.m_MountStdev[n][this.m_MountValueIndex[n]] * 3600.0).replace(',', '.'));
                    continue;
                }
                this.m_MountData.writeBytes("\t");
            }
            for (n = 2; n < this.m_MountDataRows; ++n) {
                if (n < 4) {
                    this.m_MountData.writeBytes("\t" + this.m_RaGraphPanel.formatHMS(this.m_MinMountValues[0][n]));
                    this.m_MountData.writeBytes("\t" + this.m_RaGraphPanel.formatHMS(this.m_MaxMountValues[0][n]));
                } else {
                    this.m_MountData.writeBytes("\t" + String.format("%.4f", this.m_MinMountValues[0][n]).replace(',', '.'));
                    this.m_MountData.writeBytes("\t" + String.format("%.4f", this.m_MaxMountValues[0][n]).replace(',', '.'));
                }
                this.m_MountData.writeBytes("\t" + String.format("%.3f", this.m_MaxStDev[n] * 3600.0).replace(',', '.'));
            }
            if (this.m_MountValueIndex[0] > -1) {
                this.m_MountData.writeBytes("\t" + (int)this.m_MountValues[0][this.m_MountValueIndex[0]]);
            }
            this.m_MountData.writeBytes("\r\n");
            this.m_MountDataWasWritten = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDeltaTimeData() {
        if (!this.m_FilesAreOpen) {
            this.openFiles();
        }
        try {
            for (int i = 0; i < 5; ++i) {
                if (i == 0) {
                    this.m_DeltaTimeData.writeBytes(this.m_RaGraphPanel.formatHMS(this.m_DeltaTimeValues[i][this.m_DeltaTimeValueIndex]) + "\t");
                    continue;
                }
                this.m_DeltaTimeData.writeBytes(this.m_DeltaTimeValues[i][this.m_DeltaTimeValueIndex] + "\t");
            }
            this.m_DeltaTimeData.writeBytes("\r\n");
            this.m_MountDataWasWritten = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void setTheTitle() {
        String string = "MountMonitor " + this.m_Version + " " + this.m_PollingModeMenu[this.m_PollingModeIndex] + "Hz ";
        string = this.m_TestModeSimulateMount ? string + "in test mode" : (this.m_CommandMode == 0 ? string + "on TCP/IP address: " + this.m_MountTCPIPAdress + ":" + this.m_MountTCPIPPort : string + "using ASCOM driver: " + this.m_ASCOMScopeId);
        this.m_Frame.setTitle(string);
    }

    public void saveGraphs(boolean bl) {
        String string = this.defaultTimestamp(1);
        this.saveJPG(this.m_RaGraphImg, "RA_graphs", "RA_graph_" + string, "png", bl);
        this.saveJPG(this.m_DecGraphImg, "DEC_graphs", "DEC_graph_" + string, "png", bl);
        this.saveJPG(this.m_TimeGraphImg, "Time_graphs", "Time_graph_" + string, "png", bl);
        if (this.m_HasSeismometer) {
            this.saveJPG(this.m_SeisGraphImg, "Seismic_graphs", "Seismic_graph_" + string, "png", bl);
        }
        if (this.m_FFTGraphHasBeenMade) {
            this.saveJPG(this.m_FTGraphImg, "FFT_graphs", "FFT_graph_" + string, "png", false);
        }
    }

    public void saveJPG(Image image, String string, String string2, String string3, boolean bl) {
        File file = new File("." + File.separator + string);
        File file2 = new File("." + File.separator + string + File.separator + string2 + "." + string3);
        try {
            if (!file.exists()) {
                if (file.mkdir()) {
                    this.addToLogFile("Directory " + file + " is created!");
                } else {
                    this.addToLogFile("FAILED to create directory " + file + "!");
                }
            }
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, null, null);
            if (bl && !this.m_IsFirstFrame) {
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.8f));
                Color color = new Color(120, 120, 120);
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, Math.max(0, (this.m_MaxYValueIndex - this.m_SaveGraphCounter - 1) * this.m_HorizontalScale), this.m_GraphPanelHeight);
            }
            ImageIO.write((RenderedImage)bufferedImage, string3, file2);
        }
        catch (IOException iOException) {
            this.addToLogFile("PROBLEM making " + file2);
        }
        this.addToLogFile(string + " exported.");
    }

    public String mountStatus(int n) {
        String string = "Unknown status flag.";
        switch (n) {
            case -4: {
                string = "Bad data (-4).";
                break;
            }
            case -3: {
                string = "Bad data (-3).";
                break;
            }
            case -2: {
                string = "Timeout (reset).";
                break;
            }
            case -1: {
                string = "Timeout.";
                break;
            }
            case 0: {
                string = "The mount is tracking.";
                this.m_EndOfSlewWaitingMessageSent = false;
                this.m_MountIsParked = false;
                this.m_EndOfSlewTime = this.getPcTime();
                this.dropData(string);
                break;
            }
            case 1: {
                string = "STOP key pressed.";
                this.dropData(string);
                break;
            }
            case 2: {
                string = "Slewing to the park position.";
                this.m_CommandRotator = 0;
                this.m_NewSequenceStarted = true;
                this.m_DumpGraphs = this.m_DumpGraphsWhenSlewing;
                this.m_ResetMenuBufferChanged = this.m_ResetBuffersAndMinMaxWhenSlewing;
                this.m_ResetMenuMinMaxChanged = this.m_ResetBuffersAndMinMaxWhenSlewing;
                this.m_StartOfSlewWaitingMessageSent = false;
                this.m_ResetMenuNewFileChanged = this.m_CloseFilesWhenSlewing;
                this.dropData(string);
                break;
            }
            case 3: {
                this.m_MountIsParked = false;
                string = "The mount is unparking.";
                break;
            }
            case 4: {
                string = "Slewing to the home position.";
                this.m_CommandRotator = 0;
                this.m_NewSequenceStarted = true;
                this.m_DumpGraphs = this.m_DumpGraphsWhenSlewing;
                this.m_ResetMenuBufferChanged = this.m_ResetBuffersAndMinMaxWhenSlewing;
                this.m_ResetMenuMinMaxChanged = this.m_ResetBuffersAndMinMaxWhenSlewing;
                this.m_StartOfSlewWaitingMessageSent = false;
                this.m_ResetMenuNewFileChanged = this.m_CloseFilesWhenSlewing;
                this.dropData(string);
                break;
            }
            case 5: {
                string = "The mount is parked.";
                this.m_CommandRotator = 0;
                this.m_NewSequenceStarted = true;
                this.m_DumpGraphs = this.m_DumpGraphsWhenParked;
                this.m_ResetMenuNewFileChanged = this.m_CloseFilesWhenParked;
                this.m_MountIsParked = true;
                break;
            }
            case 6: {
                string = "Slewing.";
                this.m_CheckIfMountIsParked = true;
                this.m_MountIsParked = false;
                this.m_CommandRotator = 0;
                this.m_NewSequenceStarted = true;
                this.m_DumpGraphs = this.m_DumpGraphsWhenSlewing;
                this.m_ResetMenuNewFileChanged = this.m_CloseFilesWhenSlewing;
                this.m_ResetMenuBufferChanged = this.m_ResetBuffersAndMinMaxWhenSlewing;
                this.m_ResetMenuMinMaxChanged = this.m_ResetBuffersAndMinMaxWhenSlewing;
                this.m_StartOfSlewWaitingMessageSent = false;
                this.dropData(string);
                break;
            }
            case 7: {
                this.m_NewSequenceStarted = true;
                string = "Tracking is off and the mount is not moving.";
                break;
            }
            case 8: {
                this.m_NewSequenceStarted = true;
                string = "The motors are inhibited because of low temperature.";
                break;
            }
            case 9: {
                this.m_NewSequenceStarted = true;
                string = "Mount is outside tracking limits.";
                break;
            }
            case 10: {
                this.m_NewSequenceStarted = true;
                string = "Mount is following a precalulated satellite trajectory.";
                break;
            }
            case 11: {
                this.m_NewSequenceStarted = true;
                string = "The mount needs an user intervention.";
                break;
            }
            case 98: {
                this.m_NewSequenceStarted = true;
                string = "Unknown status.";
                break;
            }
            case 99: {
                this.m_NewSequenceStarted = true;
                string = "Error.";
            }
        }
        if (this.m_MountStatus < 0) {
            this.m_ResetConnection = true;
        }
        return string;
    }

    private void setPrefs() {
        final boolean bl = this.m_ShowSeismometer;
        final String string = this.m_EMail;
        final String string2 = this.m_NistTimeServer;
        final boolean bl2 = this.m_UseNistTimeServer;
        final int n = this.m_NistTimeServerPollingModeIndex;
        final int n2 = this.m_TimeGraphMaxZoomOffsetModeIndex;
        final int n3 = this.m_SerialPortIndex;
        final int n4 = this.m_SeismometerFrequency;
        final int n5 = this.m_SeismometerOffset;
        final int n6 = this.m_SeismometerRange;
        final int n7 = this.m_PollingModeIndex;
        final int n8 = this.m_LogModeIndex;
        final int n9 = this.m_ToleranceRaDecModeIndex;
        final boolean bl3 = this.m_UseAsHATolerance;
        final int n10 = this.m_ToleranceSeismometerModeIndex;
        final int n11 = this.m_MountTCPIPPort;
        final int n12 = this.m_DumpGraphsModeIndex;
        final int n13 = this.m_ResetBuffersAndMinMaxModeIndex;
        final int n14 = this.m_CloseFilesModeIndex;
        final int n15 = this.m_WindowRatioModeIndex;
        final int n16 = this.m_DelayAfterSlewModeIndex;
        final int n17 = this.m_RunningRangeModeIndex;
        final boolean bl4 = this.m_AdjustGraphsForRunningRangeLength;
        final int n18 = this.m_ReferenceModeIndex;
        final int n19 = this.m_CommandMode;
        final int n20 = this.m_AxisSpeedModeIndex;
        final String string3 = this.m_Sitename.trim();
        final String string4 = this.m_MountTCPIPAdress.trim();
        final JDialog jDialog = new JDialog(this.m_Frame, "Preferences", true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel(new BorderLayout());
        JPanel jPanel10 = new JPanel(new BorderLayout());
        JPanel jPanel11 = new JPanel(new BorderLayout());
        final JTabbedPane jTabbedPane = new JTabbedPane();
        ImageIcon imageIcon = new ImageIcon("icon.png");
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setVgap(5);
        gridLayout.setHgap(5);
        JPanel jPanel12 = new JPanel(gridLayout);
        jPanel12.setBorder(new EmptyBorder(3, 3, 3, 3));
        jPanel5.setBorder(new TitledBorder("Licence"));
        jPanel5.add("North", jPanel12);
        JPanel jPanel13 = new JPanel(new BorderLayout());
        JPanel jPanel14 = new JPanel(gridLayout);
        JPanel jPanel15 = new JPanel(gridLayout);
        jPanel14.setBorder(new EmptyBorder(3, 10, 3, 10));
        jPanel14.add(new JLabel("e-mail address", 2));
        jPanel13.add("West", jPanel14);
        jPanel15.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JTextField jTextField = new JTextField();
        jTextField.setText(this.m_EMail);
        jTextField.setPreferredSize(new Dimension(250, 12));
        jPanel15.add(jTextField);
        jPanel13.add("East", jPanel15);
        jPanel5.add("Center", jPanel13);
        jPanel6.setBorder(new TitledBorder("Mount"));
        jPanel6.add("North", jPanel12);
        JPanel jPanel16 = new JPanel(new BorderLayout());
        JPanel jPanel17 = new JPanel(gridLayout);
        JPanel jPanel18 = new JPanel(gridLayout);
        jPanel17.setBorder(new EmptyBorder(3, 10, 3, 10));
        jPanel17.add(new JLabel("Observatory", 2));
        jPanel17.add(new JLabel("Mount name", 2));
        jPanel17.add(new JLabel("Mount protocol", 2));
        jPanel17.add(new JLabel("ASCOM Chooser", 2));
        jPanel17.add(new JLabel("Mount IP Address", 2));
        jPanel17.add(new JLabel("Mount Port", 2));
        jPanel16.add("West", jPanel17);
        jPanel18.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JTextField jTextField2 = new JTextField();
        jTextField2.setText(this.m_Sitename);
        jPanel18.add(jTextField2);
        final JTextField jTextField3 = new JTextField();
        jTextField3.setText(this.m_MountName);
        jTextField3.setEditable(false);
        jPanel18.add(jTextField3);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < this.m_ProtocolModeMenu.length; ++i) {
            jComboBox.addItem(this.m_ProtocolModeMenu[i]);
        }
        jComboBox.setSelectedIndex(this.m_CommandMode);
        jPanel18.add(jComboBox);
        final JButton jButton = new JButton();
        jButton.setText("Select ASCOM mount");
        jButton.setEnabled(this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("ASCOM"));
        jPanel18.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.m_ASCOMForceChooser = true;
                MountMonitor.this.initASCOMConnection();
                jButton.setEnabled(MountMonitor.this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("ASCOM"));
                jComboBox.setSelectedIndex(MountMonitor.this.m_CommandMode);
                jTextField3.setText(MountMonitor.this.m_MountName);
            }
        });
        final JTextField jTextField4 = new JTextField();
        jTextField4.setText(this.m_MountTCPIPAdress);
        jTextField4.setEnabled(!this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("ASCOM"));
        jPanel18.add(jTextField4);
        final JTextField jTextField5 = new JTextField();
        jTextField5.setText("" + this.m_MountTCPIPPort);
        jTextField5.setEnabled(!this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("ASCOM"));
        jPanel18.add(jTextField5);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField3.setText(MountMonitor.this.m_MountName);
                jTextField4.setEnabled(MountMonitor.this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("LX200"));
                jTextField5.setEnabled(MountMonitor.this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("LX200"));
                jButton.setEnabled(MountMonitor.this.m_ProtocolModeMenu[jComboBox.getSelectedIndex()].equals("ASCOM"));
            }
        });
        jPanel16.add("Center", jPanel18);
        jPanel6.add("Center", jPanel16);
        jPanel10.setBorder(new TitledBorder("Lay-out"));
        jPanel10.add("North", jPanel12);
        JPanel jPanel19 = new JPanel(new BorderLayout());
        JPanel jPanel20 = new JPanel(gridLayout);
        JPanel jPanel21 = new JPanel(gridLayout);
        jPanel20.setBorder(new EmptyBorder(3, 10, 3, 10));
        jPanel20.add(new JLabel("Graph:Textbox ratio", 2));
        jPanel19.add("West", jPanel20);
        jPanel21.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (int i = 0; i < this.m_WindowRatioModeMenu.length; ++i) {
            jComboBox2.addItem(this.m_WindowRatioModeMenu[i]);
        }
        jComboBox2.setSelectedIndex(this.m_WindowRatioModeIndex);
        jPanel21.add(jComboBox2);
        jPanel19.add("Center", jPanel21);
        jPanel10.add("Center", jPanel19);
        jPanel9.setBorder(new TitledBorder("Processing"));
        jPanel9.add("North", jPanel12);
        JPanel jPanel22 = new JPanel(new BorderLayout());
        JPanel jPanel23 = new JPanel(gridLayout);
        JPanel jPanel24 = new JPanel(gridLayout);
        jPanel23.setBorder(new EmptyBorder(3, 10, 3, 10));
        jPanel23.add(new JLabel("Polling frequency", 2));
        jPanel23.add(new JLabel("Running range length", 2));
        jPanel23.add(new JLabel("Correct graphs for running range length", 2));
        jPanel23.add(new JLabel("RA/DEC Reference", 2));
        jPanel23.add(new JLabel("Tolerance (RA/DEC axis)", 2));
        jPanel23.add(new JLabel("Use tolerance as HA [s]", 2));
        jPanel23.add(new JLabel("Axial velocity (RA/DEC axis)", 2));
        jPanel23.add(new JLabel("Log", 2));
        jPanel23.add(new JLabel("Delay after slewing", 2));
        if (this.m_HasSeismometer) {
            jPanel23.add(new JLabel("Tolerance (Seismic data)", 2));
        }
        jPanel23.add(new JLabel("Reset buffers and min/max", 2));
        jPanel23.add(new JLabel("Dump graphs", 2));
        jPanel23.add(new JLabel("Close files", 2));
        jPanel22.add("West", jPanel23);
        jPanel24.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JComboBox<String> jComboBox3 = new JComboBox<String>();
        for (int i = 0; i < this.m_PollingModeMenu.length; ++i) {
            jComboBox3.addItem("" + this.m_PollingModeMenu[i] + "Hz");
        }
        jComboBox3.setSelectedIndex(this.m_PollingModeIndex);
        jPanel24.add(jComboBox3);
        final JComboBox<String> jComboBox4 = new JComboBox<String>();
        for (int i = 0; i < this.m_RunningRangeModeMenu.length; ++i) {
            jComboBox4.addItem(this.m_RunningRangeModeMenu[i] + " seconds");
        }
        jComboBox4.setSelectedIndex(this.m_RunningRangeModeIndex);
        jPanel24.add(jComboBox4);
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(this.m_AdjustGraphsForRunningRangeLength);
        jPanel24.add(jCheckBox);
        final JComboBox<String> jComboBox5 = new JComboBox<String>();
        for (int i = 0; i < this.m_ReferenceModeMenu.length; ++i) {
            jComboBox5.addItem(this.m_ReferenceModeMenu[i]);
        }
        jComboBox5.setSelectedIndex(this.m_ReferenceModeIndex);
        jPanel24.add(jComboBox5);
        final JComboBox<String> jComboBox6 = new JComboBox<String>();
        for (int i = 0; i < this.m_ToleranceRaDecModeMenu.length; ++i) {
            jComboBox6.addItem(this.m_ToleranceRaDecModeMenu[i]);
        }
        jComboBox6.setSelectedIndex(this.m_ToleranceRaDecModeIndex);
        jPanel24.add(jComboBox6);
        final JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(this.m_UseAsHATolerance);
        jPanel24.add(jCheckBox2);
        final JComboBox<String> jComboBox7 = new JComboBox<String>();
        for (int i = 0; i < this.m_AxisSpeedModeMenu.length; ++i) {
            jComboBox7.addItem(this.m_AxisSpeedModeMenu[i]);
        }
        jComboBox7.setSelectedIndex(this.m_AxisSpeedModeIndex);
        jPanel24.add(jComboBox7);
        final JComboBox<String> jComboBox8 = new JComboBox<String>();
        for (int i = 0; i < this.m_LoggingModeMenu.length; ++i) {
            jComboBox8.addItem(this.m_LoggingModeMenu[i]);
        }
        jComboBox8.setSelectedIndex(this.m_LogModeIndex);
        jPanel24.add(jComboBox8);
        final JComboBox<String> jComboBox9 = new JComboBox<String>();
        for (int i = 0; i < this.m_DelayAfterSlewModeMenu.length; ++i) {
            jComboBox9.addItem("" + this.m_DelayAfterSlewModeMenu[i] + " seconds");
        }
        jComboBox9.setSelectedIndex(this.m_DelayAfterSlewModeIndex);
        jPanel24.add(jComboBox9);
        final JComboBox<String> jComboBox10 = new JComboBox<String>();
        if (this.m_HasSeismometer) {
            for (int i = 0; i < this.m_ToleranceSeismometerModeMenu.length; ++i) {
                jComboBox10.addItem(this.m_ToleranceSeismometerModeMenu[i]);
            }
            jComboBox10.setSelectedIndex(this.m_ToleranceSeismometerModeIndex);
            jPanel24.add(jComboBox10);
        }
        final JComboBox<String> jComboBox11 = new JComboBox<String>();
        for (int i = 0; i < this.m_ResetBuffersAndMinMaxModeMenu.length; ++i) {
            jComboBox11.addItem(this.m_ResetBuffersAndMinMaxModeMenu[i]);
        }
        jComboBox11.setSelectedIndex(this.m_ResetBuffersAndMinMaxModeIndex);
        jPanel24.add(jComboBox11);
        final JComboBox<String> jComboBox12 = new JComboBox<String>();
        for (int i = 0; i < this.m_DumpGraphsModeMenu.length; ++i) {
            jComboBox12.addItem(this.m_DumpGraphsModeMenu[i]);
        }
        jComboBox12.setSelectedIndex(this.m_DumpGraphsModeIndex);
        jPanel24.add(jComboBox12);
        final JComboBox<String> jComboBox13 = new JComboBox<String>();
        for (int i = 0; i < this.m_CloseFilesModeMenu.length; ++i) {
            jComboBox13.addItem(this.m_CloseFilesModeMenu[i]);
        }
        jComboBox13.setSelectedIndex(this.m_CloseFilesModeIndex);
        jPanel24.add(jComboBox13);
        jPanel22.add("Center", jPanel24);
        jPanel9.add("Center", jPanel22);
        jPanel8.setBorder(new TitledBorder("NIST Time Server"));
        jPanel8.add("North", jPanel12);
        JPanel jPanel25 = new JPanel(new BorderLayout());
        JPanel jPanel26 = new JPanel(gridLayout);
        JPanel jPanel27 = new JPanel(gridLayout);
        jPanel26.setBorder(new EmptyBorder(3, 10, 3, 10));
        jPanel26.add(new JLabel("Use server", 2));
        jPanel26.add(new JLabel("Server address", 2));
        jPanel26.add(new JLabel("Polling interval", 2));
        jPanel26.add(new JLabel("Max zoom offset", 2));
        jPanel25.add("West", jPanel26);
        jPanel27.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JCheckBox jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(this.m_UseNistTimeServer);
        jPanel27.add(jCheckBox3);
        final JTextField jTextField6 = new JTextField();
        jTextField6.setText(this.m_NistTimeServer);
        jTextField6.setPreferredSize(new Dimension(250, 12));
        jPanel27.add(jTextField6);
        final JComboBox<String> jComboBox14 = new JComboBox<String>();
        for (int i = 0; i < this.m_NistTimeServerPollingIntervalModeMenu.length; ++i) {
            if (i > 0) {
                jComboBox14.addItem(this.m_NistTimeServerPollingIntervalModeMenu[i] + " seconds");
                continue;
            }
            jComboBox14.addItem("No polling");
        }
        jComboBox14.setSelectedIndex(this.m_NistTimeServerPollingModeIndex);
        jPanel27.add(jComboBox14);
        final JComboBox<String> jComboBox15 = new JComboBox<String>();
        for (int i = 0; i < this.m_TimeGraphMaxZoomOffsetModeMenu.length; ++i) {
            if (i > 0) {
                jComboBox15.addItem(this.m_TimeGraphMaxZoomOffsetModeMenu[i] + " msecs");
                continue;
            }
            jComboBox15.addItem("No limit");
        }
        jComboBox15.setSelectedIndex(this.m_TimeGraphMaxZoomOffsetModeIndex);
        jPanel27.add(jComboBox15);
        jPanel25.add("East", jPanel27);
        jPanel8.add("Center", jPanel25);
        jPanel7.setBorder(new TitledBorder("Seismometer"));
        jPanel7.add("North", jPanel12);
        JPanel jPanel28 = new JPanel(new BorderLayout());
        JPanel jPanel29 = new JPanel(gridLayout);
        JPanel jPanel30 = new JPanel(gridLayout);
        jPanel29.setBorder(new EmptyBorder(3, 10, 3, 10));
        jPanel29.add(new JLabel("Show seismic data", 2));
        jPanel29.add(new JLabel("Serial port", 2));
        jPanel29.add(new JLabel("Sampling frequency", 2));
        jPanel29.add(new JLabel("Offset", 2));
        jPanel29.add(new JLabel("Range (default = 2000)", 2));
        jPanel28.add("West", jPanel29);
        jPanel30.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JCheckBox jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(this.m_ShowSeismometer);
        jPanel30.add(jCheckBox4);
        final JComboBox<String> jComboBox16 = new JComboBox<String>();
        int n21 = 0;
        this.m_AvailableSerialPorts = SerialPort.getCommPorts();
        for (int i = 0; i < this.m_AvailableSerialPorts.length; ++i) {
            if (this.m_InitPortVerbose) {
                System.out.println("   [" + i + "] " + this.m_AvailableSerialPorts[i].getSystemPortName() + ": " + this.m_AvailableSerialPorts[i].getDescriptivePortName() + " - " + this.m_AvailableSerialPorts[i].getPortDescription());
            }
            jComboBox16.addItem(this.m_AvailableSerialPorts[i].getSystemPortName() + ": " + this.m_AvailableSerialPorts[i].getPortDescription());
            if (i != this.m_SerialPortIndex) continue;
            n21 = i;
        }
        final JTextField jTextField7 = new JTextField();
        final JTextField jTextField8 = new JTextField();
        final JTextField jTextField9 = new JTextField();
        if (this.m_HasSeismometer) {
            if (jComboBox16.getModel().getSize() > 0) {
                jComboBox16.setSelectedIndex(n21);
            }
            jPanel30.add(jComboBox16);
            jTextField7.setText("" + this.m_SeismometerFrequency);
            jPanel30.add(jTextField7);
            jTextField8.setText("" + this.m_SeismometerOffset);
            jPanel30.add(jTextField8);
            jTextField9.setText("" + this.m_SeismometerRange);
            jPanel30.add(jTextField9);
        }
        if (this.m_HasSeismometer) {
            jPanel28.add("Center", jPanel30);
            jPanel7.add("Center", jPanel28);
        }
        jPanel11.setBorder(new TitledBorder("Mount settings"));
        jPanel11.add("North", jPanel12);
        JPanel jPanel31 = new JPanel(new BorderLayout());
        JPanel jPanel32 = new JPanel(gridLayout);
        JPanel jPanel33 = new JPanel(gridLayout);
        JPanel jPanel34 = new JPanel(gridLayout);
        jPanel32.setBorder(new EmptyBorder(3, 10, 3, 10));
        for (int i = 0; i < this.m_MountCommandSet.length; ++i) {
            if (!this.m_MountCommandSet[i][6].equals("2")) continue;
            jPanel32.add(new JLabel(this.m_MountCommandSet[i][0].replace("Check", "Check if") + " is:", 2));
        }
        jPanel31.add("West", jPanel32);
        jPanel33.setBorder(new EmptyBorder(3, 3, 3, 3));
        final ArrayList arrayList = new ArrayList();
        int n22 = 0;
        for (int i = 0; i < this.m_MountCommandSet.length; ++i) {
            if (!this.m_MountCommandSet[i][6].equals("2")) continue;
            arrayList.add(n22, new JComboBox());
            String[] stringArray = this.m_MountCommandSet[i][9].split("~");
            for (String string5 : stringArray) {
                ((JComboBox)arrayList.get(n22)).addItem(string5);
            }
            jPanel33.add((Component)arrayList.get(n22));
            ((JComboBox)arrayList.get(n22)).setEnabled(this.mountCanHandleCommand(i));
            if (this.m_CheckMountSettingsIndexesList.size() > 0) {
                ((JComboBox)arrayList.get(n22)).setSelectedIndex(this.m_CheckMountSettingsIndexesList.get(n22)[1]);
            }
            ++n22;
        }
        jPanel31.add("Center", jPanel33);
        n22 = 0;
        jPanel34.setBorder(new EmptyBorder(3, 3, 3, 3));
        final JCheckBox[] jCheckBoxArray = new JCheckBox[this.m_MountCommandSet.length];
        for (int i = 0; i < this.m_MountCommandSet.length; ++i) {
            if (!this.m_MountCommandSet[i][6].equals("2")) continue;
            jCheckBoxArray[n22] = new JCheckBox();
            if (this.m_CheckMountSettingsIndexesList.size() > 0) {
                jCheckBoxArray[n22].setSelected(this.m_CheckMountSettingsIndexesList.get(n22)[2] == 1);
            }
            jPanel34.add(jCheckBoxArray[n22]);
            jCheckBoxArray[n22].setEnabled(this.mountCanHandleCommand(i));
            ++n22;
        }
        jPanel31.add("East", jPanel34);
        jPanel11.add("Center", jPanel31);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel10, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jPanel9, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)jPanel8, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        if (this.m_HasSeismometer) {
            jPanel3.add((Component)jPanel7, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel4.add((Component)jPanel11, gridBagConstraints);
        jTabbedPane.addTab("General", imageIcon, jPanel, "E-mail address, mount, and lay-out");
        jTabbedPane.setMnemonicAt(0, 49);
        jTabbedPane.addTab("Processing", imageIcon, jPanel2, "Processing options");
        jTabbedPane.setMnemonicAt(1, 50);
        jTabbedPane.addTab("Auxiliary", imageIcon, jPanel3, "Auxiliary devices");
        jTabbedPane.setMnemonicAt(2, 51);
        jTabbedPane.addTab("Miscellaneous", imageIcon, jPanel4, "Miscellaneous settings");
        jTabbedPane.setMnemonicAt(2, 52);
        jDialog.getContentPane().add("North", Box.createRigidArea(new Dimension(450, 10)));
        jDialog.getContentPane().add("Center", jTabbedPane);
        jTabbedPane.setSelectedIndex(this.m_LastSelectedPrefsTab);
        JPanel jPanel35 = new JPanel();
        JButton jButton2 = new JButton("Accept");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.m_WaitForPrefsAccept = true;
                if (MountMonitor.this.m_WaitForMainSequence) {
                    MountMonitor.this.showText(MountMonitor.this.m_TextStatus, "Waiting for start of sequence before applying new settings.");
                }
                while (MountMonitor.this.m_WaitForMainSequence) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                MountMonitor.this.m_LastSelectedPrefsTab = jTabbedPane.getSelectedIndex();
                if (jTextField.getText() != string) {
                    MountMonitor.this.m_EMail = jTextField.getText().trim();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jTextField2.getText() != string3) {
                    MountMonitor.this.m_Sitename = jTextField2.getText().trim();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox.getSelectedIndex() != n19) {
                    MountMonitor.this.m_CommandMode = jComboBox.getSelectedIndex();
                    if (!MountMonitor.this.m_TestModeSimulateMount) {
                        MountMonitor.this.m_ResetConnection = true;
                        MountMonitor.this.m_ServerIsActive = false;
                    }
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jTextField4.getText().trim().indexOf(string4) == -1) {
                    MountMonitor.this.m_MountTCPIPAdress = jTextField4.getText().trim();
                    if (!MountMonitor.this.m_TestModeSimulateMount) {
                        MountMonitor.this.m_ResetConnection = true;
                    }
                    MountMonitor.this.setTheTitle();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (Integer.parseInt(jTextField5.getText().trim()) != n11) {
                    MountMonitor.this.m_MountTCPIPPort = Integer.parseInt(jTextField5.getText().trim());
                    if (!MountMonitor.this.m_TestModeSimulateMount) {
                        MountMonitor.this.m_ResetConnection = true;
                    }
                    MountMonitor.this.setTheTitle();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox2.getSelectedIndex() != n15) {
                    MountMonitor.this.m_WindowRatioModeIndex = jComboBox2.getSelectedIndex();
                    MountMonitor.this.GRAPHRATIO = MountMonitor.this.m_WindowRatioModeIndex + 1;
                    MountMonitor.this.TEXTBOXRATIO = 1.0;
                    MountMonitor.this.TOTALRATIO = 2.0 * MountMonitor.this.GRAPHRATIO + MountMonitor.this.TEXTBOXRATIO;
                    MountMonitor.this.updateWindowComponents();
                }
                if (jComboBox3.getSelectedIndex() != n7) {
                    MountMonitor.this.m_NewPollModeIndex = jComboBox3.getSelectedIndex();
                    MountMonitor.this.m_PollingModeMenuChanged = true;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox4.getSelectedIndex() != n17) {
                    MountMonitor.this.m_RunningRangeModeIndex = jComboBox4.getSelectedIndex();
                    MountMonitor.this.m_RunningRangeLength = MountMonitor.this.m_RunningRangeModeMenu[MountMonitor.this.m_RunningRangeModeIndex];
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jCheckBox.isSelected() != bl4) {
                    MountMonitor.this.m_AdjustGraphsForRunningRangeLength = jCheckBox.isSelected();
                    MountMonitor.this.m_RaGraphPanel.setAdjustGraphsForRunningRangeLength(MountMonitor.this.m_AdjustGraphsForRunningRangeLength);
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox5.getSelectedIndex() != n18) {
                    MountMonitor.this.m_ReferenceModeIndex = jComboBox5.getSelectedIndex();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox6.getSelectedIndex() != n9) {
                    MountMonitor.this.m_ToleranceRaDecModeIndex = jComboBox6.getSelectedIndex();
                    MountMonitor.this.m_ToleranceRaDecModeMenuChanged = true;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jCheckBox2.isSelected() != bl3) {
                    MountMonitor.this.m_UseAsHATolerance = jCheckBox2.isSelected();
                    MountMonitor.this.m_RaGraphPanel.setUseAsHATolerance(MountMonitor.this.m_UseAsHATolerance);
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox7.getSelectedIndex() != n20) {
                    MountMonitor.this.m_AxisSpeedModeIndex = jComboBox7.getSelectedIndex();
                    MountMonitor.this.m_RequestAxialSpeed = MountMonitor.this.m_AxisSpeedModeIndex > 0;
                    MountMonitor.this.m_ShowAxialSpeed = MountMonitor.this.m_AxisSpeedModeIndex > 1;
                    MountMonitor.this.m_ShowAxialSpeedAsDisplacement = MountMonitor.this.m_AxisSpeedModeIndex == 3;
                    MountMonitor.this.EnableAxialSpeed();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox8.getSelectedIndex() != n8) {
                    MountMonitor.this.m_LogModeIndex = jComboBox8.getSelectedIndex();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox9.getSelectedIndex() != n16) {
                    MountMonitor.this.m_DelayAfterSlewModeIndex = jComboBox9.getSelectedIndex();
                    MountMonitor.this.m_DelayAfterSlewing = MountMonitor.this.m_DelayAfterSlewModeMenu[MountMonitor.this.m_DelayAfterSlewModeIndex];
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox10.getSelectedIndex() != n10 && MountMonitor.this.m_HasSeismometer) {
                    MountMonitor.this.m_ToleranceSeismometerModeIndex = jComboBox10.getSelectedIndex();
                    MountMonitor.this.m_ToleranceSeismometerModeMenuChanged = true;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox11.getSelectedIndex() != n13) {
                    MountMonitor.this.m_ResetBuffersAndMinMaxModeIndex = jComboBox11.getSelectedIndex();
                    MountMonitor.this.m_ResetBuffersAndMinMaxWhenSlewing = MountMonitor.this.m_ResetBuffersAndMinMaxModeIndex == 1;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox12.getSelectedIndex() != n12) {
                    MountMonitor.this.m_DumpGraphsModeIndex = jComboBox12.getSelectedIndex();
                    MountMonitor.this.m_DumpGraphsWhenSlewing = MountMonitor.this.m_DumpGraphsModeIndex == 1;
                    MountMonitor.this.m_DumpGraphsWhenParked = MountMonitor.this.m_DumpGraphsModeIndex == 2;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox13.getSelectedIndex() != n14) {
                    MountMonitor.this.m_CloseFilesModeIndex = jComboBox13.getSelectedIndex();
                    MountMonitor.this.m_CloseFilesWhenSlewing = MountMonitor.this.m_CloseFilesModeIndex == 1;
                    MountMonitor.this.m_CloseFilesWhenParked = MountMonitor.this.m_CloseFilesModeIndex == 2;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jCheckBox3.isSelected() != bl2) {
                    MountMonitor.this.m_UseNistTimeServer = jCheckBox3.isSelected();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jTextField6.getText() != string2) {
                    MountMonitor.this.m_NistTimeServer = jTextField6.getText().trim();
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox14.getSelectedIndex() != n) {
                    MountMonitor.this.m_NistTimeServerPollingModeIndex = jComboBox14.getSelectedIndex();
                    MountMonitor.this.m_NistTimeServerPollingInterval = MountMonitor.this.m_NistTimeServerPollingIntervalModeMenu[MountMonitor.this.m_NistTimeServerPollingModeIndex];
                    MountMonitor.this.m_UseNistTimeServer = MountMonitor.this.m_NistTimeServerPollingModeIndex > 0;
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (jComboBox15.getSelectedIndex() != n2) {
                    MountMonitor.this.m_TimeGraphMaxZoomOffsetModeIndex = jComboBox15.getSelectedIndex();
                    MountMonitor.this.m_TimeGraphMaxZoomOffset = MountMonitor.this.m_TimeGraphMaxZoomOffsetModeMenu[MountMonitor.this.m_TimeGraphMaxZoomOffsetModeIndex];
                    MountMonitor.this.m_SavePrefs = true;
                }
                if (MountMonitor.this.m_HasSeismometer) {
                    int n21;
                    if (jCheckBox4.isSelected() != bl) {
                        MountMonitor.this.m_ShowSeismometer = jCheckBox4.isSelected();
                        MountMonitor.this.NUMGRAPHS = MountMonitor.this.m_ShowSeismometer ? 4 : 3;
                        MountMonitor.this.initResultGraphPanel();
                        MountMonitor.this.updateWindowComponents();
                        MountMonitor.this.m_SavePrefs = true;
                    }
                    if ((n21 = jComboBox16.getSelectedIndex()) != n3) {
                        MountMonitor.this.m_SerialPortIndex = n21;
                        if (!MountMonitor.this.m_TestModeSimulateSeismometer) {
                            MountMonitor.this.m_SerialPortHasChanged = true;
                        }
                        MountMonitor.this.m_SavePrefs = true;
                    }
                    if (jTextField7.getText() != "" + n4) {
                        MountMonitor.this.m_SeismometerFrequency = Integer.parseInt(jTextField7.getText().trim());
                        MountMonitor.this.m_ActualSeismometerFrequency = MountMonitor.this.m_SeismometerFrequency;
                        MountMonitor.this.m_SavePrefs = true;
                    }
                    if (jTextField8.getText() != "" + n5) {
                        MountMonitor.this.m_SeismometerOffset = Integer.parseInt(jTextField8.getText().trim());
                        MountMonitor.this.m_SavePrefs = true;
                    }
                    if (jTextField9.getText() != "" + n6) {
                        MountMonitor.this.m_SeismometerRange = Integer.parseInt(jTextField9.getText().trim());
                        MountMonitor.this.m_SavePrefs = true;
                    }
                }
                MountMonitor.this.m_CheckMountSettingsIndexesList.clear();
                int n22 = 0;
                int n23 = 0;
                for (int i = 0; i < MountMonitor.this.m_MountCommandSet.length; ++i) {
                    if (!MountMonitor.this.m_MountCommandSet[i][6].equals("2")) continue;
                    n23 = ((JComboBox)arrayList.get(n22)).getSelectedIndex();
                    String[] stringArray = MountMonitor.this.m_MountCommandSet[i][9].split("~");
                    int[] nArray = new int[]{0, 0, 0};
                    nArray[0] = i;
                    nArray[1] = n23;
                    nArray[2] = jCheckBoxArray[n22].isSelected() ? 1 : 0;
                    MountMonitor.this.m_CheckMountSettingsIndexesList.add(nArray);
                    ++n22;
                }
                MountMonitor.this.m_CheckMountSettings = true;
                MountMonitor.this.m_WaitForPrefsAccept = false;
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        JButton jButton3 = new JButton("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        jPanel35.add(jButton2);
        jPanel35.add(jButton3);
        jDialog.getContentPane().add("South", jPanel35);
        jDialog.pack();
        jDialog.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(jDialog.getWidth() / 2)), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)(jDialog.getHeight() / 2)));
        jDialog.setVisible(true);
    }

    protected JComponent makeTextPanel(String string) {
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        return jPanel;
    }

    private void aboutBox() {
        final JDialog jDialog = new JDialog(this.m_Frame, "About: MountMonitor " + this.m_Version, true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jDialog.getContentPane().add("North", jPanel);
        ImageIcon imageIcon = new ImageIcon("about.png");
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        JLabel jLabel2 = new JLabel("", 0);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jLabel2.setText("Nicol\u00e0s de Hilster");
        jPanel2.add(jLabel2);
        JLabel jLabel3 = new JLabel("", 0);
        jLabel3.setText("http://www.dehilster.info");
        jPanel2.add(jLabel3);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jPanel.add(jPanel2);
        JLabel jLabel4 = new JLabel("", 0);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jLabel4.setText("MountMonitor " + this.m_Version);
        jLabel4.setFont(jLabel4.getFont().deriveFont(jLabel4.getFont().getStyle() | 1, jLabel4.getFont().getSize() + 4));
        jPanel2.add(jLabel4);
        JLabel jLabel5 = new JLabel("", 0);
        jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jLabel5.setText("<HTML><CENTER>Analysis tool for LX200 protocol<BR>supported equatorial mounts.<BR><BR></CENTER></HTML>");
        jPanel2.add(jLabel5);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jDialog.getContentPane().add("South", jPanel3);
        jDialog.pack();
        jDialog.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(jDialog.getWidth() / 2)), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)(jDialog.getHeight() / 2)));
        jDialog.setVisible(true);
    }

    private void alertBox(String string, String string2) {
        final JDialog jDialog = new JDialog(this.m_Frame, "Alert: " + string, true);
        jDialog.setModalityType(Dialog.ModalityType.MODELESS);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout());
        jDialog.getContentPane().add("North", jPanel);
        JLabel jLabel = new JLabel("", 0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jLabel.setText("<HTML>" + string2 + "</HTML>");
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        jPanel2.add(jButton);
        jDialog.getContentPane().add("South", jPanel2);
        jDialog.pack();
        jDialog.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 - (double)(jDialog.getWidth() / 2)), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 - (double)(jDialog.getHeight() / 2)));
        jDialog.setVisible(true);
    }

    public void fftBox() {
        final JDialog jDialog = new JDialog(this.m_Frame, this.getFFTText()[0], true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        final JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.setSize(this.m_FFTBoxWidth, this.m_FFTBoxHeight);
        jPanel.setPreferredSize(new Dimension(this.m_FFTBoxWidth, this.m_FFTBoxHeight));
        this.FFTGraphPanel = new FTPanel(this.m_FFTBoxWidth, this.m_FFTBoxHeight, Color.yellow);
        this.FFTGraphPanel.setSize(this.m_FFTBoxWidth, this.m_FFTBoxHeight);
        this.FFTGraphPanel.setPreferredSize(new Dimension(this.m_FFTBoxWidth, this.m_FFTBoxHeight));
        this.FFTGraphPanel.setDimension(new Dimension(this.m_FFTBoxWidth, this.m_FFTBoxHeight));
        this.FFTGraphPanel.setLocation(0, 0);
        this.FFTGraphPanel.setType(this.m_FFTModeIsFrequency);
        jPanel.add(this.FFTGraphPanel);
        this.FFTGraphPanel.setSeismometerFrequency(this.m_ActualSeismometerFrequency);
        this.FFTGraphPanel.setMountFrequency(this.m_ActualMountFrequency);
        this.FFTGraphPanel.setModeText("FFT");
        this.m_FTGraphImg = this.FFTGraphPanel.getImage();
        this.FFTGraphPanel.setImage((BufferedImage)this.m_FTGraphImg);
        this.FTGraphGraphics = (Graphics2D)this.FFTGraphPanel.getGraphics();
        this.FFTGraphPanel.setActive();
        this.FFTGraphPanel.setVisible(true);
        jDialog.getContentPane().add("North", jPanel);
        final JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                MountMonitor.this.FFTGraphPanel.setInActive();
                jDialog.dispose();
            }
        });
        final JButton jButton2 = new JButton(this.getFFTText()[1]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.m_FFTModeIsFrequency = !MountMonitor.this.m_FFTModeIsFrequency;
                MountMonitor.this.FFTGraphPanel.adjustHScale(0.0);
                MountMonitor.this.FFTGraphPanel.setType(MountMonitor.this.m_FFTModeIsFrequency);
                jDialog.setTitle(MountMonitor.this.getFFTText()[0]);
                jButton2.setText(MountMonitor.this.getFFTText()[1]);
            }
        });
        JButton jButton3 = new JButton("<");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.FFTGraphPanel.shiftHScale(-1.0);
            }
        });
        JButton jButton4 = new JButton(">");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.FFTGraphPanel.shiftHScale(1.0);
            }
        });
        JButton jButton5 = new JButton("+");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.FFTGraphPanel.adjustHScale(1.0);
            }
        });
        JButton jButton6 = new JButton("-");
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MountMonitor.this.FFTGraphPanel.adjustHScale(-1.0);
            }
        });
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
        jPanel2.add(jButton3);
        jPanel2.add(jButton5);
        jPanel2.add(jButton6);
        jPanel2.add(jButton4);
        jDialog.getContentPane().add("South", jPanel2);
        jDialog.pack();
        jDialog.setLocation(this.m_FFTBoxX, this.m_FFTBoxY);
        jDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                MountMonitor.this.m_FFTBoxX = (int)jDialog.getLocation().getX();
                MountMonitor.this.m_FFTBoxY = (int)jDialog.getLocation().getY();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Insets insets = jDialog.getInsets();
                Dimension dimension = jDialog.getSize();
                MountMonitor.this.m_FFTBoxX = (int)jDialog.getLocation().getX();
                MountMonitor.this.m_FFTBoxY = (int)jDialog.getLocation().getY();
                int n = dimension.width - insets.left - insets.right;
                int n2 = dimension.height - insets.top - insets.bottom - jPanel2.getSize().height;
                MountMonitor.this.m_FFTBoxWidth = n;
                MountMonitor.this.m_FFTBoxHeight = n2;
                jPanel.setSize(n, n2);
                jPanel.setPreferredSize(new Dimension(n, n2));
                MountMonitor.this.FFTGraphPanel.setDimension(new Dimension(n, n2));
                MountMonitor.this.FFTGraphPanel.setSize(n, n2);
                MountMonitor.this.FFTGraphPanel.setPreferredSize(new Dimension(n, n2));
                MountMonitor.this.m_FTGraphImg = MountMonitor.this.FFTGraphPanel.getImage();
                MountMonitor.this.FFTGraphPanel.setImage((BufferedImage)MountMonitor.this.m_FTGraphImg);
            }
        });
        jDialog.setVisible(true);
        this.m_FFTGraphHasBeenMade = true;
    }

    public String[] getFFTText() {
        String[] stringArray = new String[2];
        if (this.m_FFTModeIsFrequency) {
            stringArray[0] = "FFT Wave Frequency Spectrum [Hz]";
            stringArray[1] = "Period";
        } else {
            stringArray[0] = "FFT Wave Period Spectrum [s]";
            stringArray[1] = "Frequency";
        }
        return stringArray;
    }

    public void dropData(String string) {
        int n;
        int n2 = 999999;
        this.m_CommandRotator = 0;
        this.m_NewSequenceStarted = true;
        for (n = 1; n < this.m_MountValueIndex.length; ++n) {
            if (this.m_MountValueIndex[n] >= n2) continue;
            n2 = this.m_MountValueIndex[n];
        }
        for (n = 0; n < this.m_MountValueIndex.length; ++n) {
            this.m_MountValueIndex[n] = n2 - 1;
            if (this.m_MountValueIndex[n] >= -1) continue;
            this.m_MountValueIndex[n] = -1;
        }
        for (n = 0; n < this.m_MaxMountValues[0].length; ++n) {
            this.m_MaxMountValues[0][n] = this.m_MaxMountValues[3][n];
            this.m_MinMountValues[0][n] = this.m_MinMountValues[3][n];
        }
        this.m_DropLastData = false;
    }

    public void openHelp() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        openChm openChm2 = new openChm();
        openChm2.openChmMethod("MountMonitor_" + this.m_VersionNo + "-Help.CHM");
    }

    public boolean indexesAreValid() {
        Boolean bl = true;
        for (int i = 1; i < this.m_MountValueIndex.length; ++i) {
            if (this.m_MountValueIndex[i] >= 0) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public String requestSeismometerData() {
        String string = "";
        if (this.m_SerialPort != null) {
            try {
                if (this.m_SerialPort.bytesAvailable() > 0) {
                    byte[] byArray = new byte[this.m_SerialPort.bytesAvailable()];
                    int n = this.m_SerialPort.readBytes(byArray, (long)byArray.length);
                    string = new String(byArray);
                    this.m_SerialPortReturnedData = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                string = "0";
                this.m_SerialPortReturnedData = false;
            }
        }
        return string;
    }

    public void addToSeismicArray(String string, long l) {
        String[] stringArray = string.split("\r\n");
        if (l > 0L && stringArray.length > 0) {
            this.m_ActualSeismometerFrequency = (this.m_ActualSeismometerFrequency * 99.0 + (double)stringArray.length / ((double)l / 1000.0)) / 100.0;
        }
        if (this.m_MountValueIndex[1 - this.m_CommandRotatorFirstVal] > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (("" + stringArray[i]).trim() == "") continue;
                ++this.m_SeismometerValueIndex;
                double d = this.m_MountValues[1 - this.m_CommandRotatorFirstVal][this.m_MountValueIndex[1 - this.m_CommandRotatorFirstVal] - 1] + (double)((long)i * l / (long)stringArray.length) / 1000.0 / 3600.0;
                double d2 = 0.0;
                if (this.m_TestModeSimulateSeismometer) {
                    d2 = this.m_TestDataEqualsZero ? 0.0 : Math.sin(Math.toRadians(55.0 * (double)this.m_PollingStartTime / 1000.0)) * 300.0 + Math.sin(Math.toRadians(60.0 * (double)this.m_PollingStartTime / 1000.0)) * 100.0 + Math.sin(Math.toRadians(75.0 * (double)this.m_PollingStartTime / 1000.0)) * 200.0 - (double)this.m_SeismometerOffset;
                } else {
                    try {
                        d2 = Double.parseDouble(stringArray[i] + ".0");
                    }
                    catch (NumberFormatException numberFormatException) {
                        d2 = 0.0;
                    }
                }
                this.m_SeismometerValues[0][this.m_SeismometerValueIndex] = d;
                this.m_SeismometerValues[1][this.m_SeismometerValueIndex] = d2;
                if (this.m_ToleranceSeismometer > 0.0) {
                    if (Math.abs(this.m_SeismometerValues[1][this.m_SeismometerValueIndex] + (double)this.m_SeismometerOffset) > (double)this.m_SeismometerRange * this.m_ToleranceSeismometer / 100.0) {
                        if (!this.m_ToleranceSeismometerExceededY) {
                            this.m_ToleranceSeismometerExceededY = true;
                            this.addToLogFile("Seismic data VALUE outside tolerance level.");
                            this.showText(this.m_TextStatus, "Seismic data VALUE outside tolerance level.");
                        }
                        this.m_ToleranceSeismometerExceededYCounter = 0;
                    } else if (this.m_ToleranceSeismometerExceededY) {
                        ++this.m_ToleranceSeismometerExceededYCounter;
                        if (this.m_ToleranceSeismometerExceededYCounter > 50) {
                            this.addToLogFile("Seismic data VALUE back within tolerance level.");
                            this.showText(this.m_TextStatus, "Seismic data VALUE back within tolerance level.");
                            this.m_ToleranceSeismometerExceededY = false;
                        }
                    }
                }
                this.m_SeismometerStDev[this.m_SeismometerValueIndex] = this.getStDev(this.m_SeismometerValues, 0, 1, this.m_SeismometerValueIndex - 1);
                try {
                    this.m_SeismometerData.writeBytes(this.m_RaGraphPanel.formatHMS(d) + "\t" + d2 + "\t" + (d2 + (double)this.m_SeismometerOffset) + "\t" + String.format("%.2f", this.m_SeismometerStDev[this.m_SeismometerValueIndex]).replace(",", ".") + "\r\n");
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void shiftSeismicData() {
        this.m_ShiftSeismicData = false;
        int n = 0;
        for (int i = 0; i <= this.m_SeismometerValueIndex; ++i) {
            Boolean bl = this.m_SeismometerValues[0][i] > 23.0 && this.m_MountValues[1 - this.m_CommandRotatorFirstVal][0] < 1.0;
            if (!(this.m_SeismometerValues[0][i] > this.m_MountValues[1 - this.m_CommandRotatorFirstVal][0]) || bl.booleanValue()) continue;
            if (n == 0) {
                n = i;
            }
            this.m_SeismometerValues[0][i - n] = this.m_SeismometerValues[0][i];
            this.m_SeismometerValues[1][i - n] = this.m_SeismometerValues[1][i];
            this.m_SeismometerStDev[i - n] = this.m_SeismometerStDev[i];
        }
        this.m_SeismometerValueIndex -= n;
    }

    public String md5(String string, boolean bl) {
        String string2 = "MM" + string + "raadj3suf";
        String string3 = "";
        string2 = bl ? string2 + "1" : string2 + "0";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string2.getBytes(StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            string3 = stringBuilder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public boolean checkLicence(boolean bl) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        String string2 = this.m_EMail;
        if (string2 == "") {
            string2 = this.m_Sitename;
        }
        if (string2 == "") {
            string2 = this.m_MountName;
        }
        if (string2 == "") {
            string2 = this.m_MountID;
        }
        if (string2 == "") {
            string2 = "";
        }
        String string3 = this.md5(string2, false);
        String string4 = this.md5(string2, true);
        String string5 = "";
        Boolean bl2 = this.checkIfItIsMe();
        boolean bl3 = false;
        try {
            String string6;
            stringArray = StandardCharsets.UTF_8.name();
            string5 = bl ? String.format("email=%s&observatory=%s&mountname=%s&firmware=%s&mountid=%s&MMversion=%s&latitude=%s&longitude=%s&elevation=%s", URLEncoder.encode(string2, (String)stringArray), URLEncoder.encode(this.m_Sitename, (String)stringArray), URLEncoder.encode(this.m_MountName, (String)stringArray), URLEncoder.encode(this.m_Firmware, (String)stringArray), URLEncoder.encode(this.m_MountID, (String)stringArray), URLEncoder.encode(this.m_VersionNo, (String)stringArray), URLEncoder.encode("" + this.m_Latitude, (String)stringArray), URLEncoder.encode("" + this.m_Longitude, (String)stringArray), URLEncoder.encode("" + this.m_Elevation, (String)stringArray)) : String.format("email=%s&observatory=%s&MMversion=%s", URLEncoder.encode(string2, (String)stringArray), URLEncoder.encode(this.m_Sitename, (String)stringArray), URLEncoder.encode(this.m_VersionNo, (String)stringArray));
            String string7 = "http://www.dehilster.info/checklicence.php";
            URL uRL = bl2 != false ? new URL(string7 + "?" + string5 + "&itisme=ja") : new URL(string7 + "?" + string5);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setRequestProperty("Accept-Charset", (String)stringArray);
            httpURLConnection.setRequestMethod("GET");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((string6 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string6);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = stringBuilder.toString();
        stringArray = string.split("~");
        bl3 = stringArray.length >= 4 ? stringArray[3].equals(string4) : false;
        return bl3;
    }

    public void getMountInfo() {
        String string = "";
        if (this.mountCanHandleCommand(8) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 8)) != "") {
            this.m_Firmware = string;
        }
        if (this.mountCanHandleCommand(7) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 7)) != "") {
            this.m_MountName = string;
        }
        if (this.mountCanHandleCommand(9) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 9)) != "") {
            this.m_MountID = string;
        }
        if (this.mountCanHandleCommand(17)) {
            string = this.requestMountData(this.m_Writer, this.m_Reader, 17);
            this.m_MountUTCOffset = this.getUTCOffset(string);
        }
    }

    public void checkMountSettings() {
        String string = "";
        Boolean bl = true;
        String string2 = "";
        String string3 = " in the mount!<BR>Correct this through the (virtual) keypad.<BR><BR>This message can be disabled in Preferences/Edit/Miscellaneous.";
        if (this.m_CheckMountSettingsIndexesList.size() > 0 && !this.m_TestModeSimulateMount) {
            for (int i = 0; i < this.m_CheckMountSettingsIndexesList.size(); ++i) {
                int[] nArray = this.m_CheckMountSettingsIndexesList.get(i);
                if (!this.mountCanHandleCommand(nArray[0]) || this.m_MountCommandSet[nArray[0]][1 + this.m_CommandMode] == "" || !this.m_MountCommandSet[nArray[0]][6].equals("2") || nArray[2] != 1) continue;
                String[] stringArray = this.m_MountCommandSet[nArray[0]][9].split("~");
                String[] stringArray2 = this.m_MountCommandSet[nArray[0]][10 + this.m_CommandMode].split("~");
                if (stringArray2[0].equals(":PRlist#") && this.m_MountName.toLowerCase().indexOf("10micron") != -1) {
                    string = this.requestMountData(this.m_Writer, this.m_Reader, 28);
                    while (!string.equals("c")) {
                        String[] stringArray3;
                        string = this.requestMountData(this.m_Writer, this.m_Reader, 29);
                        for (String string4 : stringArray3 = string.split(";")) {
                            String[] stringArray4 = string4.split(",");
                            string2 = "Follow object";
                            if (string4.indexOf(string2) != -1) {
                                if (!stringArray4[3].equals("0")) {
                                    bl = false;
                                    string2 = string2 + " is ON";
                                    this.addToLogFile("WRONG SET-UP: " + string2 + "!");
                                    this.alertBox("Mount set-up", string2 + string3);
                                } else {
                                    string2 = string2 + " is OFF";
                                    this.addToLogFile("Verified that " + string2);
                                }
                            }
                            if (string4.indexOf(string2 = "Tracking correction") != -1) {
                                if (!stringArray4[3].equals("0.000")) {
                                    bl = false;
                                    string2 = string2 + " is set to " + stringArray4[3] + "%";
                                    this.addToLogFile("WRONG SET-UP: " + string2 + "!");
                                    this.alertBox("Mount set-up", string2 + string3);
                                } else {
                                    string2 = string2 + " is set to " + stringArray4[3] + "%";
                                    this.addToLogFile("Verified that " + string2);
                                }
                            }
                            if (string4.indexOf(string2 = "Tracking speed") == -1) continue;
                            if (!stringArray4[3].equals("0")) {
                                bl = false;
                                string2 = string2 + " is set to " + stringArray4[5 + Integer.parseInt(stringArray4[3])];
                                this.addToLogFile("WRONG SET-UP: " + string2 + "!");
                                this.alertBox("Mount set-up", string2 + string3);
                                continue;
                            }
                            string2 = string2 + " is set to " + stringArray4[5];
                            this.addToLogFile("Verified that " + string2);
                        }
                    }
                    continue;
                }
                string = this.requestMountData(this.m_Writer, this.m_Reader, nArray[0]);
                if (!string.equals(stringArray2[nArray[1]])) {
                    string2 = this.m_MountCommandSet[nArray[0]][3] + " is not set to \"" + stringArray[nArray[1]] + "\"";
                    this.alertBox("Mount set-up", string2 + string3);
                    this.addToLogFile("WRONG SET-UP: " + this.m_MountCommandSet[nArray[0]][3] + " is not set to \"" + stringArray[nArray[1]] + "\" in the mount!");
                    continue;
                }
                this.addToLogFile("Verified that " + this.m_MountCommandSet[nArray[0]][3] + " is correctly set to \"" + stringArray[nArray[1]] + "\" in the mount.");
            }
        }
        this.m_CheckMountSettings = false;
    }

    public void getMountPosition() {
        String string = "";
        if (this.mountCanHandleCommand(13)) {
            this.requestMountData(this.m_Writer, this.m_Reader, 13);
        }
        if (this.mountCanHandleCommand(14) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 14)) != "") {
            this.m_Latitude = this.makeDecimal(string);
        }
        if (this.mountCanHandleCommand(15) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 15)) != "") {
            this.m_Longitude = this.m_CommandMode == 0 ? -this.makeDecimal(string) : this.makeDecimal(string);
        }
        if (this.mountCanHandleCommand(16) && MountMonitor.isNumeric(string = this.requestMountData(this.m_Writer, this.m_Reader, 16))) {
            this.m_Elevation = Double.parseDouble(string);
        }
    }

    public void getTargetCoordinates() {
        String string = "";
        Boolean bl = false;
        if (this.mountCanHandleCommand(13)) {
            this.requestMountData(this.m_Writer, this.m_Reader, 13);
        }
        if (this.mountCanHandleCommand(18)) {
            string = this.requestMountData(this.m_Writer, this.m_Reader, 18);
            if (string != "") {
                this.m_TargetRA = this.makeDecimal(string);
            }
            if (this.m_TargetRA == 360.0) {
                string = this.requestMountData(this.m_Writer, this.m_Reader, 2);
                if (string != "") {
                    this.m_TargetRA = Math.min(24.0, this.makeDecimal(string));
                }
                bl = true;
            }
        }
        if (this.mountCanHandleCommand(19)) {
            string = this.requestMountData(this.m_Writer, this.m_Reader, 19);
            if (string != "") {
                this.m_TargetDEC = this.makeDecimal(string);
            }
            if (this.m_TargetDEC == 360.0) {
                string = this.requestMountData(this.m_Writer, this.m_Reader, 3);
                if (string != "") {
                    this.m_TargetDEC = Math.min(90.0, this.makeDecimal(string));
                }
                bl = true;
            }
        }
        this.m_TargetCoordinates[2] = this.m_TargetRA;
        this.m_TargetCoordinates[3] = this.m_TargetDEC;
        this.showText(this.m_TextStatus, "Target RA/DEC: " + this.m_RaGraphPanel.formatHMS(this.m_TargetRA) + ", " + this.m_RaGraphPanel.formatHMS(this.m_TargetDEC));
        this.addToLogFile("Target RA/DEC: " + this.m_RaGraphPanel.formatHMS(this.m_TargetRA) + ", " + this.m_RaGraphPanel.formatHMS(this.m_TargetDEC));
        if (bl.booleanValue()) {
            this.showText(this.m_TextStatus, "Target RA/DEC set to current RA/DEC values...");
            this.showText(this.m_TextStatus, "Slew the scope to receive actual RA/DEC values!");
            this.addToLogFile("Target RA/DEC set to current RA/DEC values...");
            this.addToLogFile("Slew the scope to receive actual RA/DEC values!");
        }
    }

    public void getInitialMountAttitude() {
        String string = "";
        if (this.mountCanHandleCommand(12) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 12)) != "") {
            this.m_PierSide = string;
        }
        if (this.mountCanHandleCommand(13)) {
            this.requestMountData(this.m_Writer, this.m_Reader, 13);
        }
        if (this.mountCanHandleCommand(11) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 11)) != "") {
            this.m_Altitude = string;
        }
        if (this.mountCanHandleCommand(10) && (string = this.requestMountData(this.m_Writer, this.m_Reader, 10)) != "") {
            this.m_Azimuth = string;
        }
    }

    public void addMountAttitudeToFile(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeBytes("Telescopes are " + this.m_PierSide + " of the mount, pointing at azimuth " + this.m_Azimuth + ", altitude " + this.m_Altitude + "\r\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addMountChecksToFile(DataOutputStream dataOutputStream) {
        try {
            if (this.m_CheckMountSettingsIndexesList.size() > 0) {
                // empty if block
            }
            this.m_Logs.writeBytes("Mount set-up is checked for:\r\n");
            for (int i = 0; i < this.m_CheckMountSettingsIndexesList.size(); ++i) {
                int[] nArray = this.m_CheckMountSettingsIndexesList.get(i);
                if (!this.mountCanHandleCommand(nArray[0]) || !this.m_MountCommandSet[nArray[0]][6].equals("2") || nArray[2] != 1) continue;
                String[] stringArray = this.m_MountCommandSet[nArray[0]][9].split("~");
                dataOutputStream.writeBytes("   " + this.m_MountCommandSet[nArray[0]][3] + ", which should be set to \"" + stringArray[nArray[1]] + "\".\r\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addMinMaxToLog() {
        this.addToLogFile("==========================================");
        for (int i = 2; i < this.m_MountDataRows; ++i) {
            this.addToLogFile("Minimum value " + this.m_MountCommandSet[i][3] + ": " + this.m_RaGraphPanel.formatHMS(this.m_MinMountValues[0][i]));
            this.addToLogFile("Maximum value " + this.m_MountCommandSet[i][3] + ": " + this.m_RaGraphPanel.formatHMS(this.m_MaxMountValues[0][i]));
            this.addToLogFile("Range Min-Max " + this.m_MountCommandSet[i][3] + ": " + String.format("%.2f", (this.m_MaxMountValues[0][i] - this.m_MinMountValues[0][i]) * 3600.0).replace(",", ".") + "''");
            this.addToLogFile("Maximum STDEV " + this.m_MountCommandSet[i][3] + ": " + String.format("%.2f", this.m_MaxStDev[i] * 3600.0).replace(",", ".") + "''");
            this.addToLogFile("");
        }
        this.addToLogFile("==========================================");
    }

    public void checkTime() {
        String string = this.m_NistTimeServer;
        NTPUDPClient nTPUDPClient = new NTPUDPClient();
        boolean bl = false;
        try {
            nTPUDPClient.open();
            nTPUDPClient.setSoTimeout(2000);
            bl = true;
        }
        catch (SocketException socketException) {
            bl = false;
        }
        InetAddress inetAddress = null;
        TimeInfo timeInfo = null;
        long l = 0L;
        try {
            inetAddress = InetAddress.getByName(string);
            bl = true;
        }
        catch (UnknownHostException unknownHostException) {
            bl = false;
        }
        if (bl) {
            bl = false;
            try {
                inetAddress.isReachable(200);
                l = this.getPcTime();
                timeInfo = nTPUDPClient.getTime(inetAddress);
                bl = true;
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        if (bl) {
            this.m_LastNISTServerPollTime = l;
            NtpV3Packet ntpV3Packet = timeInfo.getMessage();
            long l2 = ntpV3Packet.getTransmitTimeStamp().getTime();
            this.m_lastPC_NISTServerDifference = l2 - this.m_LastNISTServerPollTime - (long)this.m_PcUTCOffset * 3600L * 1000L;
            Date date = new Date(l2);
            String string2 = "slow";
            if (this.m_lastPC_NISTServerDifference < 0L) {
                string2 = "fast";
            }
            if (this.m_NistTimeServerFailed) {
                this.m_LogUpdateNistTimeServerReconnected = true;
            }
            this.m_NistTimeServerFailed = false;
        } else {
            if (!this.m_NistTimeServerFailed) {
                this.m_LogUpdateNistTimeServerFailed = true;
            }
            this.m_NistTimeServerFailed = true;
        }
    }

    public class LinearRegression {
        private final double intercept;
        private final double slope;
        private final double r2;
        private final double svar0;
        private final double svar1;

        public LinearRegression(double[][] dArray, int n, int n2, int n3) {
            double d;
            int n4;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = n; i < n2; ++i) {
                d2 += dArray[0][i];
                d4 += dArray[0][i] * dArray[0][i];
                d3 += dArray[n3][i];
            }
            double d5 = d2 / (double)(n2 - n);
            double d6 = d3 / (double)(n2 - n);
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            for (int i = n; i < n2; ++i) {
                d7 += (dArray[0][i] - d5) * (dArray[0][i] - d5);
                d8 += (dArray[n3][i] - d6) * (dArray[n3][i] - d6);
                d9 += (dArray[0][i] - d5) * (dArray[n3][i] - d6);
            }
            this.slope = d9 / d7;
            this.intercept = d6 - this.slope * d5;
            double d10 = 0.0;
            double d11 = 0.0;
            for (n4 = n; n4 < n2; ++n4) {
                d = this.slope * dArray[0][n4] + this.intercept;
                d10 += (d - dArray[n3][n4]) * (d - dArray[n3][n4]);
                d11 += (d - d6) * (d - d6);
            }
            n4 = n2 - n - 2;
            this.r2 = d11 / d8;
            d = d10 / (double)n4;
            this.svar1 = d / d7;
            this.svar0 = d / (double)(n2 - n) + d5 * d5 * this.svar1;
        }

        public double intercept() {
            return this.intercept;
        }

        public double slope() {
            return this.slope;
        }

        public double R2() {
            return this.r2;
        }

        public double interceptStdErr() {
            return Math.sqrt(this.svar0);
        }

        public double slopeStdErr() {
            return Math.sqrt(this.svar1);
        }

        public double predict(double d) {
            return this.slope * d + this.intercept;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("%.2f n + %.2f", this.slope(), this.intercept()));
            stringBuilder.append("  (R^2 = " + String.format("%.3f", this.R2()) + ")");
            return stringBuilder.toString();
        }
    }

    public class openChm {
        public void openChmMethod(String string) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

