/*
 * Decompiled with CFR 0.152.
 */
import java.util.Objects;

public class Complex {
    private final double re;
    private final double im;

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public String toString() {
        if (this.im == 0.0) {
            return this.re + "";
        }
        if (this.re == 0.0) {
            return this.im + "i";
        }
        if (this.im < 0.0) {
            return this.re + " - " + -this.im + "i";
        }
        return this.re + " + " + this.im + "i";
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public Complex plus(Complex complex) {
        Complex complex2 = this;
        double d = complex2.re + complex.re;
        double d2 = complex2.im + complex.im;
        return new Complex(d, d2);
    }

    public Complex minus(Complex complex) {
        Complex complex2 = this;
        double d = complex2.re - complex.re;
        double d2 = complex2.im - complex.im;
        return new Complex(d, d2);
    }

    public Complex times(Complex complex) {
        Complex complex2 = this;
        double d = complex2.re * complex.re - complex2.im * complex.im;
        double d2 = complex2.re * complex.im + complex2.im * complex.re;
        return new Complex(d, d2);
    }

    public Complex scale(double d) {
        return new Complex(d * this.re, d * this.im);
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public Complex reciprocal() {
        double d = this.re * this.re + this.im * this.im;
        return new Complex(this.re / d, -this.im / d);
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public Complex divides(Complex complex) {
        Complex complex2 = this;
        return complex2.times(complex.reciprocal());
    }

    public Complex exp() {
        return new Complex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    public Complex sin() {
        return new Complex(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
    }

    public Complex tan() {
        return this.sin().divides(this.cos());
    }

    public static Complex plus(Complex complex, Complex complex2) {
        double d = complex.re + complex2.re;
        double d2 = complex.im + complex2.im;
        Complex complex3 = new Complex(d, d2);
        return complex3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Complex complex = (Complex)object;
        return this.re == complex.re && this.im == complex.im;
    }

    public int hashCode() {
        return Objects.hash(this.re, this.im);
    }

    public static void main(String[] stringArray) {
        Complex complex = new Complex(5.0, 6.0);
        Complex complex2 = new Complex(-3.0, 4.0);
        System.out.println("a            = " + complex);
        System.out.println("b            = " + complex2);
        System.out.println("Re(a)        = " + complex.re());
        System.out.println("Im(a)        = " + complex.im());
        System.out.println("b + a        = " + complex2.plus(complex));
        System.out.println("a - b        = " + complex.minus(complex2));
        System.out.println("a * b        = " + complex.times(complex2));
        System.out.println("b * a        = " + complex2.times(complex));
        System.out.println("a / b        = " + complex.divides(complex2));
        System.out.println("(a / b) * b  = " + complex.divides(complex2).times(complex2));
        System.out.println("conj(a)      = " + complex.conjugate());
        System.out.println("|a|          = " + complex.abs());
        System.out.println("tan(a)       = " + complex.tan());
    }
}

