/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

class GraphPanel
extends Panel {
    public int arraySize = 12;
    public double[][] YV = new double[this.arraySize][2001];
    public double[][] SV = new double[this.arraySize][2001];
    public double[][] mountStatData = new double[this.arraySize][2001];
    public double[][] mountAxisSpeedData = new double[this.arraySize][2001];
    public double[][] mountAxisData = new double[3][10];
    public double[] SStD = new double[2001];
    public double[] MSD = new double[this.arraySize];
    public double[] MaxYV = new double[this.arraySize];
    public double[] MinYV = new double[this.arraySize];
    public int PF = 1;
    public int SO = 300;
    public int SR = 2000;
    public int DS = 1;
    public int TD = 8;
    public double DTS = 0.0;
    public double PCTS = 0.0;
    public int STSL = 0;
    public boolean SNTS = false;
    public boolean showMountAxisSpeed = false;
    public int axialSpeedDataSet = 0;
    public int mountAxisSpeedDataStartIdx = 0;
    public boolean showAxialSpeedAsDisplacement = false;
    public int hScale = 1;
    public int vScale = 1;
    public double seismicScale = 0.0;
    public double toleranceRD = 0.0;
    public double toleranceRDorg = 0.0;
    public double toleranceS = 0.0;
    public boolean isRAMode = false;
    public boolean useAsHATolerance = false;
    public double decValueForConversion = 0.0;
    public int RRL = 60;
    public int RRRL = 6;
    public boolean adjustGraphsForRunningRangeLength = false;
    public double[] theReferences = new double[this.arraySize];
    public int theReferenceType = 0;
    public String modeText = "";
    public double instrumentHeight = 0.0;
    public int yIndex = 0;
    public int sIndex = 0;
    public String port = "000.000.000.000:0000";
    public int width;
    public int height;
    double scale;
    double MASDscale;
    double RMASDscale;
    double average;
    double MASDaverage;
    double RMASDaverage;
    public boolean isActive;
    public boolean stayEmpty;
    public boolean isSeismic;
    public boolean isDeltaTime;
    double yCorrection;
    public BufferedImage myimg;
    public Graphics2D g2d;
    public Font currentFont;
    public Font newFont;
    public int currentFontSize;
    public int newFontSize;
    public Color graphColor;
    public double titleRatio;
    public int significance;
    public int xOffsetForRunningRangeLength;

    public int getIdx() {
        return this.yIndex;
    }

    public BufferedImage getImage() {
        return new BufferedImage(this.width, this.height, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, 10);
    }

    public void setActive() {
        this.stayEmpty = false;
        this.isActive = true;
    }

    public void setAdjustGraphsForRunningRangeLength(boolean bl) {
        this.adjustGraphsForRunningRangeLength = bl;
    }

    public void setDeclination(double d) {
        this.decValueForConversion = d;
    }

    public void setDeltaTime() {
        this.isDeltaTime = true;
    }

    public void setDeltaTimeSlope(double d) {
        this.DTS = d;
    }

    public void setDimension(Dimension dimension) {
        this.width = Math.max(1, dimension.width);
        this.height = Math.max(1, dimension.height);
    }

    public void setHScale(int n) {
        this.hScale = n;
    }

    public void setImage(Image image) {
        this.myimg = (BufferedImage)image;
        this.repaint();
    }

    public void setMaxStatData(double[] dArray) {
        this.MSD = dArray;
    }

    public void setMaxYData(double[] dArray) {
        this.MaxYV = dArray;
    }

    public void setMinYData(double[] dArray) {
        this.MinYV = dArray;
    }

    public void setModeText(String string) {
        this.modeText = string.toUpperCase();
        this.isRAMode = this.modeText.indexOf("ASCENSION") != -1;
    }

    public void setMountAxisSpeedData(double[][] dArray) {
        this.mountAxisSpeedData = dArray;
        this.mountAxisData = new double[3][this.mountAxisSpeedData[0].length];
    }

    public void setMountAxisSpeedDataStartIdx(int n) {
        this.mountAxisSpeedDataStartIdx = n;
    }

    public void setMountStatData(double[][] dArray) {
        this.mountStatData = dArray;
    }

    public void setPCTimeSlope(double d) {
        this.PCTS = d;
    }

    public void setPollFrequency(int n) {
        this.PF = n;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setReference(double[] dArray, int n) {
        this.theReferences = dArray;
        this.theReferenceType = n;
    }

    public void setRunningRangeLength(int n) {
        this.RRL = n;
    }

    public void setSData(double[][] dArray) {
        this.SV = dArray;
    }

    public void setSeismic() {
        this.isSeismic = true;
    }

    public void setSeismometerOffset(int n) {
        this.SO = n;
    }

    public void setSeismometerRange(int n) {
        this.SR = n;
    }

    public void setSeismometerStatData(double[] dArray) {
        this.SStD = dArray;
    }

    public void setSVIndex(int n) {
        this.sIndex = n;
    }

    public void setTimeData(int n) {
        this.TD = n;
    }

    public void setTimeScaleLimit(int n) {
        this.STSL = n;
    }

    public void setToleranceRaDec(double d) {
        this.toleranceRDorg = d;
    }

    public void setToleranceSeismometer(double d) {
        this.toleranceS = d;
    }

    public void setUseAsHATolerance(boolean bl) {
        this.useAsHATolerance = bl;
    }

    public void setVScale(int n) {
        this.vScale = n;
    }

    public void setYData(double[][] dArray) {
        this.YV = dArray;
    }

    public void setYDataSetShown(int n) {
        this.DS = n;
    }

    public void setYVIndex(int n) {
        this.yIndex = n;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void showMountAxisSpeedData(boolean bl, int n, boolean bl2) {
        this.showMountAxisSpeed = bl;
        this.axialSpeedDataSet = n;
        this.showAxialSpeedAsDisplacement = bl2;
    }

    public void showNistTimeServer(boolean bl) {
        this.SNTS = bl;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public GraphPanel(int n, int n2, Color color) {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.isActive = false;
        this.stayEmpty = true;
        this.isSeismic = false;
        this.isDeltaTime = false;
        this.myimg = null;
        this.g2d = null;
        this.titleRatio = 0.004477611940298508;
        this.significance = 2;
        this.xOffsetForRunningRangeLength = 0;
        this.setLayout(null);
        this.setSize(n, n2);
        this.setForeground(color);
        this.setBackground(Color.gray);
        this.width = Math.max(1, n);
        this.height = Math.max(1, n2);
        this.myimg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
    }

    public String formatHMS(Double d) {
        String string;
        Double d2;
        String string2;
        Double d3;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d = Math.abs(d);
        Object[] objectArray = new Object[]{d};
        String string3 = "" + String.format("%.12f", objectArray).replace(",", ".");
        String string4 = string3.substring(0, (string3 + ".").indexOf("."));
        Double d4 = Double.parseDouble(string4);
        if (d4 < 10.0) {
            string4 = "0" + string4;
        }
        if ((d3 = Double.valueOf(Double.parseDouble(string2 = (string3 = "" + (d - d4) * 60.0).substring(0, (string3 + ".").indexOf("."))))) < 10.0) {
            string2 = "0" + string2;
        }
        if ((d2 = Double.valueOf(Double.parseDouble(string = (string3 = (string3 = "" + (double)Math.round(((d - d4) * 60.0 - d3) * 60.0 * 100.0) / 100.0).indexOf(".") == -1 ? string3 + ".00" : string3 + "000").substring(0, string3.indexOf(".") + 3)))) < 10.0) {
            string = "0" + string;
        }
        String string5 = n < 0 ? "-" : "";
        string5 = string5 + string4 + ":" + string2 + ":" + string;
        return string5;
    }

    public void centreString(Graphics graphics, String string, Font font) {
        try {
            Rectangle rectangle = new Rectangle(this.width, this.height);
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            int n = (int)Math.round(rectangle2D.getWidth());
            int n2 = (int)Math.round(rectangle2D.getHeight());
            int n3 = (int)Math.round(rectangle2D.getX());
            int n4 = (int)Math.round(rectangle2D.getY());
            int n5 = rectangle.width / 2 - n / 2 - n3;
            int n6 = rectangle.height / 2 - n2 / 2 - n4;
            graphics.setFont(font);
            graphics.drawString(string, rectangle.x + n5, rectangle.y + n6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double convertRaDecToGraphY(double d, double d2, double d3) {
        return (double)this.height - ((d - d2) * d3 + (double)this.height / 2.0);
    }

    public double convertSeismometerToGraphY(double d) {
        return (double)this.height - ((d + (double)this.SO) * this.seismicScale + (double)this.height / 2.0);
    }

    public double convertTimeToGraphY(double d) {
        double d2 = 0.0;
        d2 = (double)this.height - ((d + (double)this.SO * 0.0) * this.seismicScale + (double)this.height / 2.0);
        return d2;
    }

    public void drawGraph(Graphics2D graphics2D) {
        if (this.width * this.height < 0) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        double d = 9.0E12;
        double d2 = -9.0E12;
        double d3 = 9.0E12;
        double d4 = -9.0E12;
        double d5 = 9.0E12;
        double d6 = -9.0E12;
        String string = "";
        double d7 = 0.0;
        boolean bl = false;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        Color color = new Color(100, 100, 100);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.width, this.height);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, this.width, this.height);
        this.currentFont = graphics2D.getFont();
        this.currentFontSize = this.currentFont.getSize();
        this.newFont = this.currentFont.deriveFont((int)((float)this.currentFontSize * 6.0f));
        graphics2D.setFont(this.newFont);
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, this.currentFont.getFamily());
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
        hashMap.put(TextAttribute.SIZE, (int)((double)this.currentFont.getSize() * 2.0 * this.titleRatio * (double)this.width));
        this.newFont = Font.getFont(hashMap);
        this.newFontSize = this.newFont.getSize();
        graphics2D.setFont(this.newFont);
        graphics2D.setColor(new Color(240, 240, 240));
        this.centreString(graphics2D, this.modeText, this.newFont);
        graphics2D.setFont(this.currentFont);
        if (!this.stayEmpty) {
            int n;
            double d13;
            double d14;
            int n2;
            Object object;
            String string2;
            double d15;
            double d16;
            double d17;
            int n3;
            if (this.isRAMode && !this.useAsHATolerance && this.yIndex > 0) {
                if (this.decValueForConversion != 90.0) {
                    this.toleranceRD = this.toleranceRDorg / 15.0 / Math.cos(Math.toRadians(this.decValueForConversion));
                }
            } else {
                this.toleranceRD = this.toleranceRDorg;
            }
            this.significance = (int)(Math.floor(Math.log(this.RRL) / Math.log(10.0)) + 1.0);
            if (this.showMountAxisSpeed) {
                int n4;
                for (n4 = 0; n4 < this.yIndex; ++n4) {
                    this.mountAxisData[0][n4] = this.mountAxisSpeedData[this.axialSpeedDataSet + 2][n4] * 1.0;
                    this.mountAxisData[1][n4] = n4 > 0 ? (this.mountAxisData[1][n4 - 1] * 4.0 + this.mountAxisData[0][n4]) / 5.0 : this.mountAxisData[0][n4];
                    d11 += this.mountAxisData[0][n4];
                    if (this.showAxialSpeedAsDisplacement) {
                        if (n4 > this.mountAxisSpeedDataStartIdx + 1) {
                            double d18 = (this.mountAxisSpeedData[this.axialSpeedDataSet - 4][n4] - this.mountAxisSpeedData[this.axialSpeedDataSet - 4][n4 - 1]) * 3600.0;
                            double d19 = this.mountAxisSpeedData[this.axialSpeedDataSet][n4] - this.theReferences[this.axialSpeedDataSet] * 1.0;
                            double d20 = d19 * d18;
                            this.mountAxisData[2][n4] = this.mountAxisData[2][n4 - 1] + d20;
                        } else {
                            this.mountAxisData[2][n4] = 0.0;
                        }
                    } else {
                        this.mountAxisData[2][n4] = (this.mountAxisSpeedData[this.axialSpeedDataSet][n4] - d8) * 1.0;
                    }
                    d10 += this.mountAxisData[2][n4];
                }
                d9 = d11 / (double)this.yIndex;
                d8 = d10 / (double)this.yIndex;
                for (n4 = 0; n4 < this.yIndex; ++n4) {
                    if (this.YV[this.DS][n4] > d2) {
                        d2 = this.YV[this.DS][n4];
                    }
                    if (this.YV[this.DS][n4] < d) {
                        d = this.YV[this.DS][n4];
                    }
                    if (!this.showMountAxisSpeed || n4 <= this.mountAxisSpeedDataStartIdx) continue;
                    if (this.mountAxisData[0][n4] > d4) {
                        d4 = this.mountAxisData[0][n4];
                    }
                    if (this.mountAxisData[0][n4] < d3) {
                        d3 = this.mountAxisData[0][n4];
                    }
                    if (this.mountAxisData[2][n4] > d6) {
                        d6 = this.mountAxisData[2][n4];
                    }
                    if (!(this.mountAxisData[2][n4] < d5)) continue;
                    d5 = this.mountAxisData[2][n4];
                }
            }
            if (this.yIndex < 30) {
                this.showMountAxisSpeed = false;
            }
            this.average = this.theReferences[this.DS];
            double d21 = Math.max(d2 - this.average, this.average - d);
            d2 = this.average + d21 * 1.1;
            d = this.average - d21 * 1.1;
            d21 = Math.max(d6 - d8, d8 - d5);
            this.MASDscale = (double)this.height / (2.0 * d21 * 1.2);
            d21 = Math.max(d4 - d9, d9 - d3);
            this.RMASDscale = (double)this.height / (2.0 * d21 * 2.0);
            switch (this.vScale) {
                case 0: {
                    break;
                }
                case 1: {
                    d2 = this.average + this.toleranceRD / 3600.0 * 1.1;
                    d = this.average - this.toleranceRD / 3600.0 * 1.1;
                    break;
                }
                case 2: {
                    d2 = Math.max(d2, this.average + this.toleranceRD / 3600.0 * 1.1);
                    d = Math.min(d, this.average - this.toleranceRD / 3600.0 * 1.1);
                    break;
                }
                case 3: {
                    double d22 = Math.max(this.MaxYV[this.DS] - this.average, this.average - this.MinYV[this.DS]) * 1.1;
                    d2 = this.average + d22;
                    d = this.average - d22;
                }
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            double d23 = d2 - d < 0.0 ? -1.0 : 1.0;
            double d24 = 0.0;
            double d25 = Math.abs(d2 - d) * 3600.0;
            if (d25 < 1.0) {
                n3 = Math.round((float)(Math.log(d23 * (d2 - d) * 2.0) / Math.log(10.0)));
                if (n3 < -8) {
                    n3 = -8;
                }
                d17 = (double)((int)Math.round(d / Math.pow(10.0, n3 - 1))) * Math.pow(10.0, n3 - 1);
                d16 = d23 * Math.pow(10.0, n3 - 1);
            } else {
                n3 = Math.round((float)(Math.log(d23 * (d2 - d) * 3600.0) / Math.log(10.0)));
                d16 = d23 * Math.pow(10.0, n3 - 1) / 2400.0;
                d17 = (double)Math.round(this.average * 3600.0) / 3600.0 - 10.0 * d16;
            }
            this.scale = (double)this.height / (d2 - d);
            if (!this.isSeismic && !this.isDeltaTime) {
                for (n3 = 0; n3 <= 20; ++n3) {
                    d15 = d17 + (double)n3 * d16;
                    d24 = this.convertRaDecToGraphY(d15, this.average, this.scale);
                    graphics2D.setColor(color);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = "" + this.formatHMS(d15);
                    graphics2D.setColor(color);
                    if (this.yIndex <= 0) continue;
                    graphics2D.drawString(string2, 0, (int)(d24 - 1.0));
                }
            } else if (this.isDeltaTime) {
                if (this.STSL != 0) {
                    this.SR = Math.min(this.STSL, this.SR);
                }
                graphics2D.setColor(color);
                graphics2D.drawLine(0, (int)((double)this.height / 2.0), this.width, (int)((double)this.height / 2.0));
                graphics2D.drawString("0ms", 0, (int)((double)this.height / 2.0));
                graphics2D.drawString("-" + this.SR + "ms", 0, 12);
                graphics2D.drawString("+" + this.SR + "ms", 0, this.height - 6);
                if (this.toleranceS > 0.0) {
                    graphics2D.setColor(new Color(0, 153, 0));
                    string2 = this.toleranceS < 2.0 ? String.format("%.2f", this.toleranceS).replace(",", ".") + "%" : String.format("%.0f", this.toleranceS).replace(",", ".") + "%";
                    d24 = this.convertTimeToGraphY((double)this.SR * this.toleranceS / 100.0 - (double)this.SO);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = "Upper tolerance = +" + string2;
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 + 11.0));
                    d24 = this.convertTimeToGraphY((double)(-this.SR) * this.toleranceS / 100.0 - (double)this.SO);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = string2.replace("+", "-").replace("Upper", "Lower");
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 - 1.0));
                }
            } else {
                graphics2D.setColor(color);
                graphics2D.drawLine(0, (int)((double)this.height / 2.0), this.width, (int)((double)this.height / 2.0));
                graphics2D.drawString("0", 0, (int)((double)this.height / 2.0));
                graphics2D.drawString("-" + this.SR, 0, 12);
                graphics2D.drawString("+" + this.SR, 0, this.height - 6);
                if (this.toleranceS > 0.0) {
                    graphics2D.setColor(new Color(0, 153, 0));
                    string2 = this.toleranceS < 2.0 ? String.format("%.2f", this.toleranceS).replace(",", ".") + "%" : String.format("%.0f", this.toleranceS).replace(",", ".") + "%";
                    d24 = this.convertSeismometerToGraphY((double)this.SR * this.toleranceS / 100.0 - (double)this.SO);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = "Upper tolerance = +" + string2;
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 + 11.0));
                    d24 = this.convertSeismometerToGraphY((double)(-this.SR) * this.toleranceS / 100.0 - (double)this.SO);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = string2.replace("+", "-").replace("Upper", "Lower");
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 - 1.0));
                }
            }
            if (this.yIndex > 1) {
                graphics2D.setColor(color);
                AffineTransform affineTransform = new AffineTransform();
                object = graphics2D.getTransform();
                graphics2D.setColor(color);
                affineTransform.rotate(-1.5707963267948966);
                n2 = 0;
                d14 = 0.0;
                d13 = 999.0;
                for (n = 0; n < this.yIndex; ++n) {
                    d14 = this.YV[this.TD][n] * 60.0 * 60.0 / 30.0 - Math.floor(this.YV[this.TD][n] * 60.0 * 60.0 / 30.0);
                    if (d14 < d13 && (n2 = n * this.hScale) > 80 && n2 < this.width - 40) {
                        string2 = this.formatHMS(this.YV[this.TD][n]);
                        graphics2D.setTransform(affineTransform);
                        graphics2D.drawString(string2.substring(0, Math.min(string2.length(), string2.indexOf("."))), -this.height + 1, n2 - 1);
                        graphics2D.setTransform((AffineTransform)object);
                        graphics2D.drawLine(n2, 0, n2, this.height);
                    }
                    d13 = d14;
                }
            }
            if (this.isSeismic) {
                graphics2D.setColor(Color.black);
                this.seismicScale = (double)this.height / ((double)this.SR * 2.0);
                n6 = (int)this.convertSeismometerToGraphY(this.SV[1][0]);
                n8 = (int)((double)this.height - this.SStD[0] * this.seismicScale * 10.0);
                int n9 = 1;
                double d26 = 0.0;
                d14 = 0.0;
                for (int i = 1; i < this.sIndex; ++i) {
                    if (this.SV[0][i] > this.YV[this.TD][n9]) {
                        if (n9 <= this.yIndex) {
                            ++n9;
                        }
                        d26 = 0.0;
                    }
                    d14 = (this.SV[0][i] - this.SV[0][i - 1]) / (this.YV[this.TD][n9] - this.YV[this.TD][n9 - 1]);
                    d26 += d14;
                    if (!((d26 = Math.min(1.0, d26)) > 0.0)) continue;
                    d24 = this.convertSeismometerToGraphY(this.SV[1][i]);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawLine(n5, n6, (int)(((double)(n9 - 1) + d26) * (double)this.hScale), (int)d24);
                    n5 = (int)(((double)(n9 - 1) + d26) * (double)this.hScale);
                    n6 = (int)d24;
                    d24 = (double)this.height - this.SStD[i] * this.seismicScale * 10.0;
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawLine(n7, n8, (int)(((double)(n9 - 1) + d26) * (double)this.hScale), (int)d24);
                    n7 = (int)(((double)(n9 - 1) + d26) * (double)this.hScale);
                    n8 = (int)d24;
                }
            } else if (this.isDeltaTime) {
                n5 = 0;
                n6 = 0;
                int n10 = 0;
                int n11 = 3;
                this.seismicScale = (double)this.height / ((double)this.SR * 2.0);
                if (this.SNTS) {
                    n11 = 4;
                }
                for (n2 = n11; n2 >= 1; --n2) {
                    string2 = "";
                    switch (n2) {
                        case 1: {
                            this.graphColor = Color.black;
                            if (this.SV[n2][this.yIndex] < 0.0) {
                                string2 = "PC - Mount difference [msec], PC is slow by = " + Math.abs((int)this.SV[n2][this.yIndex]) + "ms, drifting by " + (int)this.DTS + "ms/hour";
                                break;
                            }
                            string2 = "PC - Mount difference [msec], PC is fast by = " + Math.abs((int)this.SV[n2][this.yIndex]) + "ms, drifting by " + (int)this.DTS + "ms/hour";
                            break;
                        }
                        case 2: {
                            this.graphColor = new Color(0, 153, 0);
                            string2 = "PC loop time [msec], average = " + this.SO + "ms";
                            break;
                        }
                        case 3: {
                            this.graphColor = Color.red;
                            string2 = "Mount loop time [msec], average = " + this.SO + "ms";
                            break;
                        }
                        case 4: {
                            this.graphColor = Color.blue;
                            string2 = this.SV[n2][this.yIndex] < 0.0 ? "Difference PC - NIST server time [msec], PC is fast by " + Math.abs((int)this.SV[n2][this.yIndex]) + "ms, drifting by " + (int)this.PCTS + "ms/hour" : "Difference PC - NIST server time [msec], PC is slow by " + Math.abs((int)this.SV[n2][this.yIndex]) + "ms, drifting by " + (int)this.PCTS + "ms/hour";
                        }
                    }
                    graphics2D.setColor(this.graphColor);
                    if (n2 == 2 || n2 == 3) {
                        graphics2D.drawString(this.SO - this.SR + "ms", n2 * 50 - 50, this.height - 6);
                        graphics2D.drawString(this.SO + "ms", n2 * 50 - 50, this.height / 2);
                        graphics2D.drawString(this.SO + this.SR + "ms", n2 * 50 - 50, 12);
                    }
                    graphics2D.drawLine(40, 20 + (n2 - 1) * 15, 100, 20 + (n2 - 1) * 15);
                    graphics2D.drawString(string2, 110, 24 + (n2 - 1) * 15);
                    n10 = n2 == 1 || n2 == 4 ? 0 : this.SO;
                    n5 = 0;
                    n6 = (int)this.convertTimeToGraphY(this.SV[n2][0] - (double)n10);
                    for (int i = 0; i <= this.yIndex; ++i) {
                        d24 = this.convertTimeToGraphY(this.SV[n2][i] - (double)n10);
                        graphics2D.drawLine(n5, n6, i * this.hScale, (int)d24);
                        n5 = i * this.hScale;
                        n6 = (int)d24;
                    }
                }
            } else {
                int n12;
                double d27;
                int n13;
                this.graphColor = this.isRAMode ? Color.magenta : Color.red;
                BasicStroke basicStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
                if (this.showMountAxisSpeed && Math.abs(d6 - d5) < 1000.0) {
                    int n14;
                    n5 = this.mountAxisSpeedDataStartIdx;
                    n6 = 0;
                    graphics2D.setColor(color);
                    n6 = (int)this.convertRaDecToGraphY(this.mountAxisData[0][0], d9, this.RMASDscale);
                    for (n14 = this.mountAxisSpeedDataStartIdx; n14 < this.yIndex; ++n14) {
                        d24 = this.convertRaDecToGraphY(this.mountAxisData[0][n14], d9, this.RMASDscale);
                        graphics2D.drawLine(n5, n6, n14 * this.hScale, (int)d24);
                        n5 = n14 * this.hScale;
                        n6 = (int)d24;
                    }
                    this.xOffsetForRunningRangeLength = this.adjustGraphsForRunningRangeLength ? (int)((double)this.RRRL / 2.0) : 0;
                    n5 = this.mountAxisSpeedDataStartIdx - this.xOffsetForRunningRangeLength;
                    n6 = 0;
                    graphics2D.setColor(Color.black);
                    graphics2D.setStroke(new BasicStroke(2.0f));
                    n6 = (int)this.convertRaDecToGraphY(this.mountAxisData[0][0], d9, this.RMASDscale);
                    for (n14 = this.mountAxisSpeedDataStartIdx; n14 < this.yIndex; ++n14) {
                        d24 = this.convertRaDecToGraphY(this.mountAxisData[1][n14], d9, this.RMASDscale);
                        graphics2D.drawLine(n5, n6, (n14 - this.xOffsetForRunningRangeLength) * this.hScale, (int)d24);
                        n5 = (n14 - this.xOffsetForRunningRangeLength) * this.hScale;
                        n6 = (int)d24;
                    }
                    this.xOffsetForRunningRangeLength = this.adjustGraphsForRunningRangeLength ? (this.showAxialSpeedAsDisplacement ? this.RRL : (int)((double)this.RRL / 2.0)) : 0;
                    n5 = this.mountAxisSpeedDataStartIdx - this.xOffsetForRunningRangeLength;
                    n6 = 0;
                    graphics2D.setColor(Color.black);
                    graphics2D.setStroke(new BasicStroke(3.0f));
                    n6 = (int)this.convertRaDecToGraphY(this.mountAxisData[2][0], d8, this.MASDscale);
                    for (n14 = this.mountAxisSpeedDataStartIdx; n14 < this.yIndex; ++n14) {
                        d24 = this.convertRaDecToGraphY(this.mountAxisData[2][n14], d8, this.MASDscale);
                        graphics2D.drawLine(n5, n6, (n14 - this.xOffsetForRunningRangeLength) * this.hScale, (int)d24);
                        n5 = (n14 - this.xOffsetForRunningRangeLength) * this.hScale;
                        n6 = (int)d24;
                    }
                    graphics2D.setStroke(new BasicStroke(1.0f));
                    graphics2D2.setColor(Color.black);
                    graphics2D2.setStroke(basicStroke);
                    d24 = this.convertRaDecToGraphY(d6, d8, this.MASDscale);
                    graphics2D2.drawLine(0, (int)d24, this.width, (int)d24);
                    object = String.format("%." + this.significance + "f", d6 - d8).replace(",", ".");
                    String string3 = String.format("%." + this.significance + "f", d5 - d8).replace(",", ".");
                    String string4 = String.format("%." + this.significance + "f", (d6 - d8) * Math.cos(Math.toRadians(this.decValueForConversion))).replace(",", ".");
                    String string5 = String.format("%." + this.significance + "f", (d5 - d8) * Math.cos(Math.toRadians(this.decValueForConversion))).replace(",", ".");
                    string = "''";
                    if (((String)object).indexOf("-") == -1) {
                        object = "+" + (String)object;
                    }
                    if (string3.indexOf("-") == -1) {
                        string3 = "+" + string3;
                    }
                    string2 = this.showAxialSpeedAsDisplacement ? "Axial displacement = " + String.format("%." + this.significance + "f", d6).replace(",", ".") + string + " = average (" + String.format("%." + this.significance + "f", d8).replace(",", ".") + string + ") " + (String)object + string + " = " + string4 + string + "SPH" : "Axial speed = " + String.format("%." + this.significance + "f", d6).replace(",", ".") + string + "/s = median (" + String.format("%." + this.significance + "f", d8).replace(",", ".") + string + "/s) " + (String)object + string + "/s";
                    this.yCorrection = d24 < 12.0 ? 11.0 : -3.0;
                    graphics2D2.drawString(string2, 255, (int)(d24 + this.yCorrection));
                    d24 = this.convertRaDecToGraphY(d5, d8, this.MASDscale);
                    graphics2D2.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = this.showAxialSpeedAsDisplacement ? "Axial displacement = " + String.format("%." + this.significance + "f", d5).replace(",", ".") + string + " = average (" + String.format("%." + this.significance + "f", d8).replace(",", ".") + string + ") " + string3 + string + " = " + string5 + string + "SPH" : "Axial speed = " + String.format("%." + this.significance + "f", d5).replace(",", ".") + string + "/s = median (" + String.format("%." + this.significance + "f", d8).replace(",", ".") + string + "/s) " + string3 + string + "/s";
                    this.yCorrection = d24 < (double)this.height - 10.0 ? 11.0 : -3.0;
                    graphics2D.drawString(string2, 255, (int)(d24 + this.yCorrection));
                }
                n5 = 0;
                n6 = 0;
                graphics2D.setColor(this.graphColor);
                n6 = (int)this.convertRaDecToGraphY(this.YV[this.DS][0], this.average, this.scale);
                for (int i = 0; i <= this.yIndex; ++i) {
                    d24 = this.convertRaDecToGraphY(this.YV[this.DS][i], this.average, this.scale);
                    graphics2D.drawLine(n5, n6, i * this.hScale, (int)d24);
                    n5 = i * this.hScale;
                    n6 = (int)d24;
                }
                graphics2D2.setColor(this.graphColor);
                graphics2D2.setStroke(basicStroke);
                d24 = this.convertRaDecToGraphY(this.MaxYV[this.DS], this.average, this.scale);
                graphics2D2.drawLine(0, (int)d24, this.width, (int)d24);
                String string6 = String.format("%.2f", (this.MaxYV[this.DS] - this.average) * 3600.0).replace(",", ".");
                String string7 = String.format("%.2f", (this.MinYV[this.DS] - this.average) * 3600.0).replace(",", ".");
                string = this.isRAMode ? "s" : "''";
                if (string6.indexOf("-") == -1) {
                    string6 = "+" + string6;
                }
                if (string7.indexOf("-") == -1) {
                    string7 = "+" + string7;
                }
                string2 = this.theReferenceType == 0 ? "" + this.formatHMS(this.MaxYV[this.DS]) + " = median " + string6 + string : "" + this.formatHMS(this.MaxYV[this.DS]) + " = target (" + this.formatHMS(this.theReferences[this.DS]) + ") " + string6 + string;
                this.yCorrection = d24 < 12.0 ? 11.0 : -1.0;
                graphics2D2.drawString(string2, 75, (int)(d24 + this.yCorrection));
                d24 = this.convertRaDecToGraphY(this.MinYV[this.DS], this.average, this.scale);
                graphics2D2.drawLine(0, (int)d24, this.width, (int)d24);
                string2 = this.theReferenceType == 0 ? "" + this.formatHMS(this.MinYV[this.DS]) + " = median " + string7 + string : "" + this.formatHMS(this.MinYV[this.DS]) + " = target (" + this.formatHMS(this.theReferences[this.DS]) + ") " + string7 + string;
                this.yCorrection = d24 < (double)this.height - 12.0 ? 11.0 : -1.0;
                graphics2D.drawString(string2, 75, (int)(d24 + this.yCorrection));
                String string8 = "";
                if (this.toleranceRD > 0.0) {
                    graphics2D.setColor(new Color(0, 153, 0));
                    if (this.isRAMode) {
                        if (this.useAsHATolerance) {
                            string8 = this.toleranceRDorg < 2.0 ? String.format("%.2f", this.toleranceRDorg).replace(",", ".") + "s" : String.format("%.0f", this.toleranceRDorg).replace(",", ".") + "s";
                        } else {
                            string8 = this.toleranceRD < 2.0 ? String.format("%.2f", this.toleranceRD).replace(",", ".") + "s" : String.format("%.0f", this.toleranceRD).replace(",", ".") + "s";
                            string8 = this.toleranceRDorg < 2.0 ? string8 + " = " + String.format("%.2f", this.toleranceRDorg).replace(",", ".") + "''" : string8 + " = " + String.format("%.0f", this.toleranceRDorg).replace(",", ".") + "''";
                        }
                    } else {
                        string8 = this.toleranceRD < 2.0 ? String.format("%.2f", this.toleranceRD).replace(",", ".") + "''" : String.format("%.0f", this.toleranceRD).replace(",", ".") + "''";
                    }
                    d24 = this.convertRaDecToGraphY(this.average + this.toleranceRD / 3600.0, this.average, this.scale);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = this.theReferenceType == 0 ? "Upper tolerance = median +" + string8 : "Upper tolerance = " + this.formatHMS(this.theReferences[this.DS] + this.toleranceRD / 3600.0);
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 + 11.0));
                    d24 = this.convertRaDecToGraphY(this.average - this.toleranceRD / 3600.0, this.average, this.scale);
                    graphics2D.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = this.theReferenceType == 0 ? "Lower tolerance = median -" + string8.replace("s = ", "s = -") : "Lower tolerance = " + this.formatHMS(this.theReferences[this.DS] - this.toleranceRD / 3600.0);
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 - 1.0));
                }
                if ((n13 = Math.round((float)(Math.log(this.MSD[this.DS] * 3600.0 * 3.3) / Math.log(10.0)))) < -3) {
                    n13 = -3;
                }
                d17 = 0.0;
                d13 = Math.pow(10.0, n13);
                d16 = Math.pow(10.0, n13 - 1) * 2.0;
                n = Math.max(-(n13 - 1), 0);
                BasicStroke basicStroke2 = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 8.0f}, 0.0f);
                graphics2D.setColor(Color.blue);
                graphics2D2.setStroke(basicStroke2);
                graphics2D2.setColor(Color.blue);
                string = this.isRAMode ? "s" : "''";
                for (d27 = d17; d27 <= d13; d27 += d16) {
                    d15 = (double)this.height - d27 / d13 * (double)this.height;
                    graphics2D2.drawLine((int)((double)this.width * 0.95), (int)d15, this.width, (int)d15);
                    string2 = "" + String.format("%." + n + "f", d27).replace(",", ".") + string;
                    this.yCorrection = d15 < (double)this.height / 2.0 ? 11.0 : -1.0;
                    if (this.yIndex <= 0) continue;
                    graphics2D.drawString(string2, this.width - 25 - 6 * n, (int)(d15 + this.yCorrection));
                }
                this.xOffsetForRunningRangeLength = this.adjustGraphsForRunningRangeLength ? (int)((double)this.RRL / 2.0) : 0;
                d27 = d13;
                graphics2D.setColor(Color.blue);
                n5 = 0 - this.xOffsetForRunningRangeLength;
                n6 = (int)((double)this.height - this.mountStatData[this.DS][0] * 3600.0 / d27 * (double)this.height);
                d24 = 0.0;
                for (n12 = 0; n12 <= this.yIndex; ++n12) {
                    d24 = (double)this.height - this.mountStatData[this.DS][n12] * 3600.0 / d27 * (double)this.height;
                    graphics2D.drawLine(n5, n6, (n12 - this.xOffsetForRunningRangeLength) * this.hScale, (int)d24);
                    n5 = (n12 - this.xOffsetForRunningRangeLength) * this.hScale;
                    n6 = (int)d24;
                }
                if (--n12 > 0) {
                    string = this.isRAMode ? "s" : "''";
                    d24 = (double)this.height - this.mountStatData[this.DS][n12] * 3600.0 / d27 * (double)this.height;
                    string2 = "" + this.mountStatData[this.DS][n12] * 3600.0;
                    string2 = string2.substring(0, Math.min(string2.length(), string2.indexOf(".") + 3)) + string;
                    graphics2D.drawString(string2, (int)((double)(n12 * this.hScale) - 30.0 * ((double)n12 * (double)this.hScale / (double)this.width) - (double)this.xOffsetForRunningRangeLength), (int)(d24 - 1.0));
                }
                if (n12 > 0) {
                    string = this.isRAMode ? "s" : "''";
                    BasicStroke basicStroke3 = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
                    graphics2D2.setColor(Color.blue);
                    graphics2D2.setStroke(basicStroke3);
                    d24 = (double)this.height - this.MSD[this.DS] * 3600.0 / d27 * (double)this.height;
                    graphics2D2.drawLine(0, (int)d24, this.width, (int)d24);
                    string2 = "" + this.MSD[this.DS] * 3600.0;
                    string2 = string2.substring(0, Math.min(string2.length(), string2.indexOf(".") + 3)) + string;
                    string2 = "Maximum of " + this.RRL + " seconds running STDEV: " + string2;
                    this.yCorrection = d24 < (double)this.height / 2.0 ? 11.0 : -1.0;
                    graphics2D.drawString(string2, this.width / 2 - string2.length() * 3, (int)(d24 + this.yCorrection));
                }
            }
        }
        graphics2D2.dispose();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.myimg != null) {
            this.drawGraph((Graphics2D)this.myimg.getGraphics());
            graphics2D.drawImage((Image)this.myimg, 0, 0, this);
        }
    }
}

