/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

class FTPanel
extends Panel {
    public double[][] SD = new double[2][2001];
    public double[][] MD = new double[11][2001];
    public double SF = 20.0;
    public double MF = 5.0;
    public String modeText = "";
    public int sIndex = 0;
    public int mIndex = 0;
    public int raIndex = 0;
    public int decIndex = 0;
    public int width;
    public int height;
    public int scaleBarHeight;
    public int xOffset;
    double minYValS;
    double maxYValS;
    double minYValR;
    double maxYValR;
    double minYValD;
    double maxYValD;
    double minXVal;
    double maxXVal;
    public double hScale;
    public double vScaleS;
    public double vScaleD;
    public double vScaleR;
    double average;
    public Boolean isActive;
    public Boolean stayEmpty;
    public Boolean FFTShowFrequency;
    public BufferedImage myimg;
    public Graphics2D g2d;
    public Font currentFont;
    public Font newFont;
    public int currentFontSize;
    public int newFontSize;
    public Color graphColor;
    public double titleRatio;

    public Boolean isActive() {
        return this.isActive;
    }

    public BufferedImage getImage() {
        return new BufferedImage(this.width, this.height, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, 10);
    }

    public void setActive() {
        this.stayEmpty = false;
        this.isActive = true;
    }

    public void setInActive() {
        this.isActive = false;
    }

    public void shiftHScale(double d) {
        this.xOffset = d < 0.0 ? (int)Math.min(0.0, (double)this.xOffset + 0.1 * (double)this.width) : (int)((double)this.xOffset - 0.1 * (double)this.width);
    }

    public void adjustHScale(double d) {
        this.hScale = d > 0.0 ? (this.hScale *= 1.1) : (d < 0.0 ? (this.FFTShowFrequency.booleanValue() ? Math.max((double)this.width / (Math.max(this.SF, this.MF) / 2.0), this.hScale / 1.1) : Math.max(0.5 * (double)this.width / this.maxXVal, this.hScale / 1.1)) : d);
    }

    public void setSData(double[][] dArray) {
        this.SD = dArray;
    }

    public void setMData(double[][] dArray) {
        this.MD = dArray;
    }

    public void setType(Boolean bl) {
        this.FFTShowFrequency = bl;
    }

    public void setDimension(Dimension dimension) {
        this.width = Math.max(1, dimension.width);
        this.height = Math.max(1, dimension.height);
    }

    public void setImage(Image image) {
        this.myimg = (BufferedImage)image;
        this.repaint();
    }

    public void setSVIndex(int n) {
        this.sIndex = n;
    }

    public void setMVIndex(int n) {
        this.mIndex = n;
    }

    public void setRAIndex(int n) {
        this.raIndex = n;
    }

    public void setDECIndex(int n) {
        this.decIndex = n;
    }

    public void setModeText(String string) {
        this.modeText = string.toUpperCase();
    }

    public void setSeismometerFrequency(double d) {
        this.SF = d;
    }

    public void setMountFrequency(double d) {
        this.MF = d;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public FTPanel(int n, int n2, Color color) {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.scaleBarHeight = 20;
        this.xOffset = 0;
        this.minYValS = 1.0E9;
        this.maxYValS = -1.0E9;
        this.minYValR = 1.0E9;
        this.maxYValR = -1.0E9;
        this.minYValD = 1.0E9;
        this.maxYValD = -1.0E9;
        this.minXVal = 0.0;
        this.maxXVal = -1.0;
        this.hScale = 0.0;
        this.vScaleS = 1.0;
        this.vScaleD = 1.0;
        this.vScaleR = 1.0;
        this.isActive = false;
        this.stayEmpty = true;
        this.FFTShowFrequency = false;
        this.myimg = null;
        this.g2d = null;
        this.titleRatio = 0.004477611940298508;
        this.setLayout(null);
        this.setSize(n, n2);
        this.setForeground(color);
        this.setBackground(Color.gray);
        this.width = Math.max(1, n);
        this.height = Math.max(1, n2);
        this.myimg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
    }

    public static Complex[] fft(Complex[] complexArray) {
        int n = complexArray.length;
        if (n == 1) {
            return new Complex[]{complexArray[0]};
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("n is not a power of 2");
        }
        Complex[] complexArray2 = new Complex[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            complexArray2[i] = complexArray[2 * i];
        }
        Complex[] complexArray3 = FTPanel.fft(complexArray2);
        Complex[] complexArray4 = complexArray2;
        for (int i = 0; i < n / 2; ++i) {
            complexArray4[i] = complexArray[2 * i + 1];
        }
        Complex[] complexArray5 = FTPanel.fft(complexArray4);
        Complex[] complexArray6 = new Complex[n];
        for (int i = 0; i < n / 2; ++i) {
            double d = (double)(-2 * i) * Math.PI / (double)n;
            Complex complex = new Complex(Math.cos(d), Math.sin(d));
            complexArray6[i] = complexArray3[i].plus(complex.times(complexArray5[i]));
            complexArray6[i + n / 2] = complexArray3[i].minus(complex.times(complexArray5[i]));
        }
        return complexArray6;
    }

    public void centreString(Graphics graphics, String string, Font font) {
        try {
            Rectangle rectangle = new Rectangle(this.width, this.height);
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            int n = (int)Math.round(rectangle2D.getWidth());
            int n2 = (int)Math.round(rectangle2D.getHeight());
            int n3 = (int)Math.round(rectangle2D.getX());
            int n4 = (int)Math.round(rectangle2D.getY());
            int n5 = rectangle.width / 2 - n / 2 - n3;
            int n6 = rectangle.height / 2 - n2 / 2 - n4;
            graphics.setFont(font);
            graphics.drawString(string, rectangle.x + n5, rectangle.y + n6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double convertSeismometerToGraphY(double d, double d2) {
        return (double)this.height - (double)this.scaleBarHeight - d * d2;
    }

    public double convertSeismometerToGraphX(double d) {
        return d * this.hScale + (double)this.xOffset;
    }

    public void drawGraph(Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.width * this.height < 0) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        int n5 = (int)Math.floor(Math.log(this.sIndex) / Math.log(2.0));
        int n6 = (int)Math.pow(2.0, n5);
        n5 = (int)Math.floor(Math.log(this.mIndex) / Math.log(2.0));
        int n7 = (int)Math.pow(2.0, n5);
        Complex[] complexArray = null;
        Complex[] complexArray2 = null;
        Complex[] complexArray3 = null;
        if (n6 > 1 || n7 > 1) {
            int n8;
            Object object;
            if (n6 > 1) {
                object = new Complex[n6];
                for (n8 = this.sIndex - 1; n8 >= this.sIndex - n6; --n8) {
                    object[n8 - (this.sIndex - n6)] = new Complex(this.SD[1][n8], 0.0);
                }
                complexArray = FTPanel.fft((Complex[])object);
                d = this.FFTShowFrequency != false ? this.SF / (double)n6 : 1.0 / (this.SF / (double)n6);
            }
            if (n7 > 1) {
                object = new Complex[n7];
                for (n8 = this.mIndex - 1; n8 >= this.mIndex - n7; --n8) {
                    object[n8 - (this.mIndex - n7)] = new Complex(this.MD[this.raIndex][n8], 0.0);
                }
                Complex[] complexArray4 = new Complex[n7];
                for (int i = this.mIndex - 1; i >= this.mIndex - n7; --i) {
                    complexArray4[i - (this.mIndex - n7)] = new Complex(this.MD[this.decIndex][i], 0.0);
                }
                complexArray2 = FTPanel.fft((Complex[])object);
                complexArray3 = FTPanel.fft(complexArray4);
                d2 = this.FFTShowFrequency != false ? this.MF / (double)n7 : 1.0 / (this.MF / (double)n7);
            }
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.width, this.height);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, this.width, this.height);
            this.currentFont = graphics2D.getFont();
            this.currentFontSize = this.currentFont.getSize();
            this.newFont = this.currentFont.deriveFont((int)((float)this.currentFontSize * 6.0f));
            graphics2D.setFont(this.newFont);
            object = new HashMap();
            object.put(TextAttribute.FAMILY, this.currentFont.getFamily());
            object.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
            object.put(TextAttribute.SIZE, (int)((double)this.currentFont.getSize() * 2.0 * this.titleRatio * (double)this.width));
            this.newFont = Font.getFont(object);
            this.newFontSize = this.newFont.getSize();
            graphics2D.setFont(this.newFont);
            graphics2D.setColor(new Color(240, 240, 240));
            this.centreString(graphics2D, this.modeText, this.newFont);
            graphics2D.setFont(this.currentFont);
            if (!this.stayEmpty.booleanValue()) {
                int n9;
                double d4;
                double d5;
                String string;
                int n10;
                this.minXVal = 0.0;
                n = 1;
                n2 = n6 / 2;
                n3 = 1;
                n4 = n7 / 2;
                this.minYValS = 1.0E9;
                this.maxYValS = -1.0E9;
                this.minYValR = 1.0E9;
                this.maxYValR = -1.0E9;
                this.minYValD = 1.0E9;
                this.maxYValD = -1.0E9;
                if (n6 > 1) {
                    for (n8 = 1; n8 < n6 / 2; ++n8) {
                        if (complexArray[n8].abs() > this.maxYValS) {
                            this.maxYValS = complexArray[n8].abs();
                        }
                        if (!(complexArray[n8].abs() < this.minYValS)) continue;
                        this.minYValS = complexArray[n8].abs();
                    }
                    this.maxYValS *= 1.1;
                    this.vScaleS = (double)(this.height - this.scaleBarHeight) / (this.maxYValS - this.minYValS);
                    for (n8 = 1; n8 < n6 / 2; ++n8) {
                        if (complexArray[n8].abs() - this.minYValS > (this.maxYValS - this.minYValS) / 10.0 && n == 1) {
                            n = n8;
                        }
                        if (!(complexArray[n8].abs() - this.minYValS > (this.maxYValS - this.minYValS) / 10.0)) continue;
                        n2 = n8;
                    }
                }
                if (n7 > 1) {
                    for (n8 = 1; n8 < n7 / 2; ++n8) {
                        if (complexArray2[n8].abs() > this.maxYValR) {
                            this.maxYValR = complexArray2[n8].abs();
                        }
                        if (complexArray2[n8].abs() < this.minYValR) {
                            this.minYValR = complexArray2[n8].abs();
                        }
                        if (complexArray3[n8].abs() > this.maxYValD) {
                            this.maxYValD = complexArray3[n8].abs();
                        }
                        if (!(complexArray3[n8].abs() < this.minYValD)) continue;
                        this.minYValD = complexArray3[n8].abs();
                    }
                    this.maxYValD *= 1.1;
                    this.maxYValR *= 1.1;
                    this.vScaleD = (double)(this.height - this.scaleBarHeight) / (this.maxYValD - this.minYValD);
                    this.vScaleR = (double)(this.height - this.scaleBarHeight) / (this.maxYValR - this.minYValR);
                    for (n8 = 1; n8 < n7 / 2; ++n8) {
                        if (complexArray2[n8].abs() - this.minYValR > (this.maxYValR - this.minYValR) / 10.0 && n3 == 1) {
                            n3 = n8;
                        }
                        if (complexArray2[n8].abs() - this.minYValR > (this.maxYValR - this.minYValR) / 10.0) {
                            n4 = n8;
                        }
                        if (complexArray3[n8].abs() - this.minYValD > (this.maxYValD - this.minYValD) / 10.0 && n3 == 1) {
                            n3 = n8;
                        }
                        if (!(complexArray3[n8].abs() - this.minYValD > (this.maxYValD - this.minYValD) / 10.0)) continue;
                        n4 = n8;
                    }
                }
                this.maxXVal = this.FFTShowFrequency != false ? Math.max(d * (double)n2, d2 * (double)n4) * 1.1 : Math.max(d / (double)n, d2 / (double)n3) * 1.1;
                this.maxXVal = Math.max(1.0, this.maxXVal);
                if (this.hScale == 0.0) {
                    this.hScale = (double)this.width / (this.maxXVal - this.minXVal);
                }
                double d6 = this.maxXVal - this.minXVal;
                int n11 = Math.round((float)(Math.log(this.hScale / (double)this.width) * 1.3 / Math.log(10.0)));
                if (n11 > 0) {
                    n11 = 0;
                }
                double d7 = 1.0 / Math.pow(10.0, n11 + 1);
                if (d6 > 0.0) {
                    graphics2D.setColor(new Color(200, 200, 200));
                    AffineTransform affineTransform = new AffineTransform();
                    AffineTransform affineTransform2 = graphics2D.getTransform();
                    graphics2D.setColor(Color.gray);
                    affineTransform.rotate(-1.5707963267948966);
                    n10 = 0;
                    double d8 = 0.0;
                    double d9 = 999.0;
                    for (double d10 = 0.0; d10 < d7 * 40.0; d10 += d7) {
                        n10 = (int)this.convertSeismometerToGraphX(d10);
                        string = String.format("%.1f", d10);
                        graphics2D.setTransform(affineTransform);
                        graphics2D.drawString(string, -this.height + 1, n10 - 1);
                        graphics2D.setTransform(affineTransform2);
                        graphics2D.drawLine(n10, 0, n10, this.height);
                    }
                    graphics2D.drawLine(0, this.height - this.scaleBarHeight, this.width, this.height - this.scaleBarHeight);
                }
                int n12 = 0;
                int n13 = 0;
                n10 = 1;
                if (n6 > 1) {
                    graphics2D.setColor(Color.black);
                    string = String.format("%15s", String.format("%.1f", this.SF) + "Hz");
                    graphics2D.drawString(string, this.width - 70, 30);
                    for (int i = n10; i < n6 / 2; ++i) {
                        d5 = this.convertSeismometerToGraphY(complexArray[i].abs(), this.vScaleS);
                        d4 = this.FFTShowFrequency != false ? this.convertSeismometerToGraphX(d * (double)i) : this.convertSeismometerToGraphX(d / (double)i);
                        if (i > n10) {
                            graphics2D.drawLine(n12, n13, (int)d4, (int)d5);
                        }
                        n12 = (int)d4;
                        n13 = (int)d5;
                    }
                }
                n12 = 0;
                n13 = 0;
                graphics2D.setColor(Color.red);
                string = String.format("%15s", String.format("%.1f", this.MF) + "Hz");
                graphics2D.drawString(string, this.width - 70, 10);
                for (n9 = n10; n9 < n7 / 2; ++n9) {
                    d5 = this.convertSeismometerToGraphY(complexArray3[n9].abs(), this.vScaleD);
                    d4 = this.FFTShowFrequency != false ? this.convertSeismometerToGraphX(d2 * (double)n9) : this.convertSeismometerToGraphX(d2 / (double)n9);
                    if (n9 > n10) {
                        graphics2D.drawLine(n12, n13, (int)d4, (int)d5);
                    }
                    n12 = (int)d4;
                    n13 = (int)d5;
                }
                n12 = 0;
                n13 = 0;
                graphics2D.setColor(Color.magenta);
                string = String.format("%15s", String.format("%.1f", this.MF) + "Hz");
                graphics2D.drawString(string, this.width - 70, 20);
                for (n9 = n10; n9 < n7 / 2; ++n9) {
                    d5 = this.convertSeismometerToGraphY(complexArray2[n9].abs(), this.vScaleR);
                    d4 = this.FFTShowFrequency != false ? this.convertSeismometerToGraphX(d2 * (double)n9) : this.convertSeismometerToGraphX(d2 / (double)n9);
                    if (n9 > n10) {
                        graphics2D.drawLine(n12, n13, (int)d4, (int)d5);
                    }
                    n12 = (int)d4;
                    n13 = (int)d5;
                }
            }
            graphics2D2.dispose();
        }
    }

    public void paint(Graphics2D graphics2D) {
        try {
            if (this.myimg != null) {
                this.drawGraph((Graphics2D)this.myimg.getGraphics());
                graphics2D.drawImage((Image)this.myimg, 0, 0, this);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

