/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.PaddingException;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.compress.CompressionManager;
import nom.tam.fits.utilities.FitsCheckSum;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import nom.tam.util.RandomAccess;
import nom.tam.util.SafeClose;

public class Fits
implements Closeable {
    private static final Logger LOG = Logger.getLogger(Fits.class.getName());
    private ArrayDataInput dataStr;
    private final List<BasicHDU<?>> hduList = new ArrayList();
    private boolean atEOF;
    private long lastFileOffset = -1L;

    public Fits() {
    }

    public Fits(File myFile) throws FitsException {
        this(myFile, CompressionManager.isCompressed(myFile));
    }

    public Fits(File myFile, boolean compressed) throws FitsException {
        this.fileInit(myFile, compressed);
    }

    public Fits(InputStream str) throws FitsException {
        this.streamInit(str);
    }

    @Deprecated
    public Fits(InputStream str, boolean compressed) throws FitsException {
        this(str);
        LOG.log(Level.INFO, "compression ignored, will be autodetected. was set to " + compressed);
    }

    public Fits(String filename) throws FitsException {
        this(filename, CompressionManager.isCompressed(filename));
    }

    public Fits(String filename, boolean compressed) throws FitsException {
        if (filename == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        try {
            File fil = new File(filename);
            if (fil.exists()) {
                this.fileInit(fil, compressed);
                return;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "not a file " + filename, e);
        }
        try {
            InputStream str = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
            if (str != null) {
                this.streamInit(str);
                return;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "not a resource " + filename, e);
        }
        try {
            InputStream is = FitsUtil.getURLStream(new URL(filename), 0);
            this.streamInit(is);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "not a url " + filename, e);
            throw new FitsException("could not detect type of " + filename);
        }
    }

    public Fits(URL myURL) throws FitsException {
        try {
            this.streamInit(FitsUtil.getURLStream(myURL, 0));
        }
        catch (IOException e) {
            throw new FitsException("Unable to open input from URL:" + myURL, e);
        }
    }

    @Deprecated
    public Fits(URL myURL, boolean compressed) throws FitsException {
        this(myURL);
        LOG.log(Level.INFO, "compression ignored, will be autodetected. was set to " + compressed);
    }

    public static <DataClass extends Data> BasicHDU<DataClass> makeHDU(DataClass data) throws FitsException {
        Header hdr = new Header();
        data.fillHeader(hdr);
        return FitsFactory.hduFactory(hdr, data);
    }

    public static BasicHDU<?> makeHDU(Header h) throws FitsException {
        Data d = FitsFactory.dataFactory(h);
        return FitsFactory.hduFactory(h, d);
    }

    public static BasicHDU<?> makeHDU(Object o) throws FitsException {
        return FitsFactory.hduFactory(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String version() {
        Properties props = new Properties();
        InputStream versionProperties = null;
        try {
            versionProperties = Fits.class.getResourceAsStream("/META-INF/maven/gov.nasa.gsfc.heasarc/nom-tam-fits/pom.properties");
            props.load(versionProperties);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "reading version failed, ignoring", e);
            String string = "unknown";
            return string;
        }
        finally {
            Fits.saveClose(versionProperties);
        }
    }

    public static void saveClose(InputStream in) {
        SafeClose.close(in);
    }

    public void addHDU(BasicHDU<?> myHDU) throws FitsException {
        this.insertHDU(myHDU, this.getNumberOfHDUs());
    }

    @Deprecated
    public int currentSize() {
        return this.getNumberOfHDUs();
    }

    public void deleteHDU(int n) throws FitsException {
        int size = this.getNumberOfHDUs();
        if (n < 0 || n >= size) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        this.hduList.remove(n);
        if (n == 0 && size > 1) {
            BasicHDU<?> newFirst = this.hduList.get(0);
            if (newFirst.canBePrimary()) {
                newFirst.setPrimaryHDU(true);
            } else {
                this.insertHDU(BasicHDU.getDummyHDU(), 0);
            }
        }
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="stream stays open, and will be read when nessesary.")
    protected void fileInit(File myFile, boolean compressed) throws FitsException {
        try {
            if (compressed) {
                this.streamInit(new FileInputStream(myFile));
            } else {
                this.randomInit(myFile);
            }
        }
        catch (IOException e) {
            throw new FitsException("Unable to create Input Stream from File: " + myFile, e);
        }
    }

    public BasicHDU<?> getHDU(int n) throws FitsException, IOException {
        int size;
        for (int i = size = this.getNumberOfHDUs(); i <= n; ++i) {
            BasicHDU<?> hdu = this.readHDU();
            if (hdu != null) continue;
            return null;
        }
        return this.hduList.get(n);
    }

    public int getNumberOfHDUs() {
        return this.hduList.size();
    }

    public ArrayDataInput getStream() {
        return this.dataStr;
    }

    public void insertHDU(BasicHDU<?> myHDU, int position) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (position < 0 || position > this.getNumberOfHDUs()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + position);
        }
        try {
            if (position == 0) {
                if (this.getNumberOfHDUs() > 0) {
                    this.hduList.get(0).setPrimaryHDU(false);
                }
                if (myHDU.canBePrimary()) {
                    myHDU.setPrimaryHDU(true);
                    this.hduList.add(0, myHDU);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                    myHDU.setPrimaryHDU(false);
                    this.hduList.add(1, myHDU);
                }
            } else {
                myHDU.setPrimaryHDU(false);
                this.hduList.add(position, myHDU);
            }
        }
        catch (NoSuchElementException e) {
            throw new FitsException("hduList inconsistency in insertHDU", e);
        }
    }

    protected void randomInit(File file) throws FitsException {
        String permissions = "r";
        if (!file.exists() || !file.canRead()) {
            throw new FitsException("Non-existent or unreadable file");
        }
        if (file.canWrite()) {
            permissions = permissions + "w";
        }
        try {
            this.dataStr = new BufferedFile(file, permissions);
            ((BufferedFile)this.dataStr).seek(0L);
        }
        catch (IOException e) {
            throw new FitsException("Unable to open file " + file.getPath(), e);
        }
    }

    public BasicHDU<?>[] read() throws FitsException {
        this.readToEnd();
        int size = this.getNumberOfHDUs();
        if (size == 0) {
            return new BasicHDU[0];
        }
        return this.hduList.toArray(new BasicHDU[size]);
    }

    public void read(InputStream is) throws FitsException {
        this.dataStr = is instanceof ArrayDataInput ? (ArrayDataInput)((Object)is) : new BufferedDataInputStream(is);
        this.read();
    }

    public BasicHDU<?> readHDU() throws FitsException, IOException {
        Header hdr;
        if (this.dataStr == null || this.atEOF) {
            if (this.dataStr == null) {
                LOG.warning("trying to read a hdu, without an input source!");
            }
            return null;
        }
        if (this.dataStr instanceof RandomAccess && this.lastFileOffset > 0L) {
            FitsUtil.reposition(this.dataStr, this.lastFileOffset);
        }
        if ((hdr = Header.readHeader(this.dataStr)) == null) {
            this.atEOF = true;
            return null;
        }
        Data data = hdr.makeData();
        try {
            data.read(this.dataStr);
        }
        catch (PaddingException e) {
            e.updateHeader(hdr);
            throw e;
        }
        this.lastFileOffset = FitsUtil.findOffset(this.dataStr);
        BasicHDU<Data> nextHDU = FitsFactory.hduFactory(hdr, data);
        this.hduList.add(nextHDU);
        return nextHDU;
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (EOFException e) {
                if (FitsFactory.getAllowTerminalJunk() && e.getCause() instanceof TruncatedFileException && this.getNumberOfHDUs() > 0) {
                    this.atEOF = true;
                    return;
                }
                throw new FitsException("IO error: " + e);
            }
            catch (IOException e) {
                throw new FitsException("IO error: " + e);
            }
        }
    }

    public void setChecksum() throws FitsException, IOException {
        for (int i = 0; i < this.getNumberOfHDUs(); ++i) {
            Fits.setChecksum(this.getHDU(i));
        }
    }

    public void setStream(ArrayDataInput stream) {
        this.dataStr = stream;
        this.atEOF = false;
        this.lastFileOffset = -1L;
    }

    @Deprecated
    public int size() throws FitsException {
        this.readToEnd();
        return this.getNumberOfHDUs();
    }

    public void skipHDU() throws FitsException, IOException {
        if (this.atEOF) {
            return;
        }
        Header hdr = new Header(this.dataStr);
        int dataSize = (int)hdr.getDataSize();
        this.dataStr.skipAllBytes(dataSize);
        if (this.dataStr instanceof RandomAccess) {
            this.lastFileOffset = ((RandomAccess)this.dataStr).getFilePointer();
        }
    }

    public void skipHDU(int n) throws FitsException, IOException {
        for (int i = 0; i < n; ++i) {
            this.skipHDU();
        }
    }

    protected void streamInit(InputStream inputStream) throws FitsException {
        this.dataStr = new BufferedDataInputStream(CompressionManager.decompress(inputStream));
    }

    public void write(DataOutput os) throws FitsException {
        ArrayDataOutput obs;
        boolean newOS = false;
        if (os instanceof ArrayDataOutput) {
            obs = (ArrayDataOutput)os;
        } else if (os instanceof DataOutputStream) {
            newOS = true;
            obs = new BufferedDataOutputStream((DataOutputStream)os);
        } else {
            throw new FitsException("Cannot create ArrayDataOutput from class " + os.getClass().getName());
        }
        for (BasicHDU<?> basicHDU : this.hduList) {
            basicHDU.write(obs);
        }
        if (newOS) {
            try {
                obs.flush();
                obs.close();
            }
            catch (IOException e) {
                throw new FitsException("Error flushing/closing the FITS output stream: " + e, e);
            }
        }
        if (obs instanceof BufferedFile) {
            try {
                ((BufferedFile)obs).setLength(((BufferedFile)obs).getFilePointer());
            }
            catch (IOException e) {
                throw new FitsException("Error resizing the FITS output stream: " + e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException, FitsException {
        BufferedFile bf = null;
        try {
            bf = new BufferedFile(file, "rw");
            this.write(bf);
        }
        catch (Throwable throwable) {
            SafeClose.close(bf);
            throw throwable;
        }
        SafeClose.close(bf);
    }

    @Override
    public void close() throws IOException {
        if (this.dataStr != null) {
            this.dataStr.close();
        }
    }

    @Deprecated
    public static void setChecksum(BasicHDU<?> hdu) throws FitsException {
        FitsCheckSum.setChecksum(hdu);
    }

    @Deprecated
    public static long checksum(byte[] data) {
        return FitsCheckSum.checksum(data);
    }
}

