/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;

public class FITSalize
extends Frame {
    static final String sqm_Version = new String("FITSalize v.1.23, 2 April 2022, N. de Hilster");
    static final String sqm_PrefsFileName = new String("FITSalize.ini");
    String sqm_AstapPath = "";
    double sqm_Latitude = 0.0;
    double sqm_Longitude = 0.0;
    String sqm_ExpTimeBase = "";
    char sqm_DecimalSign = (char)46;
    boolean sqm_DisableAberration = false;
    boolean sqm_ExportFailedPlateSolves = true;
    char[] sqm_Rotator = new char[]{'-', '\\', '|', '/'};
    int sqm_RotatorCounter = 0;

    public static void main(String[] stringArray) throws Exception, InterruptedException {
        String string = "Usage: FITSalize {path to FITS}";
        FITSalize fITSalize = new FITSalize();
        if (stringArray.length < 1) {
            System.out.println(string);
            System.exit(0);
        } else {
            fITSalize.startGrab(stringArray[0]);
        }
        System.out.println("RDY2");
    }

    public static void clearConsole() {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
            } else {
                System.out.print("\u001bc");
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    public double makeDecimal(String string) {
        double d = 0.0;
        String[] stringArray = string.split("'");
        String string2 = stringArray[0];
        stringArray = string2.split(" ");
        d = Double.valueOf(stringArray[0]) + Double.valueOf(stringArray[1]) / 60.0 + Double.valueOf(stringArray[2]) / 3600.0;
        return d;
    }

    public String[] getFITSData(String string) {
        String string2 = "2000-01-01 00:00:00.000";
        String string3 = "0";
        String string4 = "-0.0";
        String string5 = "-0.0";
        String string6 = "-0.0";
        String string7 = "-0.0";
        String string8 = "-0.0";
        String string9 = "-0.0";
        String string10 = "-0.0";
        String string11 = "0";
        String string12 = "0";
        String string13 = "0";
        String string14 = "0";
        String string15 = "0";
        double d = 0.0;
        boolean bl = false;
        String[] stringArray = new String[]{string2, string4, string5, string6, string7, string8, string9, string10, string12, string13, string14, string15, string3, "" + bl};
        try {
            Fits fits = new Fits(string);
            try {
                System.out.print(this.sqm_Rotator[this.sqm_RotatorCounter++ % 4] + "\b");
                Header header = fits.getHDU(0).getHeader();
                string2 = "" + header.getStringValue("DATE-OBS");
                if (!string2.equals("null")) {
                    string2.replace("T", " ");
                } else {
                    string2 = "" + header.getDoubleValue("UTC");
                    if (Double.valueOf(string2) > 0.0) {
                        bl = true;
                    }
                }
                string3 = "" + header.getDoubleValue("EXPTIME");
                if (string2.equals("null")) {
                    string3 = "" + header.getDoubleValue("EXPOSURE");
                }
                string6 = "" + header.getDoubleValue("RA");
                string7 = "" + header.getDoubleValue("DEC");
                if (string6.equals("0.0")) {
                    string6 = "" + this.makeDecimal(header.getStringValue("OBJCTRA"));
                }
                if (string7.equals("0.0")) {
                    string7 = "" + this.makeDecimal(header.getStringValue("OBJCTDEC"));
                }
                string4 = "" + header.getDoubleValue("CENTALT");
                string5 = "" + header.getDoubleValue("CENTAZ");
                if (string4.equals("0.0")) {
                    string4 = ("" + header.getStringValue("OBJCTALT")).trim();
                }
                if (string5.equals("0.0")) {
                    string5 = ("" + header.getStringValue("OBJCTAZ")).trim();
                }
                if (string4.equals("null")) {
                    string4 = "0.0";
                }
                if (string5.equals("null")) {
                    string5 = "0.0";
                }
                if ((string8 = "" + header.getDoubleValue("AMBTEMP")).equals("0.0")) {
                    string8 = "" + header.getDoubleValue("AOCAMBT");
                }
                if (string8.equals("0.0")) {
                    string8 = "" + header.getDoubleValue("TEMP");
                }
                if ((string9 = "" + header.getDoubleValue("FOCTEMP")).equals("0.0")) {
                    string9 = "" + header.getDoubleValue("FOCUSTEM");
                }
                if ((string10 = "" + header.getDoubleValue("FOCPOS")).equals("0.0")) {
                    string10 = "" + header.getDoubleValue("FOCUSPOS");
                }
                if ((string12 = "" + header.getDoubleValue("HUMIDITY")).equals("0.0")) {
                    string12 = "" + header.getDoubleValue("HUMID");
                }
                if ((string13 = "" + header.getDoubleValue("PRESSURE")).equals("0.0")) {
                    string13 = "" + header.getDoubleValue("PRESS");
                }
                if (string13.equals("0.0")) {
                    string13 = "" + header.getDoubleValue("AOCBAROM");
                }
                string14 = "" + header.getStringValue("SITELAT");
                string15 = "" + header.getStringValue("SITELON");
                if (string15.equals("null")) {
                    string15 = "" + header.getStringValue("SITELONG");
                }
                string14 = string14.indexOf(" ") != -1 ? "" + this.makeDecimal(string14) : "" + header.getDoubleValue("SITELAT");
                if (string15.indexOf(" ") != -1) {
                    string15 = "" + -this.makeDecimal(string15);
                } else {
                    string15 = "" + -header.getDoubleValue("SITELON");
                    if (string15.equals("-0.0")) {
                        string15 = "" + -header.getDoubleValue("SITELONG");
                    }
                }
                if (!string15.equals("null") && !string14.equals("null")) {
                    this.sqm_Latitude = Double.valueOf(string14);
                    this.sqm_Longitude = Double.valueOf(string15);
                }
                if (bl) {
                    d = header.getDoubleValue("BZERO");
                    if (d == 0.0) {
                        header.addValue("BZERO", 32768L, "Updated by FITSalize");
                        header.rewrite();
                        d = header.getDoubleValue("BZERO");
                        System.out.println("headerBZero set to: " + string11);
                    }
                    string11 = "" + d;
                    try {
                        string2 = "" + (Double.valueOf(string2) + this.JD(1900, 1, -1.0));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                fits.close();
            }
            catch (IOException iOException) {}
        }
        catch (FitsException fitsException) {
            // empty catch block
        }
        stringArray[0] = string2;
        stringArray[1] = string6;
        stringArray[2] = string7;
        stringArray[3] = string4;
        stringArray[4] = string5;
        stringArray[5] = string8;
        stringArray[6] = string9;
        stringArray[7] = string10;
        stringArray[8] = string12;
        stringArray[9] = string13;
        stringArray[10] = string14;
        stringArray[11] = string15;
        stringArray[12] = string3;
        stringArray[13] = "" + bl;
        return stringArray;
    }

    public String[] getList(String string) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = 0;
        try {
            File file = new File(string);
            stringArray = file.list();
            stringArray2 = new String[]{};
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i]);
                if (stringArray[i].toLowerCase().indexOf(".fit") != -1 && stringArray[i].toLowerCase().indexOf(".fitsalize") == -1) {
                    stringArray2 = Arrays.copyOf(stringArray2, n + 1);
                    stringArray2[n] = stringArray[i];
                    ++n;
                    System.out.println(" added ###############");
                    continue;
                }
                System.out.println(" skipped");
            }
            file = null;
            System.out.println("-");
        }
        catch (Exception exception) {
            System.out.println("Tree processing failed ...");
            exception.printStackTrace();
        }
        return stringArray2;
    }

    public String[] getASTAPData(String string) {
        boolean bl = false;
        String string2 = "false";
        String string3 = "0.0";
        String string4 = "0.0";
        String string5 = "0.0";
        String string6 = "0.0";
        String[] stringArray = new String[]{"", "", "", "", ""};
        String string7 = "";
        try {
            string7 = !this.sqm_AstapPath.equals("") ? this.sqm_AstapPath + "\\astap.exe" : "astap.exe";
            File file = new File("ASTAP_Output.ini");
            if (file.exists()) {
                file.delete();
            }
            Thread.sleep(100L);
            System.out.print(this.sqm_Rotator[this.sqm_RotatorCounter++ % 4] + "\b");
            Process process = new ProcessBuilder(string7, "-f", string, "-o", "ASTAP_Output", "-sqm", "810", "-r", "90").start();
            while (!file.exists()) {
                System.out.print(this.sqm_Rotator[this.sqm_RotatorCounter++ % 4] + "\b");
                Thread.sleep(100L);
            }
            System.out.print(this.sqm_Rotator[this.sqm_RotatorCounter++ % 4] + "\b");
            Thread.sleep(100L);
            System.out.print(this.sqm_Rotator[this.sqm_RotatorCounter++ % 4] + "\b");
            int n = 0;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader("ASTAP_Output.ini"));){
                String string8 = bufferedReader.readLine();
                while (string8 != null) {
                    ++n;
                    String[] stringArray2 = string8.split("=");
                    String string9 = stringArray2[0].trim();
                    String string10 = stringArray2[1].trim();
                    if (string9.equals("PLTSOLVD")) {
                        bl = string10.equals("T");
                    }
                    if (string9.equals("CRVAL1")) {
                        string4 = string10;
                    }
                    if (string9.equals("CRVAL2")) {
                        string5 = string10;
                    }
                    if (string9.equals("CROTA2")) {
                        string6 = string10;
                    }
                    if (string9.equals("SQM")) {
                        string3 = string10;
                    }
                    string8 = bufferedReader.readLine();
                }
                string2 = bl ? "1" : "0";
                stringArray[0] = string2;
                stringArray[1] = string4;
                stringArray[2] = string5;
                stringArray[3] = string6;
                stringArray[4] = string3;
                bufferedReader.close();
                file.delete();
                file = new File("ASTAP_Output.wcs");
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return stringArray;
    }

    private String formatHMS(double d) {
        double d2 = 1.0;
        if (d < 0.0) {
            d2 = -1.0;
        }
        d = d * d2 / 15.0;
        int n = (int)Math.floor(Math.floor(d));
        d = (d - (double)n) * 60.0;
        int n2 = (int)Math.floor(d);
        d = (d - (double)n2) * 60.0;
        double d3 = Math.floor(d * 1000.0) / 1000.0;
        return "" + (int)Math.floor(d2 * (double)n) + ":" + n2 + ":" + d3;
    }

    private String formatDMS(double d) {
        String string = "";
        String string2 = "\u00b0";
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        int n2 = (int)Math.floor(d *= (double)n);
        d = (d - (double)n2) * 60.0;
        int n3 = (int)Math.floor(d);
        d = (d - (double)n3) * 60.0;
        double d2 = Math.floor(d * 100.0) / 100.0;
        string = "" + (int)Math.floor(n * n2) + string2 + n3 + "'" + d2 + "\"";
        return string;
    }

    private double getLHA(double d, double d2, double d3) {
        double[] dArray = this.getApparentSiderealTime(d);
        double d4 = dArray[0] - d2 - d3;
        return d4;
    }

    private double[] getApparentSiderealTime(double d) {
        boolean bl = false;
        double d2 = this.getMeanSiderealTime(d);
        double d3 = 0.0;
        double d4 = this.getMeanObliquity(d);
        double d5 = this.getNutation(d)[0];
        double[] dArray = new double[]{0.0, 0.0};
        if (bl) {
            System.out.println("mst = " + d2 + " " + this.formatHMS(d2));
        }
        if (bl) {
            System.out.println("psie = " + d5);
        }
        if (bl) {
            System.out.println("eta = " + d4 + " " + this.formatDMS(d4));
        }
        if (bl) {
            System.out.println("cor = " + d5 / 15.0 * Math.cos(Math.toRadians(d4)));
        }
        dArray[0] = d3 = d2 + d5 / 15.0 * Math.cos(Math.toRadians(d4)) * 15.0;
        dArray[1] = d2;
        if (bl) {
            System.out.println("AST = " + dArray[0] + " " + this.formatHMS(dArray[0]));
        }
        if (bl) {
            System.out.println("MST = " + dArray[1] + " " + this.formatHMS(dArray[1]));
        }
        return dArray;
    }

    private double getMeanSiderealTime(double d) {
        boolean bl = false;
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = 280.46061837 + 360.98564736629 * (d - 2451545.0) + 3.87933E-4 * d2 * d2 - d2 * d2 * d2 / 3.871E7;
        if (bl) {
            System.out.println("MST = " + d3);
        }
        if ((d3 %= 360.0) < 0.0) {
            d3 += 360.0;
        }
        if (bl) {
            System.out.println("MST = " + d3 + " " + this.formatDMS(d3));
        }
        if (bl) {
            System.out.println("MST = " + d3 + " " + this.formatHMS(d3));
        }
        return d3;
    }

    private double JD(int n, int n2, double d) {
        boolean bl = false;
        if (n2 == 1 || n2 == 2) {
            --n;
            n2 += 12;
        }
        int n3 = (int)((double)n / 100.0);
        int n4 = 2 - n3 + (int)((double)n3 / 4.0);
        if ((double)n + (double)n2 / 12.0 < 1582.8333) {
            n4 = 0;
        }
        double d2 = (double)((int)(365.25 * ((double)n + 4716.0)) + (int)(30.6001 * ((double)n2 + 1.0))) + d + (double)n4 - 1524.5;
        if (bl) {
            System.out.println("JD = " + d2);
        }
        return d2;
    }

    private double JDE(double d) {
        boolean bl = false;
        double d2 = d + this.getDeltaT(d);
        if (bl) {
            System.out.println("JDE = " + d2);
        }
        return d2;
    }

    private double getDeltaT(double d) {
        int n = 0;
        double d2 = 0.0;
        double d3 = 2000.0 + (d - 2451544.5) / 365.25;
        n = (int)Math.floor(d3);
        if ((double)n >= 2016.0 && (double)n <= 2020.0) {
            double d4 = d3 - 2016.0;
            d2 = 68.3 + d4 * 0.54;
        } else if ((double)n >= 2021.0 && (double)n <= 2024.0) {
            double d5 = d3 - 2021.0;
            d2 = 71.0 + d5 * 0.5;
        } else if ((double)n >= 2025.0 && (double)n <= 2049.0) {
            double d6 = d3 - 2000.0;
            d2 = 61.46 + d6 * (0.32217 + d6 * 0.005589);
        } else if ((double)n >= 2050.0 && (double)n <= 2149.0) {
            double d7 = (d3 - 1820.0) / 100.0;
            double d8 = 2150.0 - d3;
            d2 = -20.0 + 32.0 * d7 * d7 - 0.5788 * d8;
        } else if ((double)n >= 2150.0 && (double)n <= 2999.0) {
            double d9 = (d3 - 1820.0) / 100.0;
            d2 = -20.0 + 32.0 * d9 * d9;
        }
        return d2 /= 86400.0;
    }

    private double getRefraction(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d != 0.0 && d2 != 0.0) {
            d4 = 1.0 / Math.tan(Math.toRadians(d + 7.31 / (d + 4.4)));
            d4 += -0.06 * Math.sin(Math.toRadians(14.7 * d4 + 13.0));
            d5 = d2 / 1010.0 * 283.0 / (273.0 + d3);
            d6 = d4 * d5 / 60.0;
        } else {
            d6 = 0.0;
        }
        return d6;
    }

    private double[] getAltAzi(double d, double d2, double d3, double d4, double d5) {
        boolean bl = false;
        double d6 = 23.934469583333332;
        double d7 = 24.0 + (24.0 - d6);
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double d8 = this.getLHA(d, this.sqm_Longitude, d2);
        if (d8 < 0.0) {
            d8 += 360.0;
        }
        double d9 = Math.toDegrees(Math.asin(Math.cos(Math.toRadians(d8)) * Math.cos(Math.toRadians(this.sqm_Latitude)) * Math.cos(Math.toRadians(d3)) + Math.sin(Math.toRadians(this.sqm_Latitude)) * Math.sin(Math.toRadians(d3))));
        double d10 = this.getRefraction(d9, d4, d5);
        d9 += d10;
        double d11 = Math.toDegrees(Math.atan2(Math.sin(Math.toRadians(d8)), Math.cos(Math.toRadians(d8)) * Math.sin(Math.toRadians(this.sqm_Latitude)) - Math.tan(Math.toRadians(d3)) * Math.cos(Math.toRadians(this.sqm_Latitude)))) + 180.0;
        if (bl) {
            System.out.println("latitude = " + this.sqm_Latitude);
        }
        if (bl) {
            System.out.println("longitude = " + this.sqm_Longitude);
        }
        if (bl) {
            System.out.println("pressure = " + d4);
        }
        if (bl) {
            System.out.println("temperature = " + d5);
        }
        if (bl) {
            System.out.println("LHA = " + d8);
        }
        if (bl) {
            System.out.println("altitude = " + d9 + " " + this.formatDMS(d9));
        }
        if (bl) {
            System.out.println("azimuth = " + d11 + " " + this.formatDMS(d11));
        }
        dArray[0] = d9;
        dArray[1] = d11;
        dArray[2] = d8;
        dArray[3] = d10;
        return dArray;
    }

    private double getMeanObliquity(double d) {
        boolean bl = false;
        double d2 = 0.0;
        double d3 = (d - 2451545.0) / 36525.0;
        d2 = 23.43929111111111 + (-46.815 * d3 - 5.9E-4 * d3 * d3 + 0.001813 * d3 * d3 * d3) / 3600.0;
        if (bl) {
            System.out.println("eb 23.43929111111111");
        }
        if (bl) {
            System.out.println("de " + (-46.815 * d3 - 5.9E-4 * d3 * d3 + 0.001813 * d3 * d3 * d3) / 3600.0);
        }
        if (bl) {
            System.out.println("T0 " + d3);
        }
        if (bl) {
            System.out.println("e0 " + d2);
        }
        return d2;
    }

    private double[] getDeltaNutation(double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        boolean bl = false;
        double[] dArray2 = this.getNutation(d);
        double d4 = dArray2[0];
        double d5 = dArray2[1];
        double d6 = this.getMeanObliquity(d);
        double d7 = d6 + d5;
        if (bl) {
            System.out.println("Obliquity: epsilon0=" + d6 + " epsilon=" + d7);
        }
        double d8 = (Math.cos(Math.toRadians(d7)) + Math.sin(Math.toRadians(d7)) * Math.sin(Math.toRadians(d2)) * Math.tan(Math.toRadians(d3))) * d4 - Math.cos(Math.toRadians(d2)) * Math.tan(Math.toRadians(d3)) * d5;
        double d9 = Math.sin(Math.toRadians(d7)) * Math.cos(Math.toRadians(d2)) * d4 + Math.sin(Math.toRadians(d2)) * d5;
        dArray[0] = d8;
        dArray[1] = d9;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray[4] = d6;
        dArray[5] = d7;
        return dArray;
    }

    private double[] getRaDecJNow(double d, double d2, double d3) {
        boolean bl = false;
        if (bl) {
            System.out.println("J2000 RA " + d2 + " DEC " + d3);
        }
        if (bl) {
            System.out.println("J2000 RA " + this.formatHMS(d2) + " DEC " + this.formatDMS(d3));
        }
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double d4 = (d - 2451545.0) / 36525.0;
        double[] dArray2 = this.getPrecession(d, d2, d3);
        double d5 = dArray2[0];
        double d6 = dArray2[1];
        if (bl) {
            System.out.println("Standard precession RA " + d5 + " DEC " + d6);
        }
        if (bl) {
            System.out.println("Standard precession RA " + this.formatHMS(d5) + " DEC " + this.formatDMS(d6));
        }
        double[] dArray3 = this.getDeltaNutation(d, d5, d6);
        double d7 = dArray3[0];
        double d8 = dArray3[1];
        double d9 = dArray3[2];
        double d10 = dArray3[3];
        double d11 = dArray3[4];
        double d12 = dArray3[5];
        if (bl) {
            System.out.println("Nutation: deltaPsie=" + d9 + " deltaEpsilon=" + d10);
        }
        if (bl) {
            System.out.println("Nutation: deltaPsie=" + this.formatDMS(d9) + " deltaEpsilon=" + this.formatDMS(d10));
        }
        if (bl) {
            System.out.println("Obliquity: epsilon0=" + d11 + " epsilon=" + d12);
        }
        if (bl) {
            System.out.println("deltaRA1: " + this.formatHMS(d7 * 15.0));
        }
        if (bl) {
            System.out.println("deltaDEC1: " + this.formatDMS(d8));
        }
        double[] dArray4 = this.getDeltaAberration(d, d5, d6, d12);
        double d13 = dArray4[0];
        double d14 = dArray4[1];
        if (bl) {
            System.out.println("deltaRA2: " + this.formatHMS(d13 * 15.0));
        }
        if (bl) {
            System.out.println("deltaDEC2: " + this.formatDMS(d14));
        }
        if (bl) {
            System.out.println("RA JNOW: " + (d5 + d7 + d13));
        }
        if (bl) {
            System.out.println("DEC JNOW: " + (d6 + d8 + d14));
        }
        if (bl) {
            System.out.println("RA JNOW: " + this.formatHMS(d5 + d7 + d13));
        }
        if (bl) {
            System.out.println("DEC JNOW: " + this.formatDMS(d6 + d8 + d14));
        }
        dArray[0] = d5 + d7 + d13;
        dArray[1] = d6 + d8 + d14;
        dArray[2] = d5;
        dArray[3] = d6;
        dArray[4] = d7;
        dArray[5] = d8;
        dArray[6] = d13;
        dArray[7] = d14;
        dArray[8] = d9;
        dArray[9] = d10;
        dArray[10] = d11;
        dArray[11] = d12;
        return dArray;
    }

    private double[] getDeltaAberration(double d, double d2, double d3, double d4) {
        boolean bl = false;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double d5 = (d - 2451545.0) / 36525.0;
        double d6 = 20.49552;
        double d7 = this.getSolarTrueLongitude(d);
        double d8 = 0.016708634 - 4.2037E-5 * d5 - 1.267E-7 * d5 * d5;
        double d9 = 102.93735 + 1.71946 * d5 + 4.6E-4 * d5 * d5 * d5;
        if (bl) {
            System.out.println("J2000RA " + d2);
        }
        if (bl) {
            System.out.println("J2000DEC " + d3);
        }
        if (bl) {
            System.out.println("T " + d5);
        }
        if (bl) {
            System.out.println("kappa " + d6);
        }
        if (bl) {
            System.out.println("SL " + d7);
        }
        if (bl) {
            System.out.println("e " + d8);
        }
        if (bl) {
            System.out.println("pi " + d9);
        }
        if (bl) {
            System.out.println("epsilon " + d4);
        }
        double d10 = -d6 * (Math.cos(Math.toRadians(d2)) * Math.cos(Math.toRadians(d7)) * Math.cos(Math.toRadians(d4)) + Math.sin(Math.toRadians(d2)) * Math.sin(Math.toRadians(d7))) / Math.cos(Math.toRadians(d3)) + d8 * d6 * (Math.cos(Math.toRadians(d2)) * Math.cos(Math.toRadians(d9)) * Math.cos(Math.toRadians(d4)) + Math.sin(Math.toRadians(d2)) * Math.sin(Math.toRadians(d9))) / Math.cos(Math.toRadians(d3));
        double d11 = -d6 * (Math.cos(Math.toRadians(d7)) * Math.cos(Math.toRadians(d4)) * (Math.tan(Math.toRadians(d4)) * Math.cos(Math.toRadians(d3)) - Math.sin(Math.toRadians(d2)) * Math.sin(Math.toRadians(d3))) + Math.cos(Math.toRadians(d2)) * Math.sin(Math.toRadians(d3)) * Math.sin(Math.toRadians(d7))) + d8 * d6 * (Math.cos(Math.toRadians(d9)) * Math.cos(Math.toRadians(d4)) * (Math.tan(Math.toRadians(d4)) * Math.cos(Math.toRadians(d3)) - Math.sin(Math.toRadians(d2)) * Math.sin(Math.toRadians(d3))) + Math.cos(Math.toRadians(d2)) * Math.sin(Math.toRadians(d3)) * Math.sin(Math.toRadians(d9)));
        if (this.sqm_DisableAberration) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        } else {
            dArray[0] = d10 / 3600.0;
            dArray[1] = d11 / 3600.0;
        }
        dArray[2] = d7;
        dArray[3] = d8;
        dArray[4] = d9;
        if (bl) {
            System.out.println("T = " + d5);
        }
        if (bl) {
            System.out.println("e = " + d8);
        }
        if (bl) {
            System.out.println("pi = " + d9);
        }
        return dArray;
    }

    private double getSolarTrueLongitude(double d) {
        boolean bl = false;
        double d2 = 0.0;
        double d3 = (d - 2451545.0) / 36525.0;
        double d4 = 280.46646 + 36000.76983 * d3 + 3.032E-4 * d3 * d3;
        double d5 = 357.52911 + 35999.05029 * d3 - 1.537E-4 * d3 * d3;
        double d6 = 0.016708634 - 4.2037E-5 * d3 - 1.267E-7 * d3 * d3;
        double d7 = (1.914602 - 0.004817 * d3 - 1.4E-5 * d3 * d3) * Math.sin(Math.toRadians(d5)) + (0.019993 - 1.01E-4 * d3) * Math.sin(Math.toRadians(2.0 * d5)) + 2.89E-4 * Math.sin(Math.toRadians(3.0 * d5));
        d2 = d4 + d7;
        d2 /= 360.0;
        d2 = (d2 - Math.floor(d2)) * 360.0;
        if (bl) {
            System.out.println("solarTrueLongitude: " + d2);
        }
        return d2;
    }

    private double getSolarApparentLongitude(double d, double d2) {
        double d3;
        boolean bl = false;
        double d4 = 0.0;
        double d5 = (d - 2451545.0) / 36525.0;
        double d6 = 125.04 - 1934.136 * d5;
        d4 = d3 = d2 - 0.00569 - 0.00478 * Math.sin(Math.toRadians(d6));
        if (bl) {
            System.out.println("solarApparentLongitude: " + d4);
        }
        return d4;
    }

    private double[] getNutation(double d) {
        boolean bl = false;
        double[] dArray = new double[]{0.0, 0.0};
        double d2 = (this.JDE(d) - 2451545.0) / 36525.0;
        double d3 = 297.85036 + 445267.11148 * d2 - 0.0019142 * d2 * d2 + d2 * d2 * d2 / 189474.0;
        double d4 = 357.52772 + 35999.05034 * d2 - 1.603E-4 * d2 * d2 - d2 * d2 * d2 / 300000.0;
        double d5 = 134.96298 + 477198.867398 * d2 + 0.0086972 * d2 * d2 + d2 * d2 * d2 / 56250.0;
        double d6 = 93.27191 + 483202.017538 * d2 - 0.0036825 * d2 * d2 + d2 * d2 * d2 / 327270.0;
        double d7 = 125.04452 - 1934.136261 * d2 + 0.0020708 * d2 * d2 + d2 * d2 * d2 / 450000.0;
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 0.0, 1.0, -171996.0 - 174.2 * d2, 92025.0 + 8.9 * d2}, {-2.0, 0.0, 0.0, 2.0, 2.0, -13187.0 - 1.6 * d2, 5736.0 - 3.1 * d2}, {0.0, 0.0, 0.0, 2.0, 2.0, -2274.0 - 0.2 * d2, 977.0 - 0.5 * d2}, {0.0, 0.0, 0.0, 0.0, 2.0, 2062.0 + 0.2 * d2, -895.0 + 0.5 * d2}, {0.0, 1.0, 0.0, 0.0, 0.0, 1426.0 - 3.4 * d2, 54.0 - 0.1 * d2}, {0.0, 0.0, 1.0, 0.0, 0.0, 712.0 + 0.1 * d2, -7.0}, {-2.0, 1.0, 0.0, 2.0, 2.0, -517.0 + 1.2 * d2, 224.0 - 0.6 * d2}, {0.0, 0.0, 0.0, 2.0, 1.0, -386.0 - 0.4 * d2, 200.0}, {0.0, 0.0, 1.0, 2.0, 2.0, -301.0, 129.0 - 0.1 * d2}, {-2.0, -1.0, 0.0, 2.0, 2.0, 217.0 - 0.5 * d2, -95.0 + 0.3 * d2}, {-2.0, 0.0, 1.0, 0.0, 0.0, -158.0, 0.0}, {-2.0, 0.0, 0.0, 2.0, 1.0, 129.0 + 0.1 * d2, -70.0}, {0.0, 0.0, -1.0, 2.0, 2.0, 123.0, -53.0}, {2.0, 0.0, 0.0, 0.0, 0.0, 63.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, 63.0 + 0.1 * d2, -33.0}, {2.0, 0.0, -1.0, 2.0, 2.0, -59.0, 26.0}, {0.0, 0.0, -1.0, 0.0, 1.0, -58.0 - 0.1 * d2, 32.0}, {0.0, 0.0, 1.0, 2.0, 1.0, -51.0, 27.0}, {-2.0, 0.0, 2.0, 0.0, 0.0, 48.0, 0.0}, {0.0, 0.0, -2.0, 2.0, 1.0, 46.0, -24.0}, {2.0, 0.0, 0.0, 2.0, 2.0, -38.0, 16.0}, {0.0, 0.0, 2.0, 2.0, 2.0, -31.0, 13.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 29.0, 0.0}, {-2.0, 0.0, 1.0, 2.0, 2.0, 29.0, -12.0}, {0.0, 0.0, 0.0, 2.0, 0.0, 26.0, 0.0}, {-2.0, 0.0, 0.0, 2.0, 0.0, -22.0, 0.0}, {0.0, 0.0, -1.0, 2.0, 1.0, 21.0, -10.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 17.0 - 0.1 * d2, 0.0}, {2.0, 0.0, -1.0, 0.0, 1.0, 16.0, -8.0}, {-2.0, 2.0, 0.0, 2.0, 2.0, -16.0 + 0.1 * d2, 7.0}, {0.0, 1.0, 0.0, 0.0, 1.0, -15.0, 9.0}, {-2.0, 0.0, 1.0, 0.0, 1.0, -13.0, 7.0}, {0.0, -1.0, 0.0, 0.0, 1.0, -12.0, 6.0}, {0.0, 0.0, 2.0, -2.0, 0.0, 11.0, 0.0}, {2.0, 0.0, -1.0, 2.0, 1.0, -10.0, 5.0}, {2.0, 0.0, 1.0, 2.0, 2.0, -8.0, 3.0}, {0.0, 1.0, 0.0, 2.0, 2.0, 7.0, -3.0}, {-2.0, 1.0, 1.0, 0.0, 0.0, -7.0, 0.0}, {0.0, -1.0, 0.0, 2.0, 2.0, -7.0, 3.0}, {2.0, 0.0, 0.0, 2.0, 1.0, -7.0, 3.0}, {2.0, 0.0, 1.0, 0.0, 0.0, 6.0, 0.0}, {-2.0, 0.0, 2.0, 2.0, 2.0, 6.0, -3.0}, {-2.0, 0.0, 1.0, 2.0, 1.0, 6.0, -3.0}, {2.0, 0.0, -2.0, 0.0, 1.0, -6.0, 3.0}, {2.0, 0.0, 0.0, 0.0, 1.0, -6.0, 3.0}, {0.0, -1.0, 1.0, 0.0, 0.0, 5.0, 0.0}, {-2.0, -1.0, 0.0, 2.0, 1.0, -5.0, 3.0}, {-2.0, 0.0, 0.0, 0.0, 1.0, -5.0, 3.0}, {0.0, 0.0, 2.0, 2.0, 1.0, -5.0, 3.0}, {-2.0, 0.0, 2.0, 0.0, 1.0, 4.0, 0.0}, {-2.0, 1.0, 0.0, 2.0, 1.0, 4.0, 0.0}, {0.0, 0.0, 1.0, -2.0, 0.0, 4.0, 0.0}, {-1.0, 0.0, 1.0, 0.0, 0.0, -4.0, 0.0}, {-2.0, 1.0, 0.0, 0.0, 0.0, -4.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, -4.0, 0.0}, {0.0, 0.0, 1.0, 2.0, 0.0, 3.0, 0.0}, {0.0, 0.0, -2.0, 2.0, 2.0, -3.0, 0.0}, {-1.0, -1.0, 1.0, 0.0, 0.0, -3.0, 0.0}, {0.0, 1.0, 1.0, 0.0, 0.0, -3.0, 0.0}, {0.0, -1.0, 1.0, 2.0, 2.0, -3.0, 0.0}, {2.0, -1.0, -1.0, 2.0, 2.0, -3.0, 0.0}, {0.0, 0.0, 3.0, 2.0, 2.0, -3.0, 0.0}, {2.0, -1.0, 0.0, 2.0, 2.0, -3.0, 0.0}};
        double d8 = 0.0;
        double d9 = 0.0;
        for (int i = 0; i < dArrayArray.length; ++i) {
            d8 += Math.sin(Math.toRadians(dArrayArray[i][0] * d3 + dArrayArray[i][1] * d4 + dArrayArray[i][2] * d5 + dArrayArray[i][3] * d6 + dArrayArray[i][4] * d7)) * dArrayArray[i][5] / 10000.0;
            d9 += Math.cos(Math.toRadians(dArrayArray[i][0] * d3 + dArrayArray[i][1] * d4 + dArrayArray[i][2] * d5 + dArrayArray[i][3] * d6 + dArrayArray[i][4] * d7)) * dArrayArray[i][6] / 10000.0;
        }
        if (bl) {
            System.out.println("T " + d2);
        }
        if (bl) {
            System.out.println("D " + d3);
        }
        if (bl) {
            System.out.println("M " + d4);
        }
        if (bl) {
            System.out.println("Ma " + d5);
        }
        if (bl) {
            System.out.println("F " + d6);
        }
        if (bl) {
            System.out.println("O " + d7);
        }
        if (bl) {
            System.out.println("DeltaPsie " + d8);
        }
        if (bl) {
            System.out.println("DeltaEpsi " + d9);
        }
        dArray[0] = d8 / 3600.0;
        dArray[1] = d9 / 3600.0;
        return dArray;
    }

    private double[] getPrecession(double d, double d2, double d3) {
        double d4;
        double d5;
        boolean bl = false;
        double[] dArray = new double[]{0.0, 0.0};
        double d6 = (this.JD(2000, 1, 1.5) - 2451545.0) / 36525.0;
        double d7 = (d - this.JD(2000, 1, 1.5)) / 36525.0;
        if (bl) {
            System.out.println("t: " + d7);
        }
        double d8 = (2306.2181 + 1.39656 * d6 - 1.39E-4 * d6 * d6) * d7 + (0.30188 - 3.44E-4 * d6) * d7 * d7 + 0.017998 * d7 * d7 * d7;
        double d9 = (2306.2181 + 1.39656 * d6 - 1.39E-4 * d6 * d6) * d7 + (1.09468 + 6.6E-5 * d6) * d7 * d7 + 0.018203 * d7 * d7 * d7;
        double d10 = (2004.3109 - 0.8533 * d6 - 2.17E-4 * d6 * d6) * d7 - (0.42665 + 2.17E-4 * d6) * d7 * d7 - 0.041833 * d7 * d7 * d7;
        if (bl) {
            System.out.println("eta " + d8);
        }
        if (bl) {
            System.out.println("zeta " + d9);
        }
        if (bl) {
            System.out.println("theta " + d10);
        }
        d8 /= 3600.0;
        d9 /= 3600.0;
        d10 /= 3600.0;
        if (bl) {
            System.out.println("eta " + d8);
        }
        if (bl) {
            System.out.println("zeta " + d9);
        }
        if (bl) {
            System.out.println("theta " + d10);
        }
        double d11 = Math.cos(Math.toRadians(d3)) * Math.sin(Math.toRadians(d2 + d8));
        double d12 = Math.cos(Math.toRadians(d10)) * Math.cos(Math.toRadians(d3)) * Math.cos(Math.toRadians(d2 + d8)) - Math.sin(Math.toRadians(d10)) * Math.sin(Math.toRadians(d3));
        double d13 = Math.sin(Math.toRadians(d10)) * Math.cos(Math.toRadians(d3)) * Math.cos(Math.toRadians(d2 + d8)) + Math.cos(Math.toRadians(d10)) * Math.sin(Math.toRadians(d3));
        if (bl) {
            System.out.println("A " + d11);
        }
        if (bl) {
            System.out.println("B " + d12);
        }
        if (bl) {
            System.out.println("C " + d13);
        }
        if ((d5 = (d4 = Math.toDegrees(Math.atan2(d11, d12))) + d9) < 0.0) {
            d5 += 360.0;
        }
        double d14 = Math.toDegrees(Math.acos(Math.sqrt(d11 * d11 + d12 * d12)));
        if (Math.toDegrees(Math.asin(d13)) < 0.0) {
            d14 *= -1.0;
        }
        if (bl) {
            System.out.println("a_z " + d4);
        }
        if (bl) {
            System.out.println("ra " + d5);
        }
        if (bl) {
            System.out.println("dec " + d14);
        }
        dArray[0] = d5;
        dArray[1] = d14;
        return dArray;
    }

    private void readPrefs() {
        String string = "";
        File file = new File(sqm_PrefsFileName);
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.indexOf("[") == -1) continue;
                    switch (string.toLowerCase()) {
                        case "[astap path]": {
                            this.sqm_AstapPath = bufferedReader.readLine();
                            if (this.sqm_AstapPath == null) {
                                this.sqm_AstapPath = "";
                            }
                            System.out.println("ASTAP path: " + this.sqm_AstapPath);
                            break;
                        }
                        case "[latitude~~~]": {
                            this.sqm_Latitude = Double.valueOf(bufferedReader.readLine());
                            System.out.println("Latitude: " + this.sqm_Latitude);
                            break;
                        }
                        case "[longitude~~~]": {
                            this.sqm_Longitude = Double.valueOf(bufferedReader.readLine());
                            System.out.println("Longitude: " + this.sqm_Longitude);
                            break;
                        }
                        case "[disable  aberration (yes/no)]": {
                            this.sqm_DisableAberration = bufferedReader.readLine().toLowerCase().equals("yes");
                            System.out.println("Disable aberration: " + this.sqm_DisableAberration);
                            break;
                        }
                        case "[timestamp is (start,middle,end) of exposure]": {
                            this.sqm_ExpTimeBase = bufferedReader.readLine().toLowerCase();
                            System.out.println("Exposure Time Base: " + this.sqm_ExpTimeBase);
                            break;
                        }
                        case "[decimal sign]": {
                            char c = bufferedReader.readLine().charAt(0);
                            this.sqm_DecimalSign = c != '.' && c != ',' ? (char)46 : c;
                            System.out.println("Decimal sign: " + this.sqm_DecimalSign);
                            break;
                        }
                        case "[export failed plate-solves (yes/no)]": {
                            this.sqm_ExportFailedPlateSolves = bufferedReader.readLine().toLowerCase().equals("yes");
                            System.out.println("Export failed plate-solves: " + this.sqm_ExportFailedPlateSolves);
                        }
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.out.println("Error reading prefs file");
            }
        }
    }

    public void startGrab(String string) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String string2 = "FITSalize_results-" + simpleDateFormat.format(date) + ".csv";
        DecimalFormat decimalFormat = new DecimalFormat("#.#################");
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        try {
            this.readPrefs();
            if (this.sqm_DecimalSign == '.') {
                decimalFormatSymbols.setDecimalSeparator('.');
                decimalFormatSymbols.setGroupingSeparator(',');
            } else {
                decimalFormatSymbols.setDecimalSeparator(',');
                decimalFormatSymbols.setGroupingSeparator('.');
            }
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            String string3 = "";
            String string4 = "";
            String string5 = "\t";
            double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            String[] stringArray = this.getList(string);
            if (stringArray.length > 0) {
                BufferedWriter bufferedWriter = null;
                FileOutputStream fileOutputStream = new FileOutputStream(string2, false);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
                bufferedWriter.write("#" + string5 + "File" + string5 + "DateTime" + string5 + "Time of Day" + string5 + "JD" + string5 + "\u00ce\u00b1 FITS-Header [\u00c2\u00b0]" + string5 + "\u00ce\u00b4 FITS-Header [\u00c2\u00b0]" + string5 + "h FITS-Header [\u00c2\u00b0]" + string5 + "A FITS-Header [\u00c2\u00b0]" + string5 + "Ambient Temperature [\u00c2\u00b0C]" + string5 + "Focuser Temperature [\u00c2\u00b0C]" + string5 + "Focuser Position" + string5 + "Humidity [%]" + string5 + "Pressure [mbar]" + string5 + "Solved" + string5 + "\u00ce\u00b1 J2000 (ASTAP) [\u00c2\u00b0]" + string5 + "\u00ce\u00b4 J2000 (ASTAP) [\u00c2\u00b0]" + string5 + "\u00ce\u00b1 JNOW mean [\u00c2\u00b0]" + string5 + "\u00ce\u00b4 JNOW mean [\u00c2\u00b0]" + string5 + "\u00ce\u201d\u00cf\u02c6 [\u00c2\u00b0]" + string5 + "\u00ce\u201d\u00ce\u00b5 [\u00c2\u00b0]" + string5 + "\u00ce\u00b50 [\u00c2\u00b0]" + string5 + "\u00ce\u00b5 [\u00c2\u00b0]" + string5 + "\u00ce\u201d\u00ce\u00b1 nutation [\u00c2\u00b0]" + string5 + "\u00ce\u201d\u00ce\u00b4 nutation [\u00c2\u00b0]" + string5 + "\u00ce\u201d\u00ce\u00b1 aberration [\u00c2\u00b0]" + string5 + "\u00ce\u201d\u00ce\u00b4 aberration [\u00c2\u00b0]" + string5 + "\u00ce\u00b1 JNOW apparent [\u00c2\u00b0]" + string5 + "\u00ce\u00b4 JNOW apparent [\u00c2\u00b0]" + string5 + "LHA [\u00c2\u00b0]" + string5 + "Refraction [\u00c2\u00b0]" + string5 + "h JNOW apparent [\u00c2\u00b0]" + string5 + "A JNOW apparent [\u00c2\u00b0]" + string5 + "ASTAP SQM [magn/\"^2]" + System.getProperty("line.separator"));
                System.out.println("processing files");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string6 = stringArray[i];
                    System.out.print("Loading next file (" + stringArray[i] + ") ");
                    this.sqm_RotatorCounter = 0;
                    String[] stringArray2 = this.getFITSData(string + "/" + string6);
                    String[] stringArray3 = this.getASTAPData(string + "/" + string6);
                    bl = stringArray3[0].equals("1");
                    d7 = Double.valueOf(stringArray2[12]) / 24.0 / 3600.0 / 2.0;
                    d = Boolean.valueOf(stringArray2[13]) != false && stringArray2[0].indexOf("T") == -1 ? Double.valueOf(stringArray2[0]).doubleValue() : this.JD(Integer.valueOf(stringArray2[0].substring(0, 4)), Integer.valueOf(stringArray2[0].substring(5, 7)), Double.valueOf(stringArray2[0].substring(8, 10)) + Double.valueOf(stringArray2[0].substring(11, 13)) / 24.0 + Double.valueOf(stringArray2[0].substring(14, 16)) / 24.0 / 60.0 + Double.valueOf(stringArray2[0].substring(17)) / 24.0 / 3600.0);
                    switch (this.sqm_ExpTimeBase) {
                        case "start": {
                            d += d7;
                            break;
                        }
                        case "end": {
                            d -= d7;
                            break;
                        }
                    }
                    d4 = Double.valueOf(stringArray2[5]);
                    d3 = Double.valueOf(stringArray2[6]);
                    d5 = d4 * 1.0;
                    if (d4 != 0.0 && d3 == 0.0) {
                        d5 = d4 * 1.0;
                    }
                    if (d4 == 0.0 && d3 != 0.0) {
                        d5 = d3 * 1.0;
                    }
                    d6 = Double.valueOf(stringArray2[9]);
                    d2 = (d + 0.5) % 1.0;
                    if (bl) {
                        ++n;
                        dArray = this.getRaDecJNow(d, Double.valueOf(stringArray3[1]), Double.valueOf(stringArray3[2]));
                        dArray2 = this.getAltAzi(d, dArray[0], dArray[1], d6, d5);
                    } else {
                        int n3;
                        for (n3 = 0; n3 < dArray.length; ++n3) {
                            dArray[n3] = 0.0;
                        }
                        for (n3 = 0; n3 < dArray2.length; ++n3) {
                            dArray2[n3] = 0.0;
                        }
                        for (n3 = 0; n3 < stringArray3.length; ++n3) {
                            stringArray3[n3] = "0.0";
                        }
                    }
                    if (this.sqm_ExportFailedPlateSolves || bl) {
                        ++n2;
                        string5 = "\t";
                        string3 = i + 1 + string5 + string6.substring(0, string6.lastIndexOf(".")) + string5 + stringArray2[0] + string5 + decimalFormat.format(d2) + string5 + decimalFormat.format(d) + string5 + decimalFormat.format(Double.valueOf(stringArray2[1])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[2])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[3])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[4])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[5])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[6])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[7])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[8])) + string5 + decimalFormat.format(Double.valueOf(stringArray2[9])) + string5 + decimalFormat.format(Double.valueOf(stringArray3[0])) + string5 + decimalFormat.format(Double.valueOf(stringArray3[1])) + string5 + decimalFormat.format(Double.valueOf(stringArray3[2])) + string5;
                        string3 = bl ? string3 + decimalFormat.format((Object)dArray[2]) + string5 + decimalFormat.format((Object)dArray[3]) + string5 + decimalFormat.format((Object)dArray[8]) + string5 + decimalFormat.format((Object)dArray[9]) + string5 + decimalFormat.format((Object)dArray[10]) + string5 + decimalFormat.format((Object)dArray[11]) + string5 + decimalFormat.format((Object)dArray[4]) + string5 + decimalFormat.format((Object)dArray[5]) + string5 + decimalFormat.format((Object)dArray[6]) + string5 + decimalFormat.format((Object)dArray[7]) + string5 + decimalFormat.format((Object)dArray[0]) + string5 + decimalFormat.format((Object)dArray[1]) + string5 + decimalFormat.format(dArray2[2]) + string5 + decimalFormat.format(dArray2[3]) + string5 + decimalFormat.format(dArray2[0]) + string5 + decimalFormat.format(dArray2[1]) + string5 + decimalFormat.format(Double.valueOf(stringArray3[4])) : string3 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + string5 + "";
                        bufferedWriter.write(string3 + System.getProperty("line.separator"));
                    }
                    FITSalize.clearConsole();
                    string5 = System.getProperty("line.separator");
                    string4 = "File " + (i + 1) + "/" + stringArray.length + string5 + "Filename                   " + string6.substring(0, string6.lastIndexOf(".")) + string5 + "Site latitude              " + this.sqm_Latitude + " " + this.formatDMS(this.sqm_Latitude) + string5 + "Site longitude             " + this.sqm_Longitude + " " + this.formatDMS(this.sqm_Longitude) + string5 + "DateTime                   " + stringArray2[0] + string5 + "Time of day                " + d2 + " " + this.formatHMS(d2 * 24.0 * 15.0) + string5 + "Time-Base                  " + this.sqm_ExpTimeBase + " of exposure" + string5 + "Exposure                   " + String.format("%.3f", d7 * 3600.0 * 24.0 * 2.0).replace(",", ".") + " seconds" + string5 + "Julian date                " + decimalFormat.format(d) + " " + string5 + "Header RA                  " + decimalFormat.format(Double.valueOf(stringArray2[1])) + string5 + "Header DEC                 " + decimalFormat.format(Double.valueOf(stringArray2[2])) + string5 + "Header Alt                 " + decimalFormat.format(Double.valueOf(stringArray2[3])) + string5 + "Header Azi                 " + decimalFormat.format(Double.valueOf(stringArray2[4])) + string5 + "Header Ambient Temperature " + decimalFormat.format(Double.valueOf(stringArray2[5])) + string5 + "Header Focuser Temperature " + decimalFormat.format(Double.valueOf(stringArray2[6])) + string5 + "Header Focuser Position    " + decimalFormat.format(Double.valueOf(stringArray2[7])) + string5 + "Humidity                   " + decimalFormat.format(Double.valueOf(stringArray2[8])) + string5 + "Pressure                   " + decimalFormat.format(Double.valueOf(stringArray2[9])) + string5 + "Solved                     " + decimalFormat.format(Double.valueOf(stringArray3[0])) + string5 + "ASTAP RA                   " + decimalFormat.format(Double.valueOf(stringArray3[1])) + string5 + "ASTAP DEC                  " + decimalFormat.format(Double.valueOf(stringArray3[2])) + string5 + "JNOW RA                    " + decimalFormat.format((Object)dArray[0]) + string5 + "JNOW DEC                   " + decimalFormat.format((Object)dArray[1]) + string5 + "JNOW Alt                   " + decimalFormat.format((Object)dArray2[0]) + string5 + "JNOW Azi                   " + decimalFormat.format((Object)dArray2[1]) + string5 + "ASTAP SQM                  " + decimalFormat.format(Double.valueOf(stringArray3[4])) + string5;
                    System.out.println(string4);
                    System.out.println("Working... (press [CTRL][c] to cancel)");
                }
                bufferedWriter.write("\tGenerated on " + simpleDateFormat.format(date) + System.getProperty("line.separator"));
                bufferedWriter.write("\tProcessed " + stringArray.length + " FITS in folder: " + string + System.getProperty("line.separator"));
                bufferedWriter.write("\t" + n + " plate-solved, " + n2 + " results stored." + System.getProperty("line.separator"));
                bufferedWriter.write("\t" + sqm_Version + System.getProperty("line.separator"));
                ((Writer)bufferedWriter).flush();
                ((Writer)bufferedWriter).close();
                System.out.println(System.getProperty("line.separator"));
                System.out.println(stringArray.length + " FITS files processed, " + n + " plate-solved, " + n2 + " results stored in " + string2 + System.getProperty("line.separator"));
                System.out.println("RDY!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println();
        System.out.println(sqm_Version);
        System.exit(0);
    }
}

